/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.scripting;

import org.infinispan.commons.CacheException;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.scripting.ScriptingManager;
import org.infinispan.scripting.ScriptingTests;
import org.infinispan.tasks.TaskContext;
import org.infinispan.tasks.TaskManager;
import org.infinispan.test.SingleCacheManagerTest;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="scripting.ScriptingTaskManagerTest")
public class ScriptingTaskManagerTest
extends SingleCacheManagerTest {
    protected static final String TEST_SCRIPT = "test.js";
    protected static final String BROKEN_SCRIPT = "brokenTest.js";
    protected TaskManager taskManager;

    protected EmbeddedCacheManager createCacheManager() throws Exception {
        return TestCacheManagerFactory.createCacheManager();
    }

    protected void setup() throws Exception {
        super.setup();
        this.taskManager = (TaskManager)this.cacheManager.getGlobalComponentRegistry().getComponent(TaskManager.class);
    }

    public void testTask() throws Exception {
        ScriptingManager scriptingManager = (ScriptingManager)this.cacheManager.getGlobalComponentRegistry().getComponent(ScriptingManager.class);
        ScriptingTests.loadScript(scriptingManager, TEST_SCRIPT);
        String result = (String)this.taskManager.runTask(TEST_SCRIPT, new TaskContext().addParameter("a", (Object)"a")).get();
        AssertJUnit.assertEquals((String)"a", (String)result);
    }

    @Test(expectedExceptions={CacheException.class}, expectedExceptionsMessageRegExp="ISPN026003.*")
    public void testBrokenTask() throws Exception {
        ScriptingManager scriptingManager = (ScriptingManager)this.cacheManager.getGlobalComponentRegistry().getComponent(ScriptingManager.class);
        ScriptingTests.loadScript(scriptingManager, BROKEN_SCRIPT);
        this.taskManager.runTask(BROKEN_SCRIPT, new TaskContext()).get();
    }
}

