/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.scripting;

import org.infinispan.commons.CacheException;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.scripting.ScriptingManager;
import org.infinispan.scripting.ScriptingTests;
import org.infinispan.tasks.TaskContext;
import org.infinispan.test.SingleCacheManagerTest;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="scripting.ScriptingTest")
public class ScriptingTest
extends SingleCacheManagerTest {
    protected ScriptingManager scriptingManager;

    protected EmbeddedCacheManager createCacheManager() throws Exception {
        return TestCacheManagerFactory.createCacheManager();
    }

    protected void setup() throws Exception {
        super.setup();
        this.scriptingManager = (ScriptingManager)this.cacheManager.getGlobalComponentRegistry().getComponent(ScriptingManager.class);
    }

    public void testSimpleScript() throws Exception {
        ScriptingTests.loadScript(this.scriptingManager, "test.js");
        String result = (String)this.scriptingManager.runScript("test.js", new TaskContext().addParameter("a", (Object)"a")).get();
        AssertJUnit.assertEquals((String)"a", (String)result);
    }

    @Test(expectedExceptions={CacheException.class}, expectedExceptionsMessageRegExp="ISPN026005:.*")
    public void testScriptRemove() throws Exception {
        ScriptingTests.loadScript(this.scriptingManager, "test.js");
        this.scriptingManager.getScript("test.js");
        this.scriptingManager.removeScript("test.js");
        this.scriptingManager.getScript("test.js");
    }
}

