/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.scripting.impl;

import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.infinispan.Cache;
import org.infinispan.commons.util.concurrent.NotifyingFuture;
import org.infinispan.distexec.DefaultExecutorService;
import org.infinispan.scripting.impl.CacheScriptBindings;
import org.infinispan.scripting.impl.DistributedScript;
import org.infinispan.scripting.impl.ScriptMetadata;
import org.infinispan.scripting.impl.ScriptRunner;
import org.infinispan.scripting.impl.ScriptingManagerImpl;
import org.infinispan.scripting.impl.SystemBindings;
import org.infinispan.scripting.logging.Log;
import org.infinispan.util.concurrent.CompletableFutures;
import org.infinispan.util.logging.LogFactory;

public class DistributedRunner
implements ScriptRunner {
    private static final Log log = (Log)LogFactory.getLog(MethodHandles.lookup().lookupClass(), Log.class);
    public static final DistributedRunner INSTANCE = new DistributedRunner();

    private DistributedRunner() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> CompletableFuture<T> runScript(ScriptingManagerImpl scriptManager, ScriptMetadata metadata, CacheScriptBindings binding) {
        Cache masterCacheNode = (Cache)binding.get(SystemBindings.CACHE.toString());
        if (masterCacheNode == null) {
            throw log.distributedTaskNeedCacheInBinding(metadata.name());
        }
        DefaultExecutorService des = new DefaultExecutorService(masterCacheNode);
        try {
            List tasks = des.submitEverywhere(new DistributedScript(metadata));
            ArrayList all = new ArrayList(tasks.size());
            tasks.forEach(task -> all.add(CompletableFutures.toCompletableFuture((NotifyingFuture)((NotifyingFuture)task))));
            CompletableFuture completableFuture = CompletableFutures.sequence(all);
            return completableFuture;
        }
        finally {
            des.shutdown();
        }
    }
}

