/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.scripting;

import java.util.Arrays;
import org.infinispan.commons.CacheException;
import org.infinispan.scripting.impl.ScriptMetadata;
import org.infinispan.scripting.impl.ScriptMetadataParser;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="scripting.ScriptMetadataTest")
public class ScriptMetadataTest {
    public void testDoubleSlashComment() throws Exception {
        ScriptMetadata metadata = ScriptMetadataParser.parse((String)"test.js", (String)"// name=test");
        AssertJUnit.assertEquals((String)"test", (String)metadata.name());
    }

    public void testDefaultScriptExtension() throws Exception {
        ScriptMetadata metadata = ScriptMetadataParser.parse((String)"test", (String)"// name=test");
        AssertJUnit.assertEquals((String)"test", (String)metadata.name());
    }

    public void testDefaultScriptExtension1() {
        ScriptMetadata metadata = ScriptMetadataParser.parse((String)"test.", (String)"/* name=exampleName */");
        AssertJUnit.assertEquals((String)"test.", (String)metadata.name());
    }

    public void testHashComment() throws Exception {
        ScriptMetadata metadata = ScriptMetadataParser.parse((String)"test.js", (String)"# name=test");
        AssertJUnit.assertEquals((String)"test", (String)metadata.name());
    }

    public void testDoublSemicolonComment() throws Exception {
        ScriptMetadata metadata = ScriptMetadataParser.parse((String)"test.js", (String)";; name=test");
        AssertJUnit.assertEquals((String)"test", (String)metadata.name());
    }

    public void testMultiplePairs() throws Exception {
        ScriptMetadata metadata = ScriptMetadataParser.parse((String)"test.scala", (String)"// name=test,language=scala");
        AssertJUnit.assertEquals((String)"test", (String)metadata.name());
        AssertJUnit.assertEquals((String)"scala", (String)((String)metadata.language().get()));
    }

    public void testDoubleQuotedValues() throws Exception {
        ScriptMetadata metadata = ScriptMetadataParser.parse((String)"test.scala", (String)"// name=\"te,st\",language=scala");
        AssertJUnit.assertEquals((String)"te,st", (String)metadata.name());
        AssertJUnit.assertEquals((String)"scala", (String)((String)metadata.language().get()));
    }

    public void testSingleQuotedValues() throws Exception {
        ScriptMetadata metadata = ScriptMetadataParser.parse((String)"test.scala", (String)"// name='te,st',language=scala");
        AssertJUnit.assertEquals((String)"te,st", (String)metadata.name());
        AssertJUnit.assertEquals((String)"scala", (String)((String)metadata.language().get()));
    }

    public void testSingleQuatedValuesWithProvidedExtension() throws Exception {
        ScriptMetadata metadata = ScriptMetadataParser.parse((String)"test", (String)"// name='te,st',language=scala,extension=scala");
        AssertJUnit.assertEquals((String)"te,st", (String)metadata.name());
        AssertJUnit.assertEquals((String)"scala", (String)((String)metadata.language().get()));
        AssertJUnit.assertEquals((String)"scala", (String)metadata.extension());
    }

    public void testArrayValues() throws Exception {
        ScriptMetadata metadata = ScriptMetadataParser.parse((String)"test.scala", (String)"// name=test,language=javascript,parameters=[a,b,c]");
        AssertJUnit.assertEquals((String)"test", (String)metadata.name());
        AssertJUnit.assertEquals((String)"javascript", (String)((String)metadata.language().get()));
        AssertJUnit.assertTrue((boolean)metadata.parameters().containsAll(Arrays.asList("a", "b", "c")));
    }

    public void testMultiLine() throws Exception {
        ScriptMetadata metadata = ScriptMetadataParser.parse((String)"test.scala", (String)"// name=test\n// language=scala");
        AssertJUnit.assertEquals((String)"test", (String)metadata.name());
        AssertJUnit.assertEquals((String)"scala", (String)((String)metadata.language().get()));
    }

    @Test(expectedExceptions={IllegalArgumentException.class}, expectedExceptionsMessageRegExp=".*Script parameters must be declared using.*")
    public void testBrokenParameters() throws Exception {
        ScriptMetadata metadata = ScriptMetadataParser.parse((String)"test.scala", (String)"// name=test,language=javascript,parameters=\"a,b,c\"");
        AssertJUnit.assertEquals((String)"test", (String)metadata.name());
        AssertJUnit.assertEquals((Object)"javascript", (Object)metadata.language());
        AssertJUnit.assertTrue((boolean)metadata.parameters().containsAll(Arrays.asList("a", "b", "c")));
    }

    @Test(expectedExceptions={CacheException.class}, expectedExceptionsMessageRegExp=".*Unknown script mode:.*")
    public void testUnknownScriptProperty() throws Exception {
        ScriptMetadata metadata = ScriptMetadataParser.parse((String)"test.scala", (String)"// name=test,language=javascript,parameters=[a,b,c],unknown=example");
        AssertJUnit.assertEquals((String)"test", (String)metadata.name());
        AssertJUnit.assertEquals((Object)"javascript", (Object)metadata.language());
        AssertJUnit.assertTrue((boolean)metadata.parameters().containsAll(Arrays.asList("a", "b", "c")));
    }
}

