/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.scripting;

import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import org.infinispan.Cache;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.scripting.ScriptingManager;
import org.infinispan.scripting.utils.ScriptingUtils;
import org.infinispan.tasks.TaskContext;
import org.infinispan.test.MultipleCacheManagersTest;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="scripting.ClusteredScriptingTest")
public class ClusteredScriptingTest
extends MultipleCacheManagersTest {
    protected void createCacheManagers() throws Exception {
        ConfigurationBuilder conf = ClusteredScriptingTest.getDefaultClusteredCacheConfig((CacheMode)CacheMode.REPL_SYNC, (boolean)false);
        this.createCluster(conf, 2);
        this.waitForClusterToForm();
    }

    private void executeScriptOnManager(int num, String scriptName) throws InterruptedException, ExecutionException {
        ScriptingManager scriptingManager = ScriptingUtils.getScriptingManager(this.manager(num));
        String s = (String)scriptingManager.runScript(scriptName, new TaskContext().addParameter("a", (Object)"a")).get();
        AssertJUnit.assertEquals((String)"a", (String)s);
    }

    public void testClusteredScriptExec() throws IOException, InterruptedException, ExecutionException {
        ScriptingManager scriptingManager = ScriptingUtils.getScriptingManager(this.manager(0));
        ScriptingUtils.loadScript(scriptingManager, "/test.js");
        this.executeScriptOnManager(0, "test.js");
        this.executeScriptOnManager(1, "test.js");
    }

    public void testDistExecScript() throws IOException, InterruptedException, ExecutionException {
        ScriptingManager scriptingManager = ScriptingUtils.getScriptingManager(this.manager(0));
        ScriptingUtils.loadScript(scriptingManager, "/distExec.js");
        CompletableFuture resultsFuture = scriptingManager.runScript("distExec.js", new TaskContext().cache(this.cache(0)));
        ArrayList results = (ArrayList)resultsFuture.get();
        AssertJUnit.assertEquals((int)2, (int)results.size());
        AssertJUnit.assertTrue((boolean)results.contains(this.manager(0).getAddress()));
        AssertJUnit.assertTrue((boolean)results.contains(this.manager(1).getAddress()));
    }

    @Test(expectedExceptions={IllegalStateException.class}, expectedExceptionsMessageRegExp=".*without a cache binding.*")
    public void testDistributedScriptExecutionWithoutCacheBinding() throws IOException, ExecutionException, InterruptedException {
        ScriptingManager scriptingManager = ScriptingUtils.getScriptingManager(this.manager(0));
        ScriptingUtils.loadScript(scriptingManager, "/distExec.js");
        scriptingManager.runScript("distExec.js").get();
    }

    @Test(enabled=false, description="Disabled due to ISPN-6173.")
    public void testClusteredScriptStream() throws InterruptedException, ExecutionException, IOException {
        ScriptingManager scriptingManager = ScriptingUtils.getScriptingManager(this.manager(0));
        Cache cache = this.cache(0);
        ScriptingUtils.loadData((Cache<String, String>)cache, "/macbeth.txt");
        ScriptingUtils.loadScript(scriptingManager, "/wordCountStream.js");
        CompletableFuture resultsFuture = scriptingManager.runScript("wordCountStream.js", new TaskContext().cache(this.cache(0)));
        Map results = (Map)resultsFuture.get();
        AssertJUnit.assertEquals((int)3209, (int)results.size());
        AssertJUnit.assertEquals(results.get("macbeth"), (Object)287L);
    }

    @Test(enabled=false, description="Disabled due to ISPN-6173.")
    public void testDistributedMapReduceStream() throws IOException, ExecutionException, InterruptedException {
        ScriptingManager scriptingManager = ScriptingUtils.getScriptingManager(this.manager(0));
        Cache cache = this.cache(0);
        ScriptingUtils.loadData((Cache<String, String>)cache, "/macbeth.txt");
        ScriptingUtils.loadScript(scriptingManager, "/wordCountStream_dist.js");
        ArrayList resultsFuture = (ArrayList)scriptingManager.runScript("wordCountStream_dist.js", new TaskContext().cache(this.cache(0))).get();
        AssertJUnit.assertEquals((int)2, (int)resultsFuture.size());
        AssertJUnit.assertEquals((int)3209, (int)((Map)resultsFuture.get(0)).size());
        AssertJUnit.assertEquals((int)3209, (int)((Map)resultsFuture.get(1)).size());
        AssertJUnit.assertEquals(((Map)resultsFuture.get(0)).get("macbeth"), (Object)287L);
        AssertJUnit.assertEquals(((Map)resultsFuture.get(1)).get("macbeth"), (Object)287L);
    }

    public void testMapReduce() throws Exception {
        ScriptingManager scriptingManager = ScriptingUtils.getScriptingManager(this.manager(0));
        Cache cache = this.cache(0);
        ScriptingUtils.loadData((Cache<String, String>)cache, "/macbeth.txt");
        ScriptingUtils.loadScript(scriptingManager, "/wordCountMapper.js");
        ScriptingUtils.loadScript(scriptingManager, "/wordCountReducer.js");
        ScriptingUtils.loadScript(scriptingManager, "/wordCountCollator.js");
        CompletableFuture future = scriptingManager.runScript("wordCountMapper.js", new TaskContext().cache(cache));
        LinkedHashMap results = (LinkedHashMap)future.get();
        AssertJUnit.assertEquals((int)20, (int)results.size());
        AssertJUnit.assertTrue((boolean)((Double)results.get("macbeth")).equals(287.0));
    }

    @Test(expectedExceptions={IllegalArgumentException.class}, expectedExceptionsMessageRegExp=".*cannot be invoked directly since it specifies mode 'REDUCER'")
    public void testOnlyReduceTaskRun() throws Exception {
        ScriptingManager scriptingManager = ScriptingUtils.getScriptingManager(this.manager(0));
        Cache cache = this.cache(0);
        ScriptingUtils.loadData((Cache<String, String>)cache, "/macbeth.txt");
        ScriptingUtils.loadScript(scriptingManager, "/wordCountReducer.js");
        scriptingManager.runScript("wordCountReducer.js", new TaskContext().cache(cache));
    }
}

