/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.scripting;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import org.infinispan.Cache;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.scripting.ScriptingManager;
import org.infinispan.scripting.utils.ScriptingUtils;
import org.infinispan.tasks.TaskContext;
import org.infinispan.test.MultipleCacheManagersTest;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="scripting.DistributedCacheScriptingTest")
public class DistributedCacheScriptingTest
extends MultipleCacheManagersTest {
    protected void createCacheManagers() throws Throwable {
        ConfigurationBuilder conf = DistributedCacheScriptingTest.getDefaultClusteredCacheConfig((CacheMode)CacheMode.DIST_SYNC, (boolean)false);
        this.createCluster(conf, 4);
        this.waitForClusterToForm();
    }

    public void testDistributedScriptExecution() throws IOException, ExecutionException, InterruptedException {
        ScriptingManager scriptingManager = ScriptingUtils.getScriptingManager(this.manager(0));
        ScriptingUtils.loadScript(scriptingManager, "/distExec.js");
        List addressList = (List)scriptingManager.runScript("distExec.js", new TaskContext().cache(this.cache(0))).get();
        AssertJUnit.assertTrue((boolean)addressList.contains(this.manager(0).getAddress()));
        AssertJUnit.assertTrue((boolean)addressList.contains(this.manager(1).getAddress()));
        AssertJUnit.assertTrue((boolean)addressList.contains(this.manager(2).getAddress()));
        AssertJUnit.assertTrue((boolean)addressList.contains(this.manager(3).getAddress()));
    }

    @Test(enabled=false, description="Disabled until the bug ISPN-6173 is fixed.")
    public void testDistributedMapReduceStream() throws IOException, ExecutionException, InterruptedException {
        ScriptingManager scriptingManager = ScriptingUtils.getScriptingManager(this.manager(0));
        Cache cache = this.cache(0);
        ScriptingUtils.loadData((Cache<String, String>)cache, "/macbeth.txt");
        ScriptingUtils.loadScript(scriptingManager, "/wordCountStream_dist.js");
        ArrayList resultsFuture = (ArrayList)scriptingManager.runScript("wordCountStream_dist.js", new TaskContext().cache(this.cache(0))).get();
        AssertJUnit.assertEquals((int)2, (int)resultsFuture.size());
        AssertJUnit.assertEquals((int)3209, (int)((Map)resultsFuture.get(0)).size());
        AssertJUnit.assertEquals((int)3209, (int)((Map)resultsFuture.get(1)).size());
        AssertJUnit.assertEquals(((Map)resultsFuture.get(0)).get("macbeth"), (Object)287L);
        AssertJUnit.assertEquals(((Map)resultsFuture.get(1)).get("macbeth"), (Object)287L);
    }
}

