/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.scripting;

import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.List;
import javax.security.auth.Subject;
import org.infinispan.Cache;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.scripting.ScriptingManager;
import org.infinispan.scripting.utils.ScriptingUtils;
import org.infinispan.security.AuthorizationPermission;
import org.infinispan.security.PrincipalRoleMapper;
import org.infinispan.security.Security;
import org.infinispan.security.impl.IdentityRoleMapper;
import org.infinispan.tasks.TaskContext;
import org.infinispan.test.MultipleCacheManagersTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.CleanupAfterTest;
import org.junit.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="scripting.ReplicatedSecuredScriptingTest")
@CleanupAfterTest
public class ReplicatedSecuredScriptingTest
extends MultipleCacheManagersTest {
    static final Subject ADMIN = TestingUtil.makeSubject((String[])new String[]{"admin", "___script_manager"});
    static final Subject RUNNER = TestingUtil.makeSubject((String[])new String[]{"runner", "runner"});
    static final Subject PHEIDIPPIDES = TestingUtil.makeSubject((String[])new String[]{"pheidippides", "pheidippides"});

    protected void createCacheManagers() throws Throwable {
        final GlobalConfigurationBuilder global = GlobalConfigurationBuilder.defaultClusteredBuilder();
        final ConfigurationBuilder builder = ReplicatedSecuredScriptingTest.getDefaultClusteredCacheConfig((CacheMode)CacheMode.REPL_SYNC);
        global.security().authorization().enable().principalRoleMapper((PrincipalRoleMapper)new IdentityRoleMapper()).role("admin").permission(AuthorizationPermission.ALL).role("runner").permission(AuthorizationPermission.EXEC).permission(AuthorizationPermission.READ).permission(AuthorizationPermission.WRITE).permission(AuthorizationPermission.ADMIN).role("pheidippides").permission(AuthorizationPermission.EXEC).permission(AuthorizationPermission.READ).permission(AuthorizationPermission.WRITE);
        builder.security().authorization().enable().role("admin").role("runner").role("pheidippides");
        Security.doAs((Subject)ADMIN, (PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

            @Override
            public Void run() throws Exception {
                ReplicatedSecuredScriptingTest.this.createCluster(global, builder, 2);
                ReplicatedSecuredScriptingTest.this.waitForClusterToForm();
                return null;
            }
        });
    }

    @AfterClass(alwaysRun=true)
    protected void destroy() {
        Security.doAs((Subject)ADMIN, (PrivilegedAction)new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                ReplicatedSecuredScriptingTest.super.destroy();
                return null;
            }
        });
    }

    @AfterMethod(alwaysRun=true)
    protected void clearContent() throws Throwable {
        Security.doAs((Subject)ADMIN, (PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

            @Override
            public Void run() throws Exception {
                try {
                    ReplicatedSecuredScriptingTest.super.clearContent();
                }
                catch (Throwable e) {
                    throw new Exception(e);
                }
                return null;
            }
        });
    }

    public void testLocalScriptExecutionWithRole() throws Exception {
        final ScriptingManager scriptingManager = ScriptingUtils.getScriptingManager(this.manager(0));
        Security.doAs((Subject)ADMIN, (PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

            @Override
            public Void run() throws Exception {
                ScriptingUtils.loadScript(scriptingManager, "/testRole.js");
                return null;
            }
        });
        Security.doAs((Subject)PHEIDIPPIDES, (PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

            @Override
            public Void run() throws Exception {
                Cache cache = ReplicatedSecuredScriptingTest.this.manager(0).getCache();
                String value = (String)scriptingManager.runScript("testRole.js", new TaskContext().cache(cache).addParameter("a", (Object)"value")).get();
                Assert.assertEquals((Object)"value", (Object)value);
                Assert.assertEquals((Object)"value", (Object)cache.get((Object)"a"));
                return null;
            }
        });
    }

    @Test(expectedExceptions={PrivilegedActionException.class, SecurityException.class})
    public void testLocalScriptExecutionWithAuthException() throws Exception {
        final ScriptingManager scriptingManager = ScriptingUtils.getScriptingManager(this.manager(0));
        Security.doAs((Subject)ADMIN, (PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

            @Override
            public Void run() throws Exception {
                ScriptingUtils.loadScript(scriptingManager, "/testRole.js");
                return null;
            }
        });
        Security.doAs((Subject)RUNNER, (PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

            @Override
            public Void run() throws Exception {
                Cache cache = ReplicatedSecuredScriptingTest.this.manager(0).getCache();
                scriptingManager.runScript("testRole.js", new TaskContext().cache(cache).addParameter("a", (Object)"value")).get();
                return null;
            }
        });
    }

    @Test(enabled=false, description="Enable when ISPN-6374 is fixed.")
    public void testDistributedScriptExecutionWithRole() throws Exception {
        final ScriptingManager scriptingManager = ScriptingUtils.getScriptingManager(this.manager(0));
        Security.doAs((Subject)ADMIN, (PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

            @Override
            public Void run() throws Exception {
                ScriptingUtils.loadScript(scriptingManager, "/testRole_dist.js");
                return null;
            }
        });
        Security.doAs((Subject)RUNNER, (PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

            @Override
            public Void run() throws Exception {
                Cache cache = ReplicatedSecuredScriptingTest.this.manager(0).getCache();
                List value = (List)scriptingManager.runScript("testRole_dist.js", new TaskContext().cache(cache).addParameter("a", (Object)"value")).get();
                Assert.assertEquals(value.get(0), (Object)ReplicatedSecuredScriptingTest.this.manager(0).getAddress());
                Assert.assertEquals(value.get(1), (Object)ReplicatedSecuredScriptingTest.this.manager(1).getAddress());
                Assert.assertEquals((Object)"value", (Object)cache.get((Object)"a"));
                Assert.assertEquals((Object)"value", (Object)ReplicatedSecuredScriptingTest.this.manager(1).getCache().get((Object)"a"));
                return null;
            }
        });
    }

    @Test(expectedExceptions={PrivilegedActionException.class, SecurityException.class})
    public void testDistributedScriptExecutionWithAuthException() throws Exception {
        final ScriptingManager scriptingManager = ScriptingUtils.getScriptingManager(this.manager(0));
        Security.doAs((Subject)ADMIN, (PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

            @Override
            public Void run() throws Exception {
                ScriptingUtils.loadScript(scriptingManager, "/testRole_dist.js");
                return null;
            }
        });
        Security.doAs((Subject)PHEIDIPPIDES, (PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

            @Override
            public Void run() throws Exception {
                Cache cache = ReplicatedSecuredScriptingTest.this.manager(0).getCache();
                scriptingManager.runScript("testRole_dist.js", new TaskContext().cache(cache).addParameter("a", (Object)"value")).get();
                return null;
            }
        });
    }

    @DataProvider(name="cacheModeProvider")
    private static Object[][] providePrinciples() {
        return new Object[][]{{CacheMode.REPL_SYNC}, {CacheMode.DIST_SYNC}};
    }
}

