/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.scripting;

import java.io.InputStream;
import java.security.PrivilegedAction;
import java.security.PrivilegedExceptionAction;
import java.util.List;
import javax.security.auth.Subject;
import org.infinispan.Cache;
import org.infinispan.configuration.cache.AuthorizationConfigurationBuilder;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.global.GlobalAuthorizationConfigurationBuilder;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.scripting.impl.ScriptTask;
import org.infinispan.security.AuthorizationPermission;
import org.infinispan.security.PrincipalRoleMapper;
import org.infinispan.security.Security;
import org.infinispan.security.impl.IdentityRoleMapper;
import org.infinispan.tasks.TaskContext;
import org.infinispan.tasks.TaskExecutionMode;
import org.infinispan.tasks.TaskManager;
import org.infinispan.tasks.spi.TaskEngine;
import org.infinispan.test.SingleCacheManagerTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.CleanupAfterMethod;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="scripting.ScriptingTaskManagerTest")
@CleanupAfterMethod
public class SecureScriptingTaskManagerTest
extends SingleCacheManagerTest {
    protected static final String SCRIPT_NAME = "testRole.js";
    protected TaskManager taskManager;
    static final Subject ADMIN = TestingUtil.makeSubject((String[])new String[]{"admin", "___script_manager"});
    static final Subject RUNNER = TestingUtil.makeSubject((String[])new String[]{"runner", "runner"});
    static final Subject PHEIDIPPIDES = TestingUtil.makeSubject((String[])new String[]{"pheidippides", "pheidippides"});

    protected EmbeddedCacheManager createCacheManager() throws Exception {
        GlobalConfigurationBuilder global = new GlobalConfigurationBuilder();
        GlobalAuthorizationConfigurationBuilder globalRoles = global.security().authorization().enable().principalRoleMapper((PrincipalRoleMapper)new IdentityRoleMapper());
        ConfigurationBuilder config = TestCacheManagerFactory.getDefaultCacheConfiguration((boolean)true);
        AuthorizationConfigurationBuilder authConfig = config.security().authorization().enable();
        globalRoles.role("runner").permission(AuthorizationPermission.EXEC).permission(AuthorizationPermission.READ).permission(AuthorizationPermission.WRITE).role("pheidippides").permission(AuthorizationPermission.EXEC).permission(AuthorizationPermission.READ).permission(AuthorizationPermission.WRITE).role("admin").permission(AuthorizationPermission.ALL);
        authConfig.role("runner").role("pheidippides").role("admin");
        return TestCacheManagerFactory.createCacheManager((GlobalConfigurationBuilder)global, (ConfigurationBuilder)config);
    }

    protected void setup() throws Exception {
        Security.doAs((Subject)ADMIN, (PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

            @Override
            public Void run() throws Exception {
                SecureScriptingTaskManagerTest.super.setup();
                SecureScriptingTaskManagerTest.this.taskManager = (TaskManager)SecureScriptingTaskManagerTest.this.cacheManager.getGlobalComponentRegistry().getComponent(TaskManager.class);
                Cache scriptCache = SecureScriptingTaskManagerTest.this.cacheManager.getCache("___script_cache");
                try (InputStream is = this.getClass().getResourceAsStream("/testRole.js");){
                    String script = TestingUtil.loadFileAsString((InputStream)is);
                    scriptCache.put((Object)SecureScriptingTaskManagerTest.SCRIPT_NAME, (Object)script);
                }
                SecureScriptingTaskManagerTest.this.cacheManager.getCache("secured-script-exec");
                return null;
            }
        });
    }

    protected void teardown() {
        Security.doAs((Subject)ADMIN, (PrivilegedAction)new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                SecureScriptingTaskManagerTest.super.teardown();
                return null;
            }
        });
    }

    protected void clearContent() {
        Security.doAs((Subject)ADMIN, (PrivilegedAction)new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                SecureScriptingTaskManagerTest.this.cacheManager.getCache().clear();
                return null;
            }
        });
    }

    public void testTask() throws Exception {
        Security.doAs((Subject)PHEIDIPPIDES, (PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

            @Override
            public Void run() throws Exception {
                String result = null;
                result = (String)SecureScriptingTaskManagerTest.this.taskManager.runTask(SecureScriptingTaskManagerTest.SCRIPT_NAME, new TaskContext().addParameter("a", (Object)"a")).get();
                AssertJUnit.assertEquals((String)"a", (String)result);
                return null;
            }
        });
        List tasks = this.taskManager.getTasks();
        AssertJUnit.assertEquals((int)1, (int)tasks.size());
        ScriptTask scriptTask = (ScriptTask)tasks.get(0);
        AssertJUnit.assertEquals((String)SCRIPT_NAME, (String)scriptTask.getName());
        AssertJUnit.assertEquals((Object)TaskExecutionMode.ONE_NODE, (Object)scriptTask.getExecutionMode());
        AssertJUnit.assertEquals((String)"Script", (String)scriptTask.getType());
    }

    public void testAvailableEngines() {
        List engines = this.taskManager.getEngines();
        AssertJUnit.assertEquals((int)1, (int)engines.size());
        AssertJUnit.assertEquals((String)"Script", (String)((TaskEngine)engines.get(0)).getName());
    }
}

