/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.scripting;

import java.util.List;
import org.infinispan.commons.CacheException;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.scripting.ScriptingManager;
import org.infinispan.scripting.impl.ScriptTask;
import org.infinispan.scripting.utils.ScriptingUtils;
import org.infinispan.tasks.TaskContext;
import org.infinispan.tasks.TaskExecutionMode;
import org.infinispan.tasks.TaskManager;
import org.infinispan.tasks.spi.TaskEngine;
import org.infinispan.test.SingleCacheManagerTest;
import org.infinispan.test.fwk.CleanupAfterMethod;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="scripting.ScriptingTaskManagerTest")
@CleanupAfterMethod
public class ScriptingTaskManagerTest
extends SingleCacheManagerTest {
    protected static final String TEST_SCRIPT = "test.js";
    protected static final String BROKEN_SCRIPT = "brokenTest.js";
    protected TaskManager taskManager;

    protected EmbeddedCacheManager createCacheManager() throws Exception {
        return TestCacheManagerFactory.createCacheManager();
    }

    protected void setup() throws Exception {
        super.setup();
        this.taskManager = (TaskManager)this.cacheManager.getGlobalComponentRegistry().getComponent(TaskManager.class);
        this.cacheManager.defineConfiguration("script-exec", this.cacheManager.getDefaultCacheConfiguration());
    }

    public void testTask() throws Exception {
        ScriptingManager scriptingManager = (ScriptingManager)this.cacheManager.getGlobalComponentRegistry().getComponent(ScriptingManager.class);
        ScriptingUtils.loadScript(scriptingManager, TEST_SCRIPT);
        String result = (String)this.taskManager.runTask(TEST_SCRIPT, new TaskContext().addParameter("a", (Object)"a")).get();
        AssertJUnit.assertEquals((String)"a", (String)result);
        List tasks = this.taskManager.getTasks();
        AssertJUnit.assertEquals((int)1, (int)tasks.size());
        ScriptTask scriptTask = (ScriptTask)tasks.get(0);
        AssertJUnit.assertEquals((String)TEST_SCRIPT, (String)scriptTask.getName());
        AssertJUnit.assertEquals((Object)TaskExecutionMode.ONE_NODE, (Object)scriptTask.getExecutionMode());
        AssertJUnit.assertEquals((String)"Script", (String)scriptTask.getType());
    }

    public void testAvailableEngines() {
        List engines = this.taskManager.getEngines();
        AssertJUnit.assertEquals((int)1, (int)engines.size());
        AssertJUnit.assertEquals((String)"Script", (String)((TaskEngine)engines.get(0)).getName());
    }

    @Test(expectedExceptions={CacheException.class}, expectedExceptionsMessageRegExp=".*Script execution error.*")
    public void testBrokenTask() throws Exception {
        ScriptingManager scriptingManager = (ScriptingManager)this.cacheManager.getGlobalComponentRegistry().getComponent(ScriptingManager.class);
        ScriptingUtils.loadScript(scriptingManager, BROKEN_SCRIPT);
        this.taskManager.runTask(BROKEN_SCRIPT, new TaskContext()).get();
    }
}

