/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.scripting.impl;

import java.util.EnumSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentMap;
import java.util.function.BiFunction;
import java.util.function.Function;
import javax.script.Bindings;
import javax.script.Compilable;
import javax.script.CompiledScript;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import javax.script.SimpleBindings;
import org.infinispan.Cache;
import org.infinispan.commons.marshall.Marshaller;
import org.infinispan.commons.marshall.jboss.GenericJBossMarshaller;
import org.infinispan.commons.util.CollectionFactory;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.global.GlobalConfiguration;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.annotations.Start;
import org.infinispan.factories.scopes.Scope;
import org.infinispan.factories.scopes.Scopes;
import org.infinispan.interceptors.AsyncInterceptor;
import org.infinispan.interceptors.impl.CacheMgmtInterceptor;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.metadata.Metadata;
import org.infinispan.registry.InternalCacheRegistry;
import org.infinispan.scripting.ScriptingManager;
import org.infinispan.scripting.impl.CacheScriptBindings;
import org.infinispan.scripting.impl.DataTypedCache;
import org.infinispan.scripting.impl.DataTypedCacheManager;
import org.infinispan.scripting.impl.ScriptMetadata;
import org.infinispan.scripting.impl.ScriptMetadataParser;
import org.infinispan.scripting.impl.ScriptRunner;
import org.infinispan.scripting.impl.ScriptingInterceptor;
import org.infinispan.scripting.impl.ScriptingTaskEngine;
import org.infinispan.scripting.impl.SecurityActions;
import org.infinispan.scripting.impl.SystemBindings;
import org.infinispan.scripting.logging.Log;
import org.infinispan.security.AuthorizationManager;
import org.infinispan.security.AuthorizationPermission;
import org.infinispan.security.impl.AuthorizationHelper;
import org.infinispan.security.impl.CacheRoleImpl;
import org.infinispan.tasks.TaskContext;
import org.infinispan.tasks.TaskManager;
import org.infinispan.tasks.spi.TaskEngine;
import org.infinispan.util.logging.LogFactory;

@Scope(value=Scopes.GLOBAL)
public class ScriptingManagerImpl
implements ScriptingManager {
    private static final Log log = (Log)LogFactory.getLog(ScriptingManagerImpl.class, Log.class);
    private EmbeddedCacheManager cacheManager;
    private TaskManager taskManager;
    private ScriptEngineManager scriptEngineManager;
    private ConcurrentMap<String, ScriptEngine> scriptEnginesByExtension = CollectionFactory.makeConcurrentMap((int)2);
    private ConcurrentMap<String, ScriptEngine> scriptEnginesByLanguage = CollectionFactory.makeConcurrentMap((int)2);
    private Cache<String, String> scriptCache;
    ConcurrentMap<String, CompiledScript> compiledScripts = CollectionFactory.makeConcurrentMap();
    private AuthorizationHelper globalAuthzHelper;
    private final Function<String, ScriptEngine> getEngineByName = this::getEngineByName;
    private final Function<String, ScriptEngine> getEngineByExtension = this::getEngineByExtension;
    private InternalCacheRegistry internalCacheRegistry;

    @Inject
    public void initialize(EmbeddedCacheManager cacheManager, InternalCacheRegistry internalCacheRegistry, TaskManager taskManager) {
        this.cacheManager = cacheManager;
        this.taskManager = taskManager;
        this.internalCacheRegistry = internalCacheRegistry;
    }

    @Start
    public void start() {
        ClassLoader classLoader = this.cacheManager.getCacheManagerConfiguration().classLoader();
        this.scriptEngineManager = new ScriptEngineManager(classLoader);
        this.internalCacheRegistry.registerInternalCache("___script_cache", this.getScriptCacheConfiguration().build(), EnumSet.of(InternalCacheRegistry.Flag.USER, InternalCacheRegistry.Flag.PROTECTED, InternalCacheRegistry.Flag.PERSISTENT));
        this.taskManager.registerTaskEngine((TaskEngine)new ScriptingTaskEngine(this));
    }

    Cache<String, String> getScriptCache() {
        if (this.scriptCache == null) {
            this.scriptCache = this.cacheManager.getCache("___script_cache");
        }
        return this.scriptCache;
    }

    private ConfigurationBuilder getScriptCacheConfiguration() {
        GlobalConfiguration globalConfiguration = this.cacheManager.getGlobalComponentRegistry().getGlobalConfiguration();
        CacheMode cacheMode = globalConfiguration.isClustered() ? CacheMode.REPL_SYNC : CacheMode.LOCAL;
        ConfigurationBuilder cfg = new ConfigurationBuilder();
        cfg.clustering().cacheMode(cacheMode).sync().stateTransfer().fetchInMemoryState(true).awaitInitialTransfer(false).compatibility().enable().marshaller((Marshaller)new GenericJBossMarshaller()).customInterceptors().addInterceptor().interceptor((AsyncInterceptor)new ScriptingInterceptor()).before(CacheMgmtInterceptor.class);
        if (globalConfiguration.security().authorization().enabled()) {
            globalConfiguration.security().authorization().roles().put("___script_manager", new CacheRoleImpl("___script_manager", new AuthorizationPermission[]{AuthorizationPermission.ALL}));
            cfg.security().authorization().enable().role("___script_manager");
            this.globalAuthzHelper = (AuthorizationHelper)this.cacheManager.getGlobalComponentRegistry().getComponent(AuthorizationHelper.class);
        }
        return cfg;
    }

    ScriptMetadata compileScript(String name, String script) {
        ScriptMetadata metadata = ScriptMetadataParser.parse(name, script);
        ScriptEngine engine = this.getEngineForScript(metadata);
        if (engine instanceof Compilable) {
            try {
                CompiledScript compiledScript = ((Compilable)((Object)engine)).compile(script);
                this.compiledScripts.put(name, compiledScript);
                return metadata;
            }
            catch (ScriptException e) {
                throw log.scriptCompilationException(e, name);
            }
        }
        return null;
    }

    @Override
    public void addScript(String name, String script) {
        ScriptMetadata metadata = ScriptMetadataParser.parse(name, script);
        ScriptEngine engine = this.getEngineForScript(metadata);
        if (engine == null) {
            throw log.noScriptEngineForScript(name);
        }
        this.getScriptCache().getAdvancedCache().put((Object)name, (Object)script, (Metadata)metadata);
    }

    @Override
    public void removeScript(String name) {
        if (!this.containsScript(name)) {
            throw log.noNamedScript(name);
        }
        this.getScriptCache().remove((Object)name);
    }

    @Override
    public String getScript(String name) {
        if (this.containsScript(name)) {
            return (String)SecurityActions.getUnwrappedCache(this.getScriptCache()).get((Object)name);
        }
        throw log.noNamedScript(name);
    }

    @Override
    public Set<String> getScriptNames() {
        return SecurityActions.getUnwrappedCache(this.getScriptCache()).keySet();
    }

    public boolean containsScript(String taskName) {
        return SecurityActions.getUnwrappedCache(this.getScriptCache()).containsKey((Object)taskName);
    }

    @Override
    public <T> CompletableFuture<T> runScript(String scriptName) {
        return this.runScript(scriptName, new TaskContext());
    }

    @Override
    public <T> CompletableFuture<T> runScript(String scriptName, TaskContext context) {
        ScriptMetadata metadata = this.getScriptMetadata(scriptName);
        if (this.globalAuthzHelper != null) {
            AuthorizationManager authorizationManager;
            AuthorizationManager authorizationManager2 = authorizationManager = context.getCache().isPresent() ? SecurityActions.getAuthorizationManager(((Cache)context.getCache().get()).getAdvancedCache()) : null;
            if (authorizationManager != null) {
                authorizationManager.checkPermission(AuthorizationPermission.EXEC, (String)metadata.role().orElse(null));
            } else {
                this.globalAuthzHelper.checkPermission(AuthorizationPermission.EXEC, (String)metadata.role().orElse(null));
            }
        }
        Bindings userBindings = context.getParameters().map(p -> {
            Map<String, Object> params = metadata.dataType().transformer.toDataType((Map)context.getParameters().get(), (Optional<Marshaller>)context.getMarshaller());
            return new SimpleBindings(params);
        }).orElseGet(() -> new SimpleBindings());
        SimpleBindings systemBindings = new SimpleBindings();
        DataTypedCacheManager cm = new DataTypedCacheManager(metadata.dataType(), context.getMarshaller(), this.cacheManager, context.getSubject().orElse(null));
        systemBindings.put(SystemBindings.CACHE_MANAGER.toString(), (Object)cm);
        systemBindings.put(SystemBindings.SCRIPTING_MANAGER.toString(), (Object)this);
        context.getCache().ifPresent(cache -> {
            Object c = cm.getCacheConfiguration(cache.getName()).compatibility().enabled() ? cache : new DataTypedCache(cm, cache);
            systemBindings.put(SystemBindings.CACHE.toString(), c);
        });
        context.getMarshaller().ifPresent(marshaller -> systemBindings.put(SystemBindings.MARSHALLER.toString(), marshaller));
        CacheScriptBindings bindings = new CacheScriptBindings(systemBindings, userBindings);
        ScriptRunner runner = metadata.mode().getRunner();
        return runner.runScript(this, metadata, bindings).thenApply(t -> metadata.dataType().transformer.fromDataType(t, context.getMarshaller()));
    }

    ScriptMetadata getScriptMetadata(String scriptName) {
        CacheEntry scriptEntry = SecurityActions.getCacheEntry(this.getScriptCache().getAdvancedCache(), scriptName);
        if (scriptEntry == null) {
            throw log.noNamedScript(scriptName);
        }
        ScriptMetadata metadata = (ScriptMetadata)scriptEntry.getMetadata();
        return metadata;
    }

    <T> CompletableFuture<T> execute(ScriptMetadata metadata, Bindings bindings) {
        CompiledScript compiled = (CompiledScript)this.compiledScripts.get(metadata.name());
        try {
            if (compiled != null) {
                Object result = compiled.eval(bindings);
                return CompletableFuture.completedFuture(result);
            }
            ScriptEngine engine = this.getEngineForScript(metadata);
            Object result = engine.eval((String)this.getScriptCache().get((Object)metadata.name()), bindings);
            return CompletableFuture.completedFuture(result);
        }
        catch (ScriptException e) {
            throw log.scriptExecutionError(e);
        }
    }

    ScriptEngine getEngineForScript(ScriptMetadata metadata) {
        ScriptEngine engine = metadata.language().isPresent() ? this.scriptEnginesByLanguage.computeIfAbsent(metadata.language().get(), this.getEngineByName) : this.scriptEnginesByExtension.computeIfAbsent(metadata.extension(), this.getEngineByExtension);
        if (engine == null) {
            throw log.noEngineForScript(metadata.name());
        }
        return engine;
    }

    private ScriptEngine getEngineByName(String shortName) {
        return ScriptingManagerImpl.withClassLoader(ScriptingManagerImpl.class.getClassLoader(), this.scriptEngineManager, shortName, ScriptEngineManager::getEngineByName);
    }

    private ScriptEngine getEngineByExtension(String extension) {
        return ScriptingManagerImpl.withClassLoader(ScriptingManagerImpl.class.getClassLoader(), this.scriptEngineManager, extension, ScriptEngineManager::getEngineByExtension);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ScriptEngine withClassLoader(ClassLoader cl, ScriptEngineManager manager, String name, BiFunction<ScriptEngineManager, String, ScriptEngine> f) {
        ClassLoader curr = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(cl);
            ScriptEngine scriptEngine = f.apply(manager, name);
            return scriptEngine;
        }
        finally {
            Thread.currentThread().setContextClassLoader(curr);
        }
    }
}

