/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.scripting.impl;

import java.util.Collection;
import java.util.Map;
import java.util.Set;
import javax.script.Bindings;

public class CacheScriptBindings
implements Bindings {
    private final Bindings systemBindings;
    private final Bindings userBindings;

    public CacheScriptBindings(Bindings systemBindings, Bindings userBindings) {
        this.systemBindings = systemBindings;
        this.userBindings = userBindings;
    }

    @Override
    public boolean containsKey(Object key) {
        return this.systemBindings.containsKey(key) || this.userBindings.containsKey(key);
    }

    @Override
    public Object get(Object key) {
        if (this.systemBindings.containsKey(key)) {
            return this.systemBindings.get(key);
        }
        return this.userBindings.get(key);
    }

    @Override
    public int size() {
        return this.userBindings.size() + this.systemBindings.size();
    }

    @Override
    public boolean isEmpty() {
        return this.userBindings.isEmpty() && this.systemBindings.isEmpty();
    }

    @Override
    public boolean containsValue(Object value) {
        return this.systemBindings.containsValue(value) || this.userBindings.containsValue(value);
    }

    @Override
    public void clear() {
        this.userBindings.clear();
    }

    @Override
    public Set<String> keySet() {
        return this.userBindings.keySet();
    }

    @Override
    public Collection<Object> values() {
        return this.userBindings.values();
    }

    @Override
    public Set<Map.Entry<String, Object>> entrySet() {
        return this.userBindings.entrySet();
    }

    @Override
    public Object put(String name, Object value) {
        if (this.systemBindings.containsKey(name)) {
            throw new IllegalArgumentException();
        }
        return this.userBindings.put(name, value);
    }

    @Override
    public void putAll(Map<? extends String, ? extends Object> toMerge) {
    }

    @Override
    public Object remove(Object key) {
        if (this.systemBindings.containsKey(key)) {
            throw new IllegalArgumentException();
        }
        return this.userBindings.remove(key);
    }
}

