/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.scripting.impl;

import java.io.Serializable;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.function.Function;
import javax.script.SimpleBindings;
import org.infinispan.AdvancedCache;
import org.infinispan.commons.CacheException;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.scripting.ScriptingManager;
import org.infinispan.scripting.impl.DataTypedCacheManager;
import org.infinispan.scripting.impl.ScriptMetadata;
import org.infinispan.scripting.impl.ScriptingManagerImpl;
import org.infinispan.scripting.impl.SecurityActions;

class DistributedScript<T>
implements Function<EmbeddedCacheManager, T>,
Serializable {
    private final String cacheName;
    private final ScriptMetadata metadata;
    private final Map<String, ?> ctxParams;

    DistributedScript(String cacheName, ScriptMetadata metadata, Map<String, ?> ctxParams) {
        this.cacheName = cacheName;
        this.metadata = metadata;
        this.ctxParams = ctxParams;
    }

    @Override
    public T apply(EmbeddedCacheManager embeddedCacheManager) {
        ScriptingManagerImpl scriptManager = (ScriptingManagerImpl)SecurityActions.getGlobalComponentRegistry(embeddedCacheManager).getComponent(ScriptingManager.class);
        SimpleBindings bindings = new SimpleBindings();
        String scriptMediaType = this.metadata.dataType().toString();
        DataTypedCacheManager dataTypedCacheManager = new DataTypedCacheManager(scriptMediaType, embeddedCacheManager, null);
        bindings.put("cacheManager", (Object)dataTypedCacheManager);
        AdvancedCache cache = embeddedCacheManager.getCache(this.cacheName).getAdvancedCache();
        bindings.put("cache", (Object)cache.withMediaType(scriptMediaType, scriptMediaType));
        this.ctxParams.forEach((key, value) -> bindings.put((String)key, value));
        try {
            return scriptManager.execute(this.metadata, bindings).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new CacheException((Throwable)e);
        }
    }
}

