/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.scripting;

import java.io.InputStream;
import org.infinispan.Cache;
import org.infinispan.commons.util.Util;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.test.AbstractInfinispanTest;
import org.infinispan.test.CacheManagerCallable;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="scripting.ScriptCachePreserveStateAcrossRestarts")
public class ScriptCachePreserveStateAcrossRestarts
extends AbstractInfinispanTest {
    protected EmbeddedCacheManager createCacheManager(String persistentStateLocation) throws Exception {
        GlobalConfigurationBuilder global = new GlobalConfigurationBuilder();
        global.globalState().enable().persistentLocation(persistentStateLocation);
        EmbeddedCacheManager cacheManager = TestCacheManagerFactory.createCacheManager((GlobalConfigurationBuilder)global, (ConfigurationBuilder)new ConfigurationBuilder());
        cacheManager.getCache();
        return cacheManager;
    }

    public void testStatePreserved() throws Exception {
        String persistentStateLocation = TestingUtil.tmpDirectory(((Object)((Object)this)).getClass());
        Util.recursiveFileRemove((String)persistentStateLocation);
        TestingUtil.withCacheManager((CacheManagerCallable)new CacheManagerCallable(this.createCacheManager(persistentStateLocation)){

            public void call() throws Exception {
                Cache scriptCache = this.cm.getCache("___script_cache");
                try (InputStream is = ((Object)((Object)this)).getClass().getResourceAsStream("/test.js");){
                    String script = TestingUtil.loadFileAsString((InputStream)is);
                    scriptCache.put((Object)"test.js", (Object)script);
                }
            }
        });
        TestingUtil.withCacheManager((CacheManagerCallable)new CacheManagerCallable(this.createCacheManager(persistentStateLocation)){

            public void call() throws Exception {
                Cache scriptCache = this.cm.getCache("___script_cache");
                AssertJUnit.assertTrue((boolean)scriptCache.containsKey((Object)"test.js"));
            }
        });
    }
}

