/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.annotations;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Repeatable;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.invoke.MethodHandles;
import java.util.Optional;
import org.hibernate.search.annotations.Analyze;
import org.hibernate.search.annotations.Analyzer;
import org.hibernate.search.annotations.Fields;
import org.hibernate.search.annotations.Index;
import org.hibernate.search.annotations.SortableField;
import org.hibernate.search.annotations.Store;
import org.hibernate.search.engine.backend.types.Aggregable;
import org.hibernate.search.engine.backend.types.Projectable;
import org.hibernate.search.engine.backend.types.Searchable;
import org.hibernate.search.engine.backend.types.Sortable;
import org.hibernate.search.mapper.pojo.mapping.definition.annotation.processing.MappingAnnotatedProperty;
import org.hibernate.search.mapper.pojo.mapping.definition.annotation.processing.PropertyMapping;
import org.hibernate.search.mapper.pojo.mapping.definition.annotation.processing.PropertyMappingAnnotationProcessor;
import org.hibernate.search.mapper.pojo.mapping.definition.annotation.processing.PropertyMappingAnnotationProcessorContext;
import org.hibernate.search.mapper.pojo.mapping.definition.annotation.processing.PropertyMappingAnnotationProcessorRef;
import org.hibernate.search.mapper.pojo.mapping.definition.programmatic.PropertyMappingGenericFieldOptionsStep;
import org.hibernate.search.mapper.pojo.mapping.definition.programmatic.PropertyMappingStep;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;
import org.infinispan.search.mapper.log.impl.Log;

@Retention(value=RetentionPolicy.RUNTIME)
@Target(value={ElementType.METHOD, ElementType.FIELD})
@Documented
@Repeatable(value=Fields.class)
@PropertyMapping(processor=@PropertyMappingAnnotationProcessorRef(type=Processor.class))
public @interface Field {
    public static final String DO_NOT_INDEX_NULL = "__DO_NOT_INDEX_NULL__";
    public static final String DEFAULT_NULL_TOKEN = "__DEFAULT_NULL_TOKEN__";

    public String name() default "";

    public Store store() default Store.NO;

    public Index index() default Index.YES;

    public Analyze analyze() default Analyze.YES;

    public String indexNullAs() default "__DO_NOT_INDEX_NULL__";

    public static class Processor
    implements PropertyMappingAnnotationProcessor<Field> {
        private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());

        public void process(PropertyMappingStep mapping, Field annotation, PropertyMappingAnnotationProcessorContext context) {
            PropertyMappingGenericFieldOptionsStep optionsStep;
            boolean analyzed;
            MappingAnnotatedProperty annotatedProperty = context.annotatedElement();
            Class propertyType = annotatedProperty.javaClass();
            String name = annotation.name().isEmpty() ? null : annotation.name();
            boolean sortable = annotatedProperty.allAnnotations().filter(a -> SortableField.class.equals(a.annotationType())).map(a -> ((SortableField)a).forField()).anyMatch(a -> a.isEmpty() || annotatedProperty.name().equals(a));
            boolean bl = analyzed = Analyze.YES.equals((Object)annotation.analyze()) && String.class.equals((Object)propertyType);
            if (analyzed && sortable) {
                throw log.fieldSortableAndAnalyzed(annotatedProperty.name());
            }
            String indexNullAs = annotation.indexNullAs();
            if (Field.DEFAULT_NULL_TOKEN.equals(indexNullAs)) {
                throw log.defaultNullTokenNotSupported(annotatedProperty.name());
            }
            if (analyzed) {
                Optional<String> analyzerAnnotation = annotatedProperty.allAnnotations().filter(a -> Analyzer.class.equals(a.annotationType())).map(a -> ((Analyzer)a).definition()).filter(a -> !a.isEmpty()).findAny();
                String analyzer = analyzerAnnotation.isPresent() ? analyzerAnnotation.get() : "standard";
                optionsStep = mapping.fullTextField(name).analyzer(analyzer);
            } else {
                PropertyMappingGenericFieldOptionsStep genericOptionsStep = (PropertyMappingGenericFieldOptionsStep)((PropertyMappingGenericFieldOptionsStep)mapping.genericField(name).sortable(sortable ? Sortable.YES : Sortable.NO)).aggregable(Aggregable.NO);
                if (!Field.DO_NOT_INDEX_NULL.equals(indexNullAs)) {
                    genericOptionsStep.indexNullAs(indexNullAs);
                }
                optionsStep = genericOptionsStep;
            }
            optionsStep.searchable(Index.YES.equals((Object)annotation.index()) ? Searchable.YES : Searchable.NO).projectable(Store.YES.equals((Object)annotation.store()) ? Projectable.YES : Projectable.NO);
        }
    }
}

