/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.annotations;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.hibernate.search.engine.backend.document.model.dsl.ObjectFieldStorage;
import org.hibernate.search.mapper.pojo.extractor.mapping.programmatic.ContainerExtractorPath;
import org.hibernate.search.mapper.pojo.mapping.definition.annotation.processing.PropertyMapping;
import org.hibernate.search.mapper.pojo.mapping.definition.annotation.processing.PropertyMappingAnnotationProcessor;
import org.hibernate.search.mapper.pojo.mapping.definition.annotation.processing.PropertyMappingAnnotationProcessorContext;
import org.hibernate.search.mapper.pojo.mapping.definition.annotation.processing.PropertyMappingAnnotationProcessorRef;
import org.hibernate.search.mapper.pojo.mapping.definition.programmatic.PropertyMappingStep;

@Retention(value=RetentionPolicy.RUNTIME)
@Target(value={ElementType.FIELD, ElementType.METHOD})
@Documented
@PropertyMapping(processor=@PropertyMappingAnnotationProcessorRef(type=Processor.class))
public @interface IndexedEmbedded {
    public String prefix() default ".";

    public String[] includePaths() default {};

    public int depth() default 0x7FFFFFFF;

    public static class Processor
    implements PropertyMappingAnnotationProcessor<IndexedEmbedded> {
        public void process(PropertyMappingStep mappingContext, IndexedEmbedded annotation, PropertyMappingAnnotationProcessorContext context) {
            Set cleanedUpIncludePaths;
            String[] includePathsArray;
            Integer cleanedUpMaxDepth;
            String cleanedUpPrefix = annotation.prefix();
            if (cleanedUpPrefix.startsWith(".")) {
                cleanedUpPrefix = cleanedUpPrefix.substring(1);
            }
            if (cleanedUpPrefix.isEmpty()) {
                cleanedUpPrefix = null;
            }
            if ((cleanedUpMaxDepth = Integer.valueOf(annotation.depth())).equals(-1)) {
                cleanedUpMaxDepth = null;
            }
            if ((includePathsArray = annotation.includePaths()).length > 0) {
                cleanedUpIncludePaths = new HashSet();
                Collections.addAll(cleanedUpIncludePaths, includePathsArray);
            } else {
                cleanedUpIncludePaths = Collections.emptySet();
            }
            mappingContext.indexedEmbedded().extractors(ContainerExtractorPath.defaultExtractors()).prefix(cleanedUpPrefix).storage(ObjectFieldStorage.DEFAULT).maxDepth(cleanedUpMaxDepth).includePaths(cleanedUpIncludePaths);
        }
    }
}

