/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.search.mapper.log.impl;

import org.hibernate.search.engine.environment.classpath.spi.ClassLoadingException;
import org.hibernate.search.mapper.pojo.logging.spi.PojoTypeModelFormatter;
import org.hibernate.search.mapper.pojo.model.spi.PojoRawTypeModel;
import org.hibernate.search.util.common.SearchException;
import org.hibernate.search.util.common.logging.impl.ClassFormatter;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.annotations.Cause;
import org.jboss.logging.annotations.FormatWith;
import org.jboss.logging.annotations.Message;
import org.jboss.logging.annotations.MessageLogger;
import org.jboss.logging.annotations.ValidIdRange;

@MessageLogger(projectCode="ISPN")
@ValidIdRange(min=750000, max=759999)
public interface Log
extends BasicLogger {
    public static final int ID_OFFSET_1 = 750000;

    @Message(id=750001, value="Unable to find property '%2$s' on type '%1$s'.")
    public SearchException cannotFindProperty(@FormatWith(value=PojoTypeModelFormatter.class) PojoRawTypeModel<?> var1, String var2);

    @Message(id=750002, value="Exception while retrieving the type model for '%1$s'.")
    public SearchException errorRetrievingTypeModel(@FormatWith(value=ClassFormatter.class) Class<?> var1, @Cause Exception var2);

    @Message(id=750003, value="Exception while retrieving property type model for '%1$s' on '%2$s'")
    public SearchException errorRetrievingPropertyTypeModel(String var1, @FormatWith(value=PojoTypeModelFormatter.class) PojoRawTypeModel<?> var2, @Cause Exception var3);

    @Message(id=750004, value="Multiple entity types configured with the same name '%1$s': '%2$s', '%3$s'")
    public SearchException multipleEntityTypesWithSameName(String var1, Class<?> var2, Class<?> var3);

    @Message(id=750005, value="Infinispan Search Mapper does not support named types. The type with name '%1$s' does not exist.")
    public SearchException namedTypesNotSupported(String var1);

    @Message(id=750006, value="Unable to load class [%1$s]")
    public ClassLoadingException unableToLoadTheClass(String var1, @Cause Throwable var2);

    @Message(id=750007, value="An indexed cannot be analyzed and ordered at the same time.  Field '%1$s'.")
    public SearchException fieldSortableAndAnalyzed(String var1);

    @Message(id=750008, value="Index as null `DEFAULT_NULL_TOKEN` option is not supported anymore.  Field '%1$s'.")
    public SearchException defaultNullTokenNotSupported(String var1);
}

