/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.search.mapper.mapping.impl;

import java.io.InputStream;
import java.lang.invoke.MethodHandles;
import java.net.URL;
import java.util.ServiceLoader;
import org.hibernate.search.engine.environment.classpath.spi.ClassResolver;
import org.hibernate.search.engine.environment.classpath.spi.ResourceResolver;
import org.hibernate.search.engine.environment.classpath.spi.ServiceResolver;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;
import org.infinispan.search.mapper.log.impl.Log;

public final class ClassLoaderServiceImpl
implements ClassResolver,
ResourceResolver,
ServiceResolver {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final ClassLoader classLoader;

    public ClassLoaderServiceImpl(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public <T> Class<T> classForName(String className) {
        try {
            return Class.forName(className, true, this.classLoader);
        }
        catch (Exception | LinkageError e) {
            throw log.unableToLoadTheClass(className, e);
        }
    }

    public URL locateResource(String name) {
        try {
            return this.classLoader.getResource(name);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public InputStream locateResourceStream(String name) {
        try {
            InputStream is = this.classLoader.getResourceAsStream(name);
            if (is != null) {
                return is;
            }
        }
        catch (Exception is) {
            // empty catch block
        }
        if (name.startsWith("/")) {
            String stripped = name.substring(1);
            try {
                return new URL(stripped).openStream();
            }
            catch (Exception exception) {
                try {
                    return this.classLoader.getResourceAsStream(stripped);
                }
                catch (Exception exception2) {
                    // empty catch block
                }
            }
        }
        return null;
    }

    public <S> Iterable<S> loadJavaServices(Class<S> serviceContract) {
        return ServiceLoader.load(serviceContract, this.classLoader);
    }
}

