/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.search.mapper.model.impl;

import java.lang.annotation.Annotation;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Objects;
import java.util.stream.Stream;
import org.hibernate.annotations.common.reflection.XAnnotatedElement;
import org.hibernate.annotations.common.reflection.XProperty;
import org.hibernate.search.mapper.pojo.model.hcann.spi.PojoCommonsAnnotationsHelper;
import org.hibernate.search.mapper.pojo.model.spi.PojoGenericTypeModel;
import org.hibernate.search.mapper.pojo.model.spi.PojoPropertyModel;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;
import org.hibernate.search.util.common.reflect.spi.ValueReadHandle;
import org.infinispan.search.mapper.log.impl.Log;
import org.infinispan.search.mapper.model.impl.InfinispanBootstrapIntrospector;
import org.infinispan.search.mapper.model.impl.InfinispanTypeModel;

class InfinispanPropertyModel<T>
implements PojoPropertyModel<T> {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final InfinispanBootstrapIntrospector introspector;
    private final InfinispanTypeModel<?> parentTypeModel;
    private final XProperty property;
    private final Method readMethod;
    private PojoGenericTypeModel<T> typeModel;
    private ValueReadHandle<T> handle;

    InfinispanPropertyModel(InfinispanBootstrapIntrospector introspector, InfinispanTypeModel<?> parentTypeModel, XProperty property) {
        this.introspector = introspector;
        this.parentTypeModel = parentTypeModel;
        this.property = property;
        this.readMethod = PojoCommonsAnnotationsHelper.extractUnderlyingMethod((XProperty)property);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InfinispanPropertyModel that = (InfinispanPropertyModel)o;
        return Objects.equals((Object)this.introspector, (Object)that.introspector) && Objects.equals(this.parentTypeModel, that.parentTypeModel) && Objects.equals(this.handle(), that.handle());
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.introspector, this.parentTypeModel, this.handle});
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.name() + ", " + this.getGetterGenericReturnType().getTypeName() + "]";
    }

    public String name() {
        return this.property.getName();
    }

    public Stream<Annotation> annotations() {
        return this.introspector.annotations((XAnnotatedElement)this.property);
    }

    public PojoGenericTypeModel<T> typeModel() {
        if (this.typeModel == null) {
            try {
                this.typeModel = this.parentTypeModel.getRawTypeDeclaringContext().createGenericTypeModel(this.getGetterGenericReturnType());
            }
            catch (RuntimeException e) {
                throw log.errorRetrievingPropertyTypeModel(this.name(), this.parentTypeModel, e);
            }
        }
        return this.typeModel;
    }

    public ValueReadHandle<T> handle() {
        if (this.handle == null) {
            try {
                this.handle = this.introspector.createValueReadHandle(this.readMethod);
            }
            catch (IllegalAccessException | RuntimeException e) {
                throw log.errorRetrievingPropertyTypeModel(this.name(), this.parentTypeModel, e);
            }
        }
        return this.handle;
    }

    Type getGetterGenericReturnType() {
        return this.readMethod.getGenericReturnType();
    }
}

