/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.search.mapper.model.impl;

import java.lang.annotation.Annotation;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Modifier;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Stream;
import org.hibernate.annotations.common.reflection.XAnnotatedElement;
import org.hibernate.annotations.common.reflection.XClass;
import org.hibernate.annotations.common.reflection.XProperty;
import org.hibernate.search.engine.mapper.model.spi.MappableTypeModel;
import org.hibernate.search.mapper.pojo.model.spi.GenericContextAwarePojoGenericTypeModel;
import org.hibernate.search.mapper.pojo.model.spi.JavaClassPojoCaster;
import org.hibernate.search.mapper.pojo.model.spi.PojoCaster;
import org.hibernate.search.mapper.pojo.model.spi.PojoPropertyModel;
import org.hibernate.search.mapper.pojo.model.spi.PojoRawTypeIdentifier;
import org.hibernate.search.mapper.pojo.model.spi.PojoRawTypeModel;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;
import org.infinispan.search.mapper.log.impl.Log;
import org.infinispan.search.mapper.model.impl.InfinispanBootstrapIntrospector;
import org.infinispan.search.mapper.model.impl.InfinispanPropertyModel;

class InfinispanTypeModel<T>
implements PojoRawTypeModel<T> {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final InfinispanBootstrapIntrospector introspector;
    private final PojoRawTypeIdentifier<T> typeIdentifier;
    private final GenericContextAwarePojoGenericTypeModel.RawTypeDeclaringContext<T> rawTypeDeclaringContext;
    private final PojoCaster<T> caster;
    private final XClass xClass;
    private final Map<String, XProperty> declaredProperties;

    InfinispanTypeModel(InfinispanBootstrapIntrospector introspector, PojoRawTypeIdentifier<T> typeIdentifier, GenericContextAwarePojoGenericTypeModel.RawTypeDeclaringContext<T> rawTypeDeclaringContext) {
        this.introspector = introspector;
        this.typeIdentifier = typeIdentifier;
        this.rawTypeDeclaringContext = rawTypeDeclaringContext;
        this.caster = new JavaClassPojoCaster(typeIdentifier.javaClass());
        this.xClass = introspector.toXClass(typeIdentifier.javaClass());
        this.declaredProperties = introspector.declaredMethodAccessXPropertiesByName(this.xClass);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InfinispanTypeModel that = (InfinispanTypeModel)o;
        return Objects.equals((Object)this.introspector, (Object)that.introspector) && Objects.equals(this.typeIdentifier, that.typeIdentifier);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.introspector, this.typeIdentifier});
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.typeIdentifier + "]";
    }

    public PojoRawTypeIdentifier<T> typeIdentifier() {
        return this.typeIdentifier;
    }

    public String name() {
        return this.typeIdentifier.toString();
    }

    public boolean isAbstract() {
        return Modifier.isAbstract(this.typeIdentifier.javaClass().getModifiers());
    }

    public boolean isSubTypeOf(MappableTypeModel other) {
        return other instanceof InfinispanTypeModel && ((InfinispanTypeModel)other).typeIdentifier.javaClass().isAssignableFrom(this.typeIdentifier.javaClass());
    }

    public PojoRawTypeModel<T> rawType() {
        return this;
    }

    public Stream<InfinispanTypeModel<? super T>> ascendingSuperTypes() {
        return this.introspector.ascendingSuperTypes(this.xClass);
    }

    public Stream<? extends PojoRawTypeModel<? super T>> descendingSuperTypes() {
        return this.introspector.descendingSuperTypes(this.xClass);
    }

    public Stream<Annotation> annotations() {
        return this.introspector.annotations((XAnnotatedElement)this.xClass);
    }

    public PojoPropertyModel<?> property(String propertyName) {
        return this.ascendingSuperTypes().map(model -> model.declaredProperties.get(propertyName)).filter(Objects::nonNull).findFirst().map(this::createProperty).orElseThrow(() -> log.cannotFindProperty(this, propertyName));
    }

    public Stream<PojoPropertyModel<?>> declaredProperties() {
        return this.declaredProperties.values().stream().map(this::createProperty);
    }

    public PojoCaster<T> caster() {
        return this.caster;
    }

    GenericContextAwarePojoGenericTypeModel.RawTypeDeclaringContext<T> getRawTypeDeclaringContext() {
        return this.rawTypeDeclaringContext;
    }

    private PojoPropertyModel<?> createProperty(XProperty property) {
        return new InfinispanPropertyModel(this.introspector, this, property);
    }
}

