/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.test.integration.security.embedded;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.login.LoginException;
import org.infinispan.commons.test.ThreadLeakChecker;
import org.infinispan.security.AuthorizationPermission;
import org.infinispan.security.PrincipalRoleMapper;
import org.infinispan.security.impl.IdentityRoleMapper;
import org.infinispan.test.integration.security.embedded.AbstractAuthentication;
import org.infinispan.test.integration.security.tasks.AbstractSecurityDomainsServerSetupTask;
import org.infinispan.test.integration.security.tasks.AbstractTraceLoggingServerSetupTask;
import org.infinispan.test.integration.security.utils.ApacheDsLdap;
import org.infinispan.test.integration.security.utils.Deployments;
import org.infinispan.test.integration.security.utils.Utils;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.container.test.api.TargetsContainer;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.as.arquillian.api.ServerSetup;
import org.jboss.as.arquillian.api.ServerSetupTask;
import org.jboss.as.arquillian.container.ManagementClient;
import org.jboss.as.test.integration.security.common.config.SecurityDomain;
import org.jboss.as.test.integration.security.common.config.SecurityModule;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.runner.RunWith;

@RunWith(value=Arquillian.class)
@ServerSetup(value={SecurityDomainsSetupTask.class, SecurityTraceLoggingServerSetupTask.class, LdapServerSetupTask.class})
public class LdapAuthenticationIT
extends AbstractAuthentication {
    public static final String SECURITY_DOMAIN_NAME = "ispn-secure";
    public static final String ADMIN_ROLE = "admin";
    public static final String ADMIN_PASSWD = "strongPassword";
    public static final String WRITER_ROLE = "writer";
    public static final String WRITER_PASSWD = "somePassword";
    public static final String READER_ROLE = "reader";
    public static final String READER_PASSWD = "password";
    public static final String UNPRIVILEGED_ROLE = "unprivileged";
    public static final String UNPRIVILEGED_PASSWD = "weakPassword";

    @Deployment
    @TargetsContainer(value="testnode")
    public static WebArchive getDeployment() {
        return Deployments.createKrbLdapTestDeployment();
    }

    @Override
    public Map<String, AuthorizationPermission[]> getRolePermissionMap() {
        HashMap<String, AuthorizationPermission[]> roles = new HashMap<String, AuthorizationPermission[]>();
        roles.put(ADMIN_ROLE, new AuthorizationPermission[]{AuthorizationPermission.ALL});
        roles.put(WRITER_ROLE, new AuthorizationPermission[]{AuthorizationPermission.WRITE});
        roles.put(READER_ROLE, new AuthorizationPermission[]{AuthorizationPermission.READ});
        roles.put(UNPRIVILEGED_ROLE, new AuthorizationPermission[]{AuthorizationPermission.NONE});
        return roles;
    }

    @Override
    public PrincipalRoleMapper getPrincipalRoleMapper() {
        return new IdentityRoleMapper();
    }

    @Override
    public String getSecurityDomainName() {
        return SECURITY_DOMAIN_NAME;
    }

    @Override
    public Subject getAdminSubject() throws LoginException {
        return this.authenticate(ADMIN_ROLE, ADMIN_PASSWD);
    }

    @Override
    public Subject getWriterSubject() throws LoginException {
        return this.authenticate(WRITER_ROLE, WRITER_PASSWD);
    }

    @Override
    public Subject getReaderSubject() throws LoginException {
        return this.authenticate(READER_ROLE, READER_PASSWD);
    }

    @Override
    public Subject getUnprivilegedSubject() throws LoginException {
        return this.authenticate(UNPRIVILEGED_ROLE, UNPRIVILEGED_PASSWD);
    }

    static class SecurityDomainsSetupTask
    extends AbstractSecurityDomainsServerSetupTask {
        SecurityDomainsSetupTask() {
        }

        @Override
        protected SecurityDomain[] getSecurityDomains() {
            String hostname = Utils.getCannonicalHost(this.managementClient);
            String ldapUrl = "ldap://" + hostname + ":10389";
            SecurityDomain sd = new SecurityDomain.Builder().name(LdapAuthenticationIT.SECURITY_DOMAIN_NAME).cacheType("default").loginModules(new SecurityModule[]{new SecurityModule.Builder().name("org.jboss.security.auth.spi.LdapLoginModule").flag("required").putOption("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory").putOption("java.naming.provider.url", ldapUrl).putOption("java.naming.security.authentication", "simple").putOption("principalDNPrefix", "uid=").putOption("principalDNSuffix", ",ou=People,dc=infinispan,dc=org").putOption("rolesCtxDN", "ou=Roles,dc=infinispan,dc=org").putOption("uidAttributeID", "member").putOption("matchOnUserDN", "true").putOption("roleAttributeID", "cn").putOption("roleAttributeIsDN", "false").putOption("searchScope", "ONELEVEL_SCOPE").build()}).build();
            return new SecurityDomain[]{sd};
        }
    }

    static class LdapServerSetupTask
    implements ServerSetupTask {
        private static ApacheDsLdap ldapServer;

        LdapServerSetupTask() {
        }

        public void setup(ManagementClient managementClient, String s) throws Exception {
            ldapServer = new ApacheDsLdap();
            ldapServer.start();
        }

        public void tearDown(ManagementClient managementClient, String s) throws Exception {
            ThreadLeakChecker.ignoreThreadsContaining((String)"pool-.*thread-");
            ldapServer.stop();
        }
    }

    static class SecurityTraceLoggingServerSetupTask
    extends AbstractTraceLoggingServerSetupTask {
        SecurityTraceLoggingServerSetupTask() {
        }

        @Override
        protected Collection<String> getCategories(ManagementClient managementClient, String containerId) {
            return Arrays.asList("javax.security", "org.jboss.security", "org.picketbox", "org.wildfly.security");
        }
    }
}

