/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.test.integration.security.utils;

import java.io.IOException;
import java.net.ServerSocket;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.directory.api.util.Strings;
import org.apache.directory.server.annotations.CreateChngPwdServer;
import org.apache.directory.server.annotations.CreateKdcServer;
import org.apache.directory.server.annotations.CreateLdapServer;
import org.apache.directory.server.annotations.CreateTransport;
import org.apache.directory.server.core.annotations.AnnotationUtils;
import org.apache.directory.server.core.api.DirectoryService;
import org.apache.directory.server.i18n.I18n;
import org.apache.directory.server.kerberos.ChangePasswordConfig;
import org.apache.directory.server.kerberos.KerberosConfig;
import org.apache.directory.server.kerberos.changepwd.ChangePasswordServer;
import org.apache.directory.server.kerberos.kdc.KdcServer;
import org.apache.directory.server.ldap.ExtendedOperationHandler;
import org.apache.directory.server.ldap.LdapServer;
import org.apache.directory.server.ldap.handlers.sasl.MechanismHandler;
import org.apache.directory.server.ldap.handlers.sasl.ntlm.NtlmMechanismHandler;
import org.apache.directory.server.ldap.handlers.sasl.ntlm.NtlmProvider;
import org.apache.directory.server.protocol.shared.transport.TcpTransport;
import org.apache.directory.server.protocol.shared.transport.Transport;
import org.apache.directory.server.protocol.shared.transport.UdpTransport;

public class KdcServerAnnotationProcessor {
    private static void createTransports(LdapServer ldapServer, CreateTransport[] transportBuilders) {
        if (transportBuilders.length != 0) {
            for (CreateTransport transportBuilder : transportBuilders) {
                List<Transport> transports = KdcServerAnnotationProcessor.createTransports(transportBuilder);
                for (Transport t : transports) {
                    ldapServer.addTransports(new Transport[]{t});
                }
            }
        } else {
            try {
                int port = KdcServerAnnotationProcessor.getFreePort();
                TcpTransport ldap = new TcpTransport(port);
                ldapServer.addTransports(new Transport[]{ldap});
            }
            catch (IOException port) {
                // empty catch block
            }
            try {
                int port = KdcServerAnnotationProcessor.getFreePort();
                TcpTransport ldaps = new TcpTransport(port);
                ldaps.setEnableSSL(true);
                ldapServer.addTransports(new Transport[]{ldaps});
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static LdapServer instantiateLdapServer(CreateLdapServer createLdapServer, DirectoryService directoryService) {
        if (createLdapServer != null) {
            Class ntlmProviderClass;
            LdapServer ldapServer = new LdapServer();
            ldapServer.setServiceName(createLdapServer.name());
            KdcServerAnnotationProcessor.createTransports(ldapServer, createLdapServer.transports());
            ldapServer.setDirectoryService(directoryService);
            directoryService.setAllowAnonymousAccess(createLdapServer.allowAnonymousAccess());
            ldapServer.setSaslHost(createLdapServer.saslHost());
            ldapServer.setSaslPrincipal(createLdapServer.saslPrincipal());
            if (!Strings.isEmpty((String)createLdapServer.keyStore())) {
                ldapServer.setKeystoreFile(createLdapServer.keyStore());
                ldapServer.setCertificatePassword(createLdapServer.certificatePassword());
            }
            for (Class clazz : createLdapServer.extendedOpHandlers()) {
                try {
                    ExtendedOperationHandler extOpHandler = (ExtendedOperationHandler)clazz.newInstance();
                    ldapServer.addExtendedOperationHandler(extOpHandler);
                }
                catch (Exception e) {
                    throw new RuntimeException(I18n.err((I18n)I18n.ERR_690, (Object[])new Object[]{clazz.getName()}), e);
                }
            }
            for (Class clazz : createLdapServer.saslMechanisms()) {
                try {
                    MechanismHandler handler = (MechanismHandler)clazz.implClass().newInstance();
                    ldapServer.addSaslMechanismHandler(clazz.name(), handler);
                }
                catch (Exception e) {
                    throw new RuntimeException(I18n.err((I18n)I18n.ERR_691, (Object[])new Object[]{clazz.name(), clazz.implClass().getName()}), e);
                }
            }
            NtlmMechanismHandler ntlmHandler = (NtlmMechanismHandler)ldapServer.getSaslMechanismHandlers().get("NTLM");
            if (ntlmHandler != null && (ntlmProviderClass = createLdapServer.ntlmProvider()) != null && ntlmProviderClass != Object.class) {
                try {
                    ntlmHandler.setNtlmProvider((NtlmProvider)ntlmProviderClass.newInstance());
                }
                catch (Exception e) {
                    throw new RuntimeException(I18n.err((I18n)I18n.ERR_692, (Object[])new Object[0]), e);
                }
            }
            ArrayList<String> realms = new ArrayList<String>();
            for (String s : createLdapServer.saslRealms()) {
                realms.add(s);
            }
            ldapServer.setSaslRealms(realms);
            return ldapServer;
        }
        return null;
    }

    public static LdapServer getLdapServer(DirectoryService directoryService) throws ClassNotFoundException {
        Object instance = AnnotationUtils.getInstance(CreateLdapServer.class);
        LdapServer ldapServer = null;
        if (instance != null) {
            CreateLdapServer createLdapServer = (CreateLdapServer)instance;
            ldapServer = KdcServerAnnotationProcessor.createLdapServer(createLdapServer, directoryService);
        }
        return ldapServer;
    }

    private static LdapServer createLdapServer(CreateLdapServer createLdapServer, DirectoryService directoryService) {
        LdapServer ldapServer = KdcServerAnnotationProcessor.instantiateLdapServer(createLdapServer, directoryService);
        if (ldapServer == null) {
            return null;
        }
        try {
            ldapServer.start();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ldapServer;
    }

    public static KdcServer getKdcServer(DirectoryService directoryService) throws Exception {
        CreateKdcServer createKdcServer = (CreateKdcServer)AnnotationUtils.getInstance(CreateKdcServer.class);
        return KdcServerAnnotationProcessor.createKdcServer(createKdcServer, directoryService);
    }

    private static KdcServer createKdcServer(CreateKdcServer createKdcServer, DirectoryService directoryService) {
        if (createKdcServer == null) {
            return null;
        }
        KerberosConfig kdcConfig = new KerberosConfig();
        kdcConfig.setServicePrincipal(createKdcServer.kdcPrincipal());
        kdcConfig.setPrimaryRealm(createKdcServer.primaryRealm());
        kdcConfig.setMaximumTicketLifetime(createKdcServer.maxTicketLifetime());
        kdcConfig.setMaximumRenewableLifetime(createKdcServer.maxRenewableLifetime());
        KdcServer kdcServer = new KdcServer(kdcConfig);
        kdcServer.setSearchBaseDn(createKdcServer.searchBaseDn());
        CreateTransport[] transportBuilders = createKdcServer.transports();
        if (transportBuilders == null) {
            int port = 0;
            try {
                port = KdcServerAnnotationProcessor.getFreePort();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            UdpTransport defaultTransport = new UdpTransport(port);
            kdcServer.addTransports(new Transport[]{defaultTransport});
        } else if (transportBuilders.length > 0) {
            for (CreateTransport transportBuilder : transportBuilders) {
                List<Transport> transports = KdcServerAnnotationProcessor.createTransports(transportBuilder);
                for (Transport t : transports) {
                    kdcServer.addTransports(new Transport[]{t});
                }
            }
        }
        CreateChngPwdServer[] createChngPwdServers = createKdcServer.chngPwdServer();
        if (createChngPwdServers.length > 0) {
            CreateChngPwdServer createChngPwdServer = createChngPwdServers[0];
            ChangePasswordConfig config = new ChangePasswordConfig(kdcConfig);
            config.setServicePrincipal(createChngPwdServer.srvPrincipal());
            ChangePasswordServer chngPwdServer = new ChangePasswordServer(config);
            for (CreateTransport transportBuilder : createChngPwdServer.transports()) {
                List<Transport> transports = KdcServerAnnotationProcessor.createTransports(transportBuilder);
                for (Transport t : transports) {
                    chngPwdServer.addTransports(new Transport[]{t});
                }
            }
            chngPwdServer.setDirectoryService(directoryService);
            kdcServer.setChangePwdServer(chngPwdServer);
        }
        kdcServer.setDirectoryService(directoryService);
        try {
            kdcServer.start();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return kdcServer;
    }

    private static List<Transport> createTransports(CreateTransport transportBuilder) {
        String protocol = transportBuilder.protocol();
        int port = transportBuilder.port();
        int nbThreads = transportBuilder.nbThreads();
        int backlog = transportBuilder.backlog();
        String address = transportBuilder.address();
        if (port <= 0) {
            try {
                port = KdcServerAnnotationProcessor.getFreePort();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (protocol.equalsIgnoreCase("TCP") || protocol.equalsIgnoreCase("LDAP")) {
            TcpTransport tcp = new TcpTransport(address, port, nbThreads, backlog);
            return Collections.singletonList(tcp);
        }
        if (protocol.equalsIgnoreCase("LDAPS")) {
            TcpTransport tcp = new TcpTransport(address, port, nbThreads, backlog);
            tcp.setEnableSSL(true);
            return Collections.singletonList(tcp);
        }
        if (protocol.equalsIgnoreCase("UDP")) {
            UdpTransport udp = new UdpTransport(address, port);
            return Collections.singletonList(udp);
        }
        if (protocol.equalsIgnoreCase("KRB") || protocol.equalsIgnoreCase("CPW")) {
            TcpTransport tcp = new TcpTransport(address, port, nbThreads, backlog);
            ArrayList<Transport> transports = new ArrayList<Transport>();
            transports.add((Transport)tcp);
            UdpTransport udp = new UdpTransport(address, port);
            transports.add((Transport)udp);
            return transports;
        }
        throw new IllegalArgumentException(I18n.err((I18n)I18n.ERR_689, (Object[])new Object[]{protocol}));
    }

    private static int getFreePort() throws IOException {
        ServerSocket ss = new ServerSocket(0);
        int port = ss.getLocalPort();
        ss.close();
        return port;
    }
}

