/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.test.integration.security.embedded;

import java.io.File;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import javax.security.auth.callback.CallbackHandler;
import org.infinispan.Cache;
import org.infinispan.commons.test.ThreadLeakChecker;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.manager.DefaultCacheManager;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.test.integration.security.tasks.AbstractKrb5ConfServerSetupTask;
import org.infinispan.test.integration.security.tasks.AbstractSecurityDomainsServerSetupTask;
import org.infinispan.test.integration.security.tasks.AbstractSystemPropertiesServerSetupTask;
import org.infinispan.test.integration.security.tasks.AbstractTraceLoggingServerSetupTask;
import org.infinispan.test.integration.security.utils.ApacheDsKrbLdap;
import org.infinispan.test.integration.security.utils.ManagementClientParams;
import org.infinispan.test.integration.security.utils.Utils;
import org.infinispan.transaction.LockingMode;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;
import org.jboss.arquillian.container.test.api.ContainerController;
import org.jboss.arquillian.container.test.api.Deployer;
import org.jboss.arquillian.container.test.api.OperateOnDeployment;
import org.jboss.arquillian.junit.InSequence;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.jboss.as.arquillian.api.ServerSetupTask;
import org.jboss.as.arquillian.container.ManagementClient;
import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.as.test.integration.security.common.config.SecurityDomain;
import org.jboss.as.test.integration.security.common.config.SecurityModule;
import org.junit.Assert;
import org.junit.Test;
import org.wildfly.test.api.Authentication;

public abstract class AbstractNodeAuthentication {
    protected static final String COORDINATOR_NODE = "node0";
    protected static final String COORDINATOR_JGROUSP_CONFIG_MD5 = "jgroups-tcp-sasl-md5-node0.xml";
    protected static final String COORDINATOR_JGROUSP_CONFIG_MD5_USER = "jgroups-tcp-sasl-md5-user-node0.xml";
    protected static final String JOINING_NODE_JGROUSP_CONFIG_MD5 = "jgroups-tcp-sasl-md5-node1.xml";
    protected static final String COORDINATOR_JGROUSP_CONFIG_KRB = "jgroups-tcp-sasl-krb-node0.xml";
    protected static final String JOINING_NODE_JGROUSP_CONFIG_KRB = "jgroups-tcp-sasl-krb-node1.xml";
    protected static final String JOINING_NODE_JGROUSP_CONFIG_KRB_FAIL = "jgroups-tcp-sasl-krb-node1-fail.xml";
    protected static final String CACHE_NAME = "replicatedCache";
    protected static final String TEST_ITEM_KEY = "test_key";
    protected static final String TEST_ITEM_VALUE = "test_value";
    private static final String TRUE = Boolean.TRUE.toString();
    private static final Log LOG = LogFactory.getLog(AbstractNodeAuthentication.class);
    private final boolean krbProvided;
    @ArquillianResource
    protected ContainerController controller;
    @ArquillianResource
    protected Deployer deployer;

    protected abstract String getCoordinatorNodeConfig();

    protected abstract String getJoiningNodeName();

    protected abstract String getJoiningNodeConfig();

    public AbstractNodeAuthentication(boolean krbProvided) {
        this.krbProvided = krbProvided;
    }

    protected Cache<String, String> getReplicatedCache(EmbeddedCacheManager manager) {
        ConfigurationBuilder cacheConfig = new ConfigurationBuilder();
        cacheConfig.transaction().lockingMode(LockingMode.PESSIMISTIC);
        cacheConfig.invocationBatching().enable();
        cacheConfig.statistics().disable();
        cacheConfig.clustering().cacheMode(CacheMode.REPL_SYNC);
        manager.defineConfiguration(CACHE_NAME, cacheConfig.build());
        Cache replicatedCache = manager.getCache(CACHE_NAME);
        return replicatedCache;
    }

    protected EmbeddedCacheManager getCacheManager(String jgroupsConfigFile) {
        GlobalConfigurationBuilder globalConfig = new GlobalConfigurationBuilder();
        globalConfig.jmx().enabled(false);
        globalConfig.transport().defaultTransport().addProperty("configurationFile", jgroupsConfigFile);
        return new DefaultCacheManager(globalConfig.build());
    }

    @Test
    @InSequence(value=1)
    public void startNodes() throws Exception {
        this.controller.start(COORDINATOR_NODE);
        Assert.assertTrue((boolean)this.controller.isStarted(COORDINATOR_NODE));
        this.controller.start(this.getJoiningNodeName());
        Assert.assertTrue((boolean)this.controller.isStarted(this.getJoiningNodeName()));
        if (this.krbProvided) {
            for (ManagementClientParams params : this.getManagementClientListParams()) {
                ModelControllerClient client = AbstractNodeAuthentication.getModelControllerClient(params);
                ManagementClient managementClient = new ManagementClient(client, params.getHostname(), params.getPort().intValue(), "http-remoting");
                KerberosSystemPropertiesSetupTask.INSTANCE.setup(managementClient, null);
                SecurityTraceLoggingServerSetupTask.INSTANCE.setup(managementClient, null);
                SecurityDomainsSetupTask.INSTANCE.setup(managementClient, null);
            }
        }
        this.deployer.deploy(COORDINATOR_NODE);
        this.deployer.deploy(this.getJoiningNodeName());
    }

    @Test
    @OperateOnDeployment(value="node0")
    @InSequence(value=2)
    public void testCreateItemOnCoordinator() throws Exception {
        Cache<String, String> cache = this.getReplicatedCache(this.getCacheManager(this.getCoordinatorNodeConfig()));
        cache.put((Object)TEST_ITEM_KEY, (Object)TEST_ITEM_VALUE);
        Assert.assertEquals((Object)TEST_ITEM_VALUE, (Object)cache.get((Object)TEST_ITEM_KEY));
    }

    @Test
    @InSequence(value=3)
    public void testReadItemOnJoiningNode() throws Exception {
        EmbeddedCacheManager manager = this.getCacheManager(this.getJoiningNodeConfig());
        Cache<String, String> cache = this.getReplicatedCache(manager);
        Assert.assertEquals((String)"Insufficient number of cluster members", (long)2L, (long)manager.getMembers().size());
        Assert.assertEquals((Object)TEST_ITEM_VALUE, (Object)cache.get((Object)TEST_ITEM_KEY));
    }

    @Test
    @InSequence(value=4)
    public void stopJoiningNodes() throws Exception {
        this.deployer.undeploy(this.getJoiningNodeName());
        this.deployer.undeploy(COORDINATOR_NODE);
        if (this.krbProvided) {
            for (ManagementClientParams params : this.getManagementClientListParams()) {
                ModelControllerClient client = AbstractNodeAuthentication.getModelControllerClient(params);
                ManagementClient managementClient = new ManagementClient(client, params.getHostname(), params.getPort().intValue(), "http-remoting");
                KerberosSystemPropertiesSetupTask.INSTANCE.tearDown(managementClient, null);
                SecurityTraceLoggingServerSetupTask.INSTANCE.tearDown(managementClient, null);
                SecurityDomainsSetupTask.INSTANCE.tearDown(managementClient, null);
            }
        }
        try {
            this.controller.stop(this.getJoiningNodeName());
        }
        catch (Exception e) {
            LOG.warn((Object)"Joining node stop failed with %s", e.getCause());
            this.controller.kill(this.getJoiningNodeName());
        }
        try {
            this.controller.stop(COORDINATOR_NODE);
        }
        catch (Exception e) {
            LOG.warn((Object)"Coordinator node stop failed with %s", e.getCause());
            this.controller.kill(COORDINATOR_NODE);
        }
        Assert.assertFalse((boolean)this.controller.isStarted(this.getJoiningNodeName()));
        Assert.assertFalse((boolean)this.controller.isStarted(COORDINATOR_NODE));
    }

    public static ModelControllerClient getModelControllerClient(ManagementClientParams params) {
        try {
            return ModelControllerClient.Factory.create((InetAddress)InetAddress.getByName(params.getHostname()), (int)params.getPort(), (CallbackHandler)Authentication.getCallbackHandler());
        }
        catch (UnknownHostException e) {
            throw new RuntimeException(e);
        }
    }

    List<ManagementClientParams> getManagementClientListParams() {
        ArrayList<ManagementClientParams> list = new ArrayList<ManagementClientParams>();
        for (int i = 0; i < 2; ++i) {
            ManagementClientParams params = new ManagementClientParams(System.getProperty("node" + i + ".mgmt.addr"), 10090 + 100 * i);
            list.add(i, params);
        }
        return list;
    }

    static class Krb5ConfServerSetupTask
    extends AbstractKrb5ConfServerSetupTask {
        public static final File NODE0_KEYTAB_FILE = new File(KEYTABS_DIR, "jgroups_node0_clustered.keytab");
        public static final File NODE1_KEYTAB_FILE = new File(KEYTABS_DIR, "jgroups_node1_clustered.keytab");
        public static final File NODE1_FAIL_KEYTAB_FILE = new File(KEYTABS_DIR, "jgroups_node0_fail_clustered.keytab");
        private static boolean keytabsGenerated = false;

        Krb5ConfServerSetupTask() {
        }

        @Override
        public void setup(ManagementClient managementClient, String containerId) throws Exception {
            if (!keytabsGenerated) {
                super.setup(managementClient, containerId);
                keytabsGenerated = true;
            }
        }

        @Override
        public void tearDown(ManagementClient managementClient, String containerId) throws Exception {
            if (keytabsGenerated) {
                super.tearDown(managementClient, containerId);
                keytabsGenerated = false;
            }
        }

        @Override
        protected List<AbstractKrb5ConfServerSetupTask.UserForKeyTab> kerberosUsers() {
            ArrayList<AbstractKrb5ConfServerSetupTask.UserForKeyTab> users = new ArrayList<AbstractKrb5ConfServerSetupTask.UserForKeyTab>();
            users.add(new AbstractKrb5ConfServerSetupTask.UserForKeyTab("jgroups/node0/clustered@INFINISPAN.ORG", "node0password", NODE0_KEYTAB_FILE));
            users.add(new AbstractKrb5ConfServerSetupTask.UserForKeyTab("jgroups/node1/clustered@INFINISPAN.ORG", "node1password", NODE1_KEYTAB_FILE));
            users.add(new AbstractKrb5ConfServerSetupTask.UserForKeyTab("jgroups/node1/fail/clustered@INFINISPAN.ORG", "failpassword", NODE1_FAIL_KEYTAB_FILE));
            return users;
        }
    }

    static class KrbLdapServerSetupTask
    implements ServerSetupTask {
        private static ApacheDsKrbLdap krbLdapServer;
        private static boolean krbStarted;

        KrbLdapServerSetupTask() {
        }

        public void setup(ManagementClient managementClient, String s) throws Exception {
            String hostname = Utils.getCannonicalHost(managementClient);
            System.setProperty("java.security.krb5.conf", System.getProperty("java.io.tmpdir") + File.separator + "krb5.conf");
            if (!krbStarted) {
                krbLdapServer = new ApacheDsKrbLdap(hostname);
                krbLdapServer.start();
                krbStarted = true;
            }
        }

        public void tearDown(ManagementClient managementClient, String s) throws Exception {
            if (krbStarted) {
                krbLdapServer.stop();
                krbStarted = false;
            }
            ThreadLeakChecker.ignoreThreadsContaining((String)"pool-.*thread-");
        }

        static {
            krbStarted = false;
        }
    }

    static class SecurityDomainsSetupTask
    extends AbstractSecurityDomainsServerSetupTask {
        public static final String SECURITY_DOMAIN_PREFIX = "krb-";
        private static final String KEYTABS_DIR = "${java.io.tmpdir}" + File.separator + "keytabs" + File.separator;
        public static final SecurityDomainsSetupTask INSTANCE = new SecurityDomainsSetupTask();

        SecurityDomainsSetupTask() {
        }

        @Override
        protected SecurityDomain[] getSecurityDomains() {
            SecurityDomain krbNode0 = this.getKrbSecurityDomain(AbstractNodeAuthentication.COORDINATOR_NODE, KEYTABS_DIR + "jgroups_node0_clustered.keytab", "jgroups/node0/clustered@INFINISPAN.ORG");
            SecurityDomain krbNode1 = this.getKrbSecurityDomain("node1", KEYTABS_DIR + "jgroups_node1_clustered.keytab", "jgroups/node1/clustered@INFINISPAN.ORG");
            SecurityDomain krbFail = this.getKrbSecurityDomain("node1-fail", KEYTABS_DIR + "jgroups_node0_fail_clustered.keytab", "jgroups/node1/clustered2@INFINISPAN.ORG");
            return new SecurityDomain[]{krbNode0, krbNode1, krbFail};
        }

        private SecurityDomain getKrbSecurityDomain(String name, String path, String principal) {
            SecurityModule.Builder smBuilder = new SecurityModule.Builder();
            if (Utils.IBM_JDK) {
                smBuilder.name("com.ibm.security.auth.module.Krb5LoginModule").flag("required").putOption("useKeytab", path).putOption("credsType", "both").putOption("forwardable", TRUE).putOption("proxiable", TRUE).putOption("noAddress", TRUE);
            } else {
                smBuilder.name("Kerberos").flag("required").putOption("storeKey", "true").putOption("useKeyTab", "true").putOption("refreshKrb5Config", "true").putOption("doNotPrompt", "true").putOption("keyTab", path);
            }
            smBuilder.putOption("principal", principal + "@INFINISPAN.ORG").putOption("debug", TRUE);
            return new SecurityDomain.Builder().name(SECURITY_DOMAIN_PREFIX + name).cacheType("default").loginModules(new SecurityModule[]{smBuilder.build()}).build();
        }
    }

    static class SecurityTraceLoggingServerSetupTask
    extends AbstractTraceLoggingServerSetupTask {
        public static final SecurityTraceLoggingServerSetupTask INSTANCE = new SecurityTraceLoggingServerSetupTask();

        SecurityTraceLoggingServerSetupTask() {
        }

        @Override
        protected Collection<String> getCategories(ManagementClient managementClient, String containerId) {
            return Arrays.asList("javax.security", "org.jboss.security", "org.picketbox", "org.wildfly.security");
        }
    }

    static class KerberosSystemPropertiesSetupTask
    extends AbstractSystemPropertiesServerSetupTask {
        public static final KerberosSystemPropertiesSetupTask INSTANCE = new KerberosSystemPropertiesSetupTask();

        KerberosSystemPropertiesSetupTask() {
        }

        @Override
        protected AbstractSystemPropertiesServerSetupTask.SystemProperty[] getSystemProperties() {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("java.security.krb5.conf", "${java.io.tmpdir}" + File.separator + "krb5.conf");
            map.put("java.security.krb5.debug", TRUE);
            map.put("jboss.security.disable.secdomain.option", TRUE);
            return KerberosSystemPropertiesSetupTask.mapToSystemProperties(map);
        }
    }
}

