/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.test.integration.security.embedded;

import org.infinispan.Cache;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.test.integration.security.embedded.AbstractNodeAuthentication;
import org.infinispan.test.integration.security.utils.Deployments;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.container.test.api.OperateOnDeployment;
import org.jboss.arquillian.container.test.api.TargetsContainer;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.arquillian.junit.InSequence;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.runner.RunWith;

@Ignore
@RunWith(value=Arquillian.class)
public class NodeAuthPropertiesHandlerIT
extends AbstractNodeAuthentication {
    protected static final String COORDINATOR_JGROUSP_CONFIG_MD5 = "jgroups-tcp-sasl-prop-handler-node0.xml";
    protected static final String JOINING_NODE_JGROUSP_CONFIG_MD5 = "jgroups-tcp-sasl-prop-handler-node1.xml";
    protected static final String COORDINATOR_NODE = "simple-auth-node0";
    protected static final String JOINING_NODE = "simple-auth-node1";
    private static final Log LOG = LogFactory.getLog(NodeAuthPropertiesHandlerIT.class);

    public NodeAuthPropertiesHandlerIT() {
        super(false);
    }

    @Override
    protected String getCoordinatorNodeConfig() {
        return COORDINATOR_JGROUSP_CONFIG_MD5;
    }

    @Override
    protected String getJoiningNodeName() {
        return JOINING_NODE;
    }

    @Override
    protected String getJoiningNodeConfig() {
        return JOINING_NODE_JGROUSP_CONFIG_MD5;
    }

    @Deployment(name="simple-auth-node0", managed=false)
    @TargetsContainer(value="simple-auth-node0")
    public static WebArchive getCoordinatorDeployment() {
        return Deployments.createNodeAuthTestDeployment(COORDINATOR_JGROUSP_CONFIG_MD5);
    }

    @Deployment(name="simple-auth-node1", managed=false)
    @TargetsContainer(value="simple-auth-node1")
    public static WebArchive getJoiningNodeDeployment() {
        return Deployments.createNodeAuthTestDeployment(JOINING_NODE_JGROUSP_CONFIG_MD5);
    }

    @Override
    @Test
    @InSequence(value=1)
    public void startNodes() throws Exception {
        this.controller.start(COORDINATOR_NODE);
        Assert.assertTrue((boolean)this.controller.isStarted(COORDINATOR_NODE));
        this.controller.start(this.getJoiningNodeName());
        Assert.assertTrue((boolean)this.controller.isStarted(this.getJoiningNodeName()));
        this.deployer.deploy(COORDINATOR_NODE);
        this.deployer.deploy(this.getJoiningNodeName());
    }

    @Override
    @Test
    @OperateOnDeployment(value="simple-auth-node0")
    @InSequence(value=2)
    public void testCreateItemOnCoordinator() throws Exception {
        Cache<String, String> cache = this.getReplicatedCache(this.getCacheManager(this.getCoordinatorNodeConfig()));
        cache.put((Object)"test_key", (Object)"test_value");
        Assert.assertEquals((Object)"test_value", (Object)cache.get((Object)"test_key"));
    }

    @Override
    @Test
    @OperateOnDeployment(value="simple-auth-node1")
    @InSequence(value=3)
    public void testReadItemOnJoiningNode() throws Exception {
        EmbeddedCacheManager manager = this.getCacheManager(this.getJoiningNodeConfig());
        Cache<String, String> cache = this.getReplicatedCache(manager);
        Assert.assertEquals((String)"Insufficient number of cluster members", (long)2L, (long)manager.getMembers().size());
        Assert.assertEquals((Object)"test_value", (Object)cache.get((Object)"test_key"));
    }

    @Override
    @Test
    @InSequence(value=4)
    public void stopJoiningNodes() throws Exception {
        this.deployer.undeploy(this.getJoiningNodeName());
        this.deployer.undeploy(COORDINATOR_NODE);
        try {
            this.controller.stop(this.getJoiningNodeName());
        }
        catch (Exception e) {
            LOG.warn((Object)"Joining node stop failed with %s", e.getCause());
            this.controller.kill(this.getJoiningNodeName());
        }
        try {
            this.controller.stop(COORDINATOR_NODE);
        }
        catch (Exception e) {
            LOG.warn((Object)"Coordinator node stop failed with %s", e.getCause());
            this.controller.kill(COORDINATOR_NODE);
        }
        Assert.assertFalse((boolean)this.controller.isStarted(this.getJoiningNodeName()));
        Assert.assertFalse((boolean)this.controller.isStarted(COORDINATOR_NODE));
    }
}

