/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.test.integration.security.utils;

import java.io.IOException;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.sasl.AuthorizeCallback;
import javax.security.sasl.RealmCallback;

public class SaslPropAuthUserCallbackHandler
implements CallbackHandler {
    private static final String APPROVED_USER = "test_user";
    private final String name = System.getProperty("sasl.username");
    private final char[] password = System.getProperty("sasl.password").toCharArray();
    private final String realm = System.getProperty("sasl.realm");

    @Override
    public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
        for (Callback callback : callbacks) {
            if (callback instanceof PasswordCallback) {
                ((PasswordCallback)callback).setPassword(this.password);
                continue;
            }
            if (callback instanceof NameCallback) {
                ((NameCallback)callback).setName(this.name);
                continue;
            }
            if (callback instanceof AuthorizeCallback) {
                AuthorizeCallback authorizeCallback = (AuthorizeCallback)callback;
                if (APPROVED_USER.equals(authorizeCallback.getAuthorizationID())) {
                    authorizeCallback.setAuthorized(true);
                    continue;
                }
                authorizeCallback.setAuthorized(false);
                continue;
            }
            if (callback instanceof RealmCallback) {
                RealmCallback realmCallback = (RealmCallback)callback;
                realmCallback.setText(this.realm);
                continue;
            }
            throw new UnsupportedCallbackException(callback);
        }
    }
}

