/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.test.integration.security.utils;

import java.io.File;
import java.net.URL;
import java.util.HashMap;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.text.StrSubstitutor;
import org.apache.directory.api.ldap.model.entry.DefaultEntry;
import org.apache.directory.api.ldap.model.entry.Entry;
import org.apache.directory.api.ldap.model.ldif.LdifEntry;
import org.apache.directory.api.ldap.model.ldif.LdifReader;
import org.apache.directory.api.ldap.model.schema.SchemaManager;
import org.apache.directory.server.annotations.CreateKdcServer;
import org.apache.directory.server.annotations.CreateLdapServer;
import org.apache.directory.server.annotations.CreateTransport;
import org.apache.directory.server.annotations.SaslMechanism;
import org.apache.directory.server.core.annotations.AnnotationUtils;
import org.apache.directory.server.core.annotations.ContextEntry;
import org.apache.directory.server.core.annotations.CreateDS;
import org.apache.directory.server.core.annotations.CreateIndex;
import org.apache.directory.server.core.annotations.CreatePartition;
import org.apache.directory.server.core.api.DirectoryService;
import org.apache.directory.server.core.factory.DSAnnotationProcessor;
import org.apache.directory.server.core.kerberos.KeyDerivationInterceptor;
import org.apache.directory.server.factory.ServerAnnotationProcessor;
import org.apache.directory.server.kerberos.kdc.KdcServer;
import org.apache.directory.server.ldap.LdapServer;
import org.apache.directory.server.ldap.handlers.sasl.cramMD5.CramMd5MechanismHandler;
import org.apache.directory.server.ldap.handlers.sasl.digestMD5.DigestMd5MechanismHandler;
import org.apache.directory.server.ldap.handlers.sasl.gssapi.GssapiMechanismHandler;
import org.apache.directory.server.ldap.handlers.sasl.ntlm.NtlmMechanismHandler;
import org.apache.directory.server.ldap.handlers.sasl.plain.PlainMechanismHandler;
import org.infinispan.commons.logging.Log;
import org.infinispan.commons.logging.LogFactory;
import org.infinispan.test.integration.security.utils.KdcServerAnnotationProcessor;

public class ApacheDsKrbLdap {
    public static final int LDAP_PORT = 10389;
    public static final int KERBEROS_PORT = 6088;
    public static final String KERBEROS_PRIMARY_REALM = "INFINISPAN.ORG";
    public static final String LDAP_INIT_FILE = "ldif/ispn-krb-test.ldif";
    public static final String BASE_DN = "dc=infinispan,dc=org";
    private static Log log = LogFactory.getLog(ApacheDsKrbLdap.class);
    private DirectoryService directoryService;
    private LdapServer ldapServer;
    private KdcServer kdcServer;

    public ApacheDsKrbLdap(String hostname) throws Exception {
        this.createDs();
        this.createKdc();
        this.createLdap(hostname);
    }

    public void start() throws Exception {
        this.ldapServer.start();
    }

    public void stop() throws Exception {
        this.kdcServer.stop();
        this.ldapServer.stop();
        this.directoryService.shutdown();
        FileUtils.deleteDirectory((File)this.directoryService.getInstanceLayout().getInstanceDirectory());
    }

    @CreateDS(name="InfinispanDS", partitions={@CreatePartition(name="infinispan", suffix="dc=infinispan,dc=org", contextEntry=@ContextEntry(entryLdif="dn: dc=infinispan,dc=org\ndc: infinispan\nobjectClass: top\nobjectClass: domain\n\n"), indexes={@CreateIndex(attribute="objectClass"), @CreateIndex(attribute="dc"), @CreateIndex(attribute="ou")})}, additionalInterceptors={KeyDerivationInterceptor.class})
    public void createDs() throws Exception {
        this.directoryService = DSAnnotationProcessor.getDirectoryService();
    }

    @CreateKdcServer(primaryRealm="INFINISPAN.ORG", kdcPrincipal="krbtgt/INFINISPAN.ORG@INFINISPAN.ORG", searchBaseDn="dc=infinispan,dc=org", transports={@CreateTransport(protocol="UDP", port=6088)})
    public void createKdc() throws Exception {
        this.kdcServer = KdcServerAnnotationProcessor.getKdcServer(this.directoryService);
    }

    @CreateLdapServer(transports={@CreateTransport(protocol="LDAP", port=10389)}, saslRealms={"INFINISPAN.ORG"}, saslMechanisms={@SaslMechanism(name="GSSAPI", implClass=GssapiMechanismHandler.class), @SaslMechanism(name="PLAIN", implClass=PlainMechanismHandler.class), @SaslMechanism(name="CRAM-MD5", implClass=CramMd5MechanismHandler.class), @SaslMechanism(name="DIGEST-MD5", implClass=DigestMd5MechanismHandler.class), @SaslMechanism(name="NTLM", implClass=NtlmMechanismHandler.class), @SaslMechanism(name="GSS-SPNEGO", implClass=NtlmMechanismHandler.class)})
    public void createLdap(String hostname) throws Exception {
        String initFile = System.getProperty("ldap.init.file", LDAP_INIT_FILE);
        String ldifContent = IOUtils.toString((URL)this.getClass().getClassLoader().getResource(initFile), (String)"UTF-8");
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("hostname", hostname);
        SchemaManager schemaManager = this.directoryService.getSchemaManager();
        try {
            for (LdifEntry ldifEntry : new LdifReader(IOUtils.toInputStream((String)StrSubstitutor.replace((Object)ldifContent, map)))) {
                this.directoryService.getAdminSession().add((Entry)new DefaultEntry(schemaManager, ldifEntry.getEntry()));
            }
        }
        catch (Exception e) {
            log.error((Object)"Error adding ldif entries", (Throwable)e);
            throw e;
        }
        CreateLdapServer createLdapServer = (CreateLdapServer)AnnotationUtils.getInstance(CreateLdapServer.class);
        this.ldapServer = ServerAnnotationProcessor.instantiateLdapServer((CreateLdapServer)createLdapServer, (DirectoryService)this.directoryService);
        this.ldapServer.setSearchBaseDn(BASE_DN);
        this.ldapServer.setSaslHost(hostname);
        this.ldapServer.setSaslPrincipal("ldap/" + hostname + "@INFINISPAN.ORG");
    }
}

