/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.test.integration.security.embedded;

import java.security.PrivilegedExceptionAction;
import java.util.HashMap;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.login.LoginException;
import org.infinispan.Cache;
import org.infinispan.security.AuthorizationPermission;
import org.infinispan.test.integration.security.embedded.AbstractLdapAuthentication;
import org.jboss.arquillian.junit.Arquillian;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=Arquillian.class)
public class LdapAuthenticationIT
extends AbstractLdapAuthentication {
    public static final String ADMIN_ROLE = "admin";
    public static final String ADMIN_PASSWD = "strong_password";
    public static final String WRITER_ROLE = "writer";
    public static final String WRITER_PASSWD = "some_password";
    public static final String READER_ROLE = "reader";
    public static final String READER_PASSWD = "password";
    public static final String UNPRIVILEGED_ROLE = "unprivileged";
    public static final String UNPRIVILEGED_PASSWD = "weak_password";

    @Override
    public Map<String, AuthorizationPermission[]> getRolePermissionMap() {
        HashMap<String, AuthorizationPermission[]> roles = new HashMap<String, AuthorizationPermission[]>();
        roles.put(ADMIN_ROLE, new AuthorizationPermission[]{AuthorizationPermission.ALL});
        roles.put(WRITER_ROLE, new AuthorizationPermission[]{AuthorizationPermission.WRITE});
        roles.put(READER_ROLE, new AuthorizationPermission[]{AuthorizationPermission.READ});
        roles.put(UNPRIVILEGED_ROLE, new AuthorizationPermission[]{AuthorizationPermission.NONE});
        return roles;
    }

    @Override
    public Subject getAdminSubject() throws LoginException {
        return this.authenticate(ADMIN_ROLE, ADMIN_PASSWD);
    }

    @Test
    public void testAdminCRUD() throws Exception {
        Subject admin = this.authenticate(ADMIN_ROLE, ADMIN_PASSWD);
        Subject.doAs(admin, new PrivilegedExceptionAction<Void>(){

            @Override
            public Void run() throws Exception {
                Assert.assertEquals((Object)"predefined value", (Object)LdapAuthenticationIT.this.secureCache.get((Object)"predefined key"));
                LdapAuthenticationIT.this.secureCache.put((Object)"test", (Object)"test value");
                Assert.assertEquals((Object)"test value", (Object)LdapAuthenticationIT.this.secureCache.get((Object)"test"));
                Cache c = LdapAuthenticationIT.this.manager.getCache("adminCache");
                c.start();
                c.put((Object)"test", (Object)"value");
                Assert.assertEquals((Object)"value", (Object)c.get((Object)"test"));
                c.remove((Object)"test");
                Assert.assertEquals(null, (Object)c.get((Object)"test"));
                c.stop();
                return null;
            }
        });
    }

    @Test
    public void testWriterWrite() throws Exception {
        Subject reader = this.authenticate(WRITER_ROLE, WRITER_PASSWD);
        Subject.doAs(reader, new PrivilegedExceptionAction<Void>(){

            @Override
            public Void run() throws Exception {
                LdapAuthenticationIT.this.secureCache.put((Object)"test", (Object)"test value");
                return null;
            }
        });
    }

    @Test
    public void testWriterCreateWrite() throws Exception {
        Subject reader = this.authenticate(WRITER_ROLE, WRITER_PASSWD);
        Subject.doAs(reader, new PrivilegedExceptionAction<Void>(){

            @Override
            public Void run() throws Exception {
                Cache c = LdapAuthenticationIT.this.manager.getCache("writerCache");
                c.put((Object)"test", (Object)"value");
                return null;
            }
        });
    }

    @Test
    public void testWriterRemove() throws Exception {
        Subject reader = this.authenticate(WRITER_ROLE, WRITER_PASSWD);
        Subject.doAs(reader, new PrivilegedExceptionAction<Void>(){

            @Override
            public Void run() throws Exception {
                LdapAuthenticationIT.this.secureCache.remove((Object)"predefined key");
                return null;
            }
        });
    }

    @Test(expected=SecurityException.class)
    public void testWriterRead() throws Exception {
        Subject reader = this.authenticate(WRITER_ROLE, WRITER_PASSWD);
        Subject.doAs(reader, new PrivilegedExceptionAction<Void>(){

            @Override
            public Void run() throws Exception {
                LdapAuthenticationIT.this.secureCache.get((Object)"predefined key");
                return null;
            }
        });
    }

    @Test
    public void testReaderRead() throws Exception {
        Subject reader = this.authenticate(READER_ROLE, READER_PASSWD);
        Subject.doAs(reader, new PrivilegedExceptionAction<Void>(){

            @Override
            public Void run() throws Exception {
                Assert.assertEquals((Object)"predefined value", (Object)LdapAuthenticationIT.this.secureCache.get((Object)"predefined key"));
                return null;
            }
        });
    }

    @Test(expected=SecurityException.class)
    public void testReaderWrite() throws Exception {
        Subject reader = this.authenticate(READER_ROLE, READER_PASSWD);
        Subject.doAs(reader, new PrivilegedExceptionAction<Void>(){

            @Override
            public Void run() throws Exception {
                LdapAuthenticationIT.this.secureCache.put((Object)"test", (Object)"test value");
                return null;
            }
        });
    }

    @Test(expected=SecurityException.class)
    public void testReaderRemove() throws Exception {
        Subject reader = this.authenticate(READER_ROLE, READER_PASSWD);
        Subject.doAs(reader, new PrivilegedExceptionAction<Void>(){

            @Override
            public Void run() throws Exception {
                LdapAuthenticationIT.this.secureCache.remove((Object)"predefined key");
                return null;
            }
        });
    }

    @Test(expected=SecurityException.class)
    public void testUnprivilegedRead() throws Exception {
        Subject reader = this.authenticate(UNPRIVILEGED_ROLE, UNPRIVILEGED_PASSWD);
        Subject.doAs(reader, new PrivilegedExceptionAction<Void>(){

            @Override
            public Void run() throws Exception {
                LdapAuthenticationIT.this.secureCache.get((Object)"predefined key");
                return null;
            }
        });
    }

    @Test(expected=SecurityException.class)
    public void testUnprivilegedWrite() throws Exception {
        Subject reader = this.authenticate(UNPRIVILEGED_ROLE, UNPRIVILEGED_PASSWD);
        Subject.doAs(reader, new PrivilegedExceptionAction<Void>(){

            @Override
            public Void run() throws Exception {
                LdapAuthenticationIT.this.secureCache.put((Object)"test", (Object)"test value");
                return null;
            }
        });
    }

    @Test(expected=SecurityException.class)
    public void testUnprivilegedRemove() throws Exception {
        Subject reader = this.authenticate(UNPRIVILEGED_ROLE, UNPRIVILEGED_PASSWD);
        Subject.doAs(reader, new PrivilegedExceptionAction<Void>(){

            @Override
            public Void run() throws Exception {
                LdapAuthenticationIT.this.secureCache.remove((Object)"predefined key");
                return null;
            }
        });
    }

    @Test(expected=SecurityException.class)
    public void testUnauthenticatedRead() throws Exception {
        this.secureCache.get((Object)"predefined key");
    }

    @Test(expected=SecurityException.class)
    public void testUnauthenticatedWrite() throws Exception {
        this.secureCache.put((Object)"test", (Object)"value");
    }

    @Test(expected=SecurityException.class)
    public void testUnauthenticatedRemove() throws Exception {
        this.secureCache.remove((Object)"predefined key");
    }
}

