/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.test.integration.security.embedded;

import java.util.HashMap;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.login.LoginException;
import org.infinispan.security.AuthorizationPermission;
import org.infinispan.security.PrincipalRoleMapper;
import org.infinispan.security.impl.IdentityRoleMapper;
import org.infinispan.test.integration.security.embedded.AbstractAuthentication;
import org.infinispan.test.integration.security.utils.ApacheDsLdap;
import org.infinispan.test.integration.security.utils.Deployments;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.runner.RunWith;

@RunWith(value=Arquillian.class)
public class LdapAuthenticationIT
extends AbstractAuthentication {
    public static final String SECURITY_DOMAIN_NAME = "ispn-secure";
    public static final String ADMIN_ROLE = "admin";
    public static final String ADMIN_PASSWD = "strong_password";
    public static final String WRITER_ROLE = "writer";
    public static final String WRITER_PASSWD = "some_password";
    public static final String READER_ROLE = "reader";
    public static final String READER_PASSWD = "password";
    public static final String UNPRIVILEGED_ROLE = "unprivileged";
    public static final String UNPRIVILEGED_PASSWD = "weak_password";
    private static ApacheDsLdap ldapServer;

    @BeforeClass
    public static void ldapSetup() throws Exception {
        ldapServer = new ApacheDsLdap("localhost");
        ldapServer.start();
    }

    @AfterClass
    public static void ldapTearDown() throws Exception {
        ldapServer.stop();
    }

    @Deployment
    public static WebArchive getDeployment() {
        return Deployments.createKrbLdapTestDeployment();
    }

    @Override
    public Map<String, AuthorizationPermission[]> getRolePermissionMap() {
        HashMap<String, AuthorizationPermission[]> roles = new HashMap<String, AuthorizationPermission[]>();
        roles.put(ADMIN_ROLE, new AuthorizationPermission[]{AuthorizationPermission.ALL});
        roles.put(WRITER_ROLE, new AuthorizationPermission[]{AuthorizationPermission.WRITE});
        roles.put(READER_ROLE, new AuthorizationPermission[]{AuthorizationPermission.READ});
        roles.put(UNPRIVILEGED_ROLE, new AuthorizationPermission[]{AuthorizationPermission.NONE});
        return roles;
    }

    @Override
    public PrincipalRoleMapper getPrincipalRoleMapper() {
        return new IdentityRoleMapper();
    }

    @Override
    public String getSecurityDomainName() {
        return SECURITY_DOMAIN_NAME;
    }

    @Override
    public Subject getAdminSubject() throws LoginException {
        return this.authenticate(ADMIN_ROLE, ADMIN_PASSWD);
    }

    @Override
    public Subject getWriterSubject() throws LoginException {
        return this.authenticate(WRITER_ROLE, WRITER_PASSWD);
    }

    @Override
    public Subject getReaderSubject() throws LoginException {
        return this.authenticate(READER_ROLE, READER_PASSWD);
    }

    @Override
    public Subject getUnprivilegedSubject() throws LoginException {
        return this.authenticate(UNPRIVILEGED_ROLE, UNPRIVILEGED_PASSWD);
    }
}

