/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.test.integration.security.embedded;

import org.infinispan.Cache;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.manager.DefaultCacheManager;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.transaction.LockingMode;
import org.jboss.arquillian.container.test.api.ContainerController;
import org.jboss.arquillian.container.test.api.Deployer;
import org.jboss.arquillian.container.test.api.OperateOnDeployment;
import org.jboss.arquillian.junit.InSequence;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.junit.Assert;
import org.junit.Test;

public abstract class AbstractNodeAuthentication {
    protected static final String COORDINATOR_NODE = "node0";
    protected static final String COORDINATOR_JGROUSP_CONFIG_MD5 = "jgroups-tcp-sasl-md5-node0.xml";
    protected static final String COORDINATOR_JGROUSP_CONFIG_MD5_USER = "jgroups-tcp-sasl-md5-user-node0.xml";
    protected static final String JOINING_NODE_JGROUSP_CONFIG_MD5 = "jgroups-tcp-sasl-md5-node1.xml";
    protected static final String COORDINATOR_JGROUSP_CONFIG_KRB = "jgroups-tcp-sasl-krb-node0.xml";
    protected static final String JOINING_NODE_JGROUSP_CONFIG_KRB = "jgroups-tcp-sasl-krb-node1.xml";
    protected static final String JOINING_NODE_JGROUSP_CONFIG_KRB_FAIL = "jgroups-tcp-sasl-krb-node1-fail.xml";
    protected static final String CACHE_NAME = "replicatedCache";
    protected static final String TEST_ITEM_KEY = "test_key";
    protected static final String TEST_ITEM_VALUE = "test_value";
    @ArquillianResource
    protected ContainerController controller;
    @ArquillianResource
    protected Deployer deployer;

    protected abstract String getCoordinatorNodeConfig();

    protected abstract String getJoiningNodeName();

    protected abstract String getJoiningNodeConfig();

    protected Cache<String, String> getReplicatedCache(EmbeddedCacheManager manager) throws Exception {
        ConfigurationBuilder cacheConfig = new ConfigurationBuilder();
        cacheConfig.transaction().lockingMode(LockingMode.PESSIMISTIC);
        cacheConfig.invocationBatching().enable();
        cacheConfig.jmxStatistics().disable();
        cacheConfig.clustering().cacheMode(CacheMode.REPL_SYNC);
        manager.defineConfiguration(CACHE_NAME, cacheConfig.build());
        Cache replicatedCache = manager.getCache(CACHE_NAME);
        return replicatedCache;
    }

    private EmbeddedCacheManager getCacheManager(String jgrousConfigFile) {
        GlobalConfigurationBuilder globalConfig = new GlobalConfigurationBuilder();
        globalConfig.globalJmxStatistics().disable();
        globalConfig.globalJmxStatistics().mBeanServerLookup(null);
        globalConfig.transport().defaultTransport().addProperty("configurationFile", jgrousConfigFile);
        DefaultCacheManager manager = new DefaultCacheManager(globalConfig.build());
        return manager;
    }

    @Test
    @InSequence(value=1)
    public void startNodes() throws Exception {
        this.controller.start(COORDINATOR_NODE);
        Assert.assertTrue((boolean)this.controller.isStarted(COORDINATOR_NODE));
        this.controller.start(this.getJoiningNodeName());
        Assert.assertTrue((boolean)this.controller.isStarted(this.getJoiningNodeName()));
        this.deployer.deploy(COORDINATOR_NODE);
        this.deployer.deploy(this.getJoiningNodeName());
    }

    @Test
    @OperateOnDeployment(value="node0")
    @InSequence(value=2)
    public void testCreateItemOnCoordinator() throws Exception {
        Cache<String, String> cache = this.getReplicatedCache(this.getCacheManager(this.getCoordinatorNodeConfig()));
        cache.put((Object)TEST_ITEM_KEY, (Object)TEST_ITEM_VALUE);
        Assert.assertEquals((Object)TEST_ITEM_VALUE, (Object)cache.get((Object)TEST_ITEM_KEY));
    }

    @Test
    @InSequence(value=3)
    public void testReadItemOnJoiningNode() throws Exception {
        EmbeddedCacheManager manager = this.getCacheManager(this.getJoiningNodeConfig());
        Cache<String, String> cache = this.getReplicatedCache(manager);
        Assert.assertEquals((String)"Insufficient number of cluster members", (long)2L, (long)manager.getMembers().size());
        Assert.assertEquals((Object)TEST_ITEM_VALUE, (Object)cache.get((Object)TEST_ITEM_KEY));
    }

    @Test
    @InSequence(value=4)
    public void stopJoiningNodes() throws Exception {
        this.deployer.undeploy(this.getJoiningNodeName());
        this.deployer.undeploy(COORDINATOR_NODE);
        this.controller.stop(this.getJoiningNodeName());
        Assert.assertFalse((boolean)this.controller.isStarted(this.getJoiningNodeName()));
        this.controller.stop(COORDINATOR_NODE);
        Assert.assertFalse((boolean)this.controller.isStarted(COORDINATOR_NODE));
    }
}

