/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.test.integration.security.utils;

import java.io.File;
import java.net.URL;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.directory.api.ldap.model.entry.DefaultEntry;
import org.apache.directory.api.ldap.model.entry.Entry;
import org.apache.directory.api.ldap.model.ldif.LdifEntry;
import org.apache.directory.api.ldap.model.ldif.LdifReader;
import org.apache.directory.api.ldap.model.schema.SchemaManager;
import org.apache.directory.server.annotations.CreateLdapServer;
import org.apache.directory.server.annotations.CreateTransport;
import org.apache.directory.server.core.annotations.AnnotationUtils;
import org.apache.directory.server.core.annotations.ContextEntry;
import org.apache.directory.server.core.annotations.CreateDS;
import org.apache.directory.server.core.annotations.CreateIndex;
import org.apache.directory.server.core.annotations.CreatePartition;
import org.apache.directory.server.core.api.DirectoryService;
import org.apache.directory.server.core.factory.DSAnnotationProcessor;
import org.apache.directory.server.factory.ServerAnnotationProcessor;
import org.apache.directory.server.ldap.LdapServer;
import org.infinispan.commons.logging.Log;
import org.infinispan.commons.logging.LogFactory;

public class ApacheDsLdap {
    public static final int LDAP_PORT = 10389;
    public static final String LDAP_INIT_FILE = "ldif/ispn-test.ldif";
    private static Log log = LogFactory.getLog(ApacheDsLdap.class);
    protected DirectoryService directoryService;
    protected LdapServer ldapServer;

    public ApacheDsLdap(String hostname) throws Exception {
        this.createDs();
        this.createLdap(hostname);
    }

    public void start() throws Exception {
        this.ldapServer.start();
    }

    public void stop() throws Exception {
        this.ldapServer.stop();
        this.directoryService.shutdown();
        FileUtils.deleteDirectory((File)this.directoryService.getInstanceLayout().getInstanceDirectory());
    }

    @CreateDS(name="InfinispanDS", partitions={@CreatePartition(name="infinispan", suffix="dc=infinispan,dc=org", contextEntry=@ContextEntry(entryLdif="dn: dc=infinispan,dc=org\ndc: infinispan\nobjectClass: top\nobjectClass: domain\n\n"), indexes={@CreateIndex(attribute="objectClass"), @CreateIndex(attribute="dc"), @CreateIndex(attribute="ou")})})
    public void createDs() throws Exception {
        this.directoryService = DSAnnotationProcessor.getDirectoryService();
    }

    @CreateLdapServer(transports={@CreateTransport(protocol="LDAP", port=10389)})
    public void createLdap(String hostname) throws Exception {
        String initFile = System.getProperty("ldap.init.file", LDAP_INIT_FILE);
        String ldifContent = IOUtils.toString((URL)this.getClass().getClassLoader().getResource(initFile));
        SchemaManager schemaManager = this.directoryService.getSchemaManager();
        try {
            for (LdifEntry ldifEntry : new LdifReader(IOUtils.toInputStream((String)ldifContent))) {
                this.directoryService.getAdminSession().add((Entry)new DefaultEntry(schemaManager, ldifEntry.getEntry()));
            }
        }
        catch (Exception e) {
            log.error((Object)"Error adding ldif entries", (Throwable)e);
            throw e;
        }
        CreateLdapServer createLdapServer = (CreateLdapServer)AnnotationUtils.getInstance(CreateLdapServer.class);
        this.ldapServer = ServerAnnotationProcessor.instantiateLdapServer((CreateLdapServer)createLdapServer, (DirectoryService)this.directoryService);
    }
}

