/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.test.integration.security.tasks;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.text.StrSubstitutor;
import org.apache.directory.server.kerberos.shared.crypto.encryption.KerberosKeyFactory;
import org.apache.directory.server.kerberos.shared.keytab.Keytab;
import org.apache.directory.shared.kerberos.KerberosTime;
import org.apache.directory.shared.kerberos.codec.types.EncryptionType;
import org.apache.directory.shared.kerberos.components.EncryptionKey;
import org.infinispan.test.integration.security.utils.Utils;
import org.jboss.as.arquillian.api.ServerSetupTask;
import org.jboss.as.arquillian.container.ManagementClient;
import org.jboss.logging.Logger;

public abstract class AbstractKrb5ConfServerSetupTask
implements ServerSetupTask {
    private static Logger LOGGER = Logger.getLogger(AbstractKrb5ConfServerSetupTask.class);
    private static final String JAVA_IO_TMP_DIR = System.getProperty("java.io.tmpdir");
    protected static final File KEYTABS_DIR = new File(JAVA_IO_TMP_DIR + File.separator + "keytabs");
    private static final String KRB5_CONF = "krb5.conf";
    private static final File KRB5_CONF_FILE = new File(JAVA_IO_TMP_DIR, "krb5.conf");
    public static final File LDAP_KEYTAB_FILE = new File(KEYTABS_DIR, "ldap-service.keytab");
    private String origKrb5Conf;
    private String origKrbDebug;
    private String origIbmJGSSDebug;
    private String origIbmKrbDebug;

    public void setup(ManagementClient managementClient, String containerId) throws Exception {
        LOGGER.info((Object)("(Re)Creating workdir: " + KEYTABS_DIR.getAbsolutePath()));
        FileUtils.deleteDirectory((File)KEYTABS_DIR);
        KEYTABS_DIR.mkdirs();
        String cannonicalHost = Utils.getCannonicalHost(managementClient);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("hostname", cannonicalHost);
        String supportedEncTypes = this.getSupportedEncTypes();
        map.put("enctypes", supportedEncTypes);
        LOGGER.info((Object)("Supported enctypes in krb5.conf: " + supportedEncTypes));
        FileUtils.write((File)KRB5_CONF_FILE, (CharSequence)StrSubstitutor.replace((Object)IOUtils.toString((InputStream)this.getClass().getResourceAsStream(File.separator + KRB5_CONF), (String)"UTF-8"), map), (String)"UTF-8");
        this.createLdapServerKeytab(cannonicalHost);
        List<UserForKeyTab> kerberosUsers = this.kerberosUsers();
        if (kerberosUsers != null) {
            for (UserForKeyTab userForKeyTab : kerberosUsers) {
                this.createKeytab(userForKeyTab.getUser(), userForKeyTab.getPassword(), userForKeyTab.getKeyTabFileName());
            }
        }
        LOGGER.info((Object)("Setting Kerberos configuration: " + KRB5_CONF_FILE));
        this.origKrb5Conf = Utils.setSystemProperty("java.security.krb5.conf", KRB5_CONF_FILE.getAbsolutePath());
        this.origKrbDebug = Utils.setSystemProperty("sun.security.krb5.debug", "true");
        this.origIbmJGSSDebug = Utils.setSystemProperty("com.ibm.security.jgss.debug", "all");
        this.origIbmKrbDebug = Utils.setSystemProperty("com.ibm.security.krb5.Krb5Debug", "all");
    }

    public void tearDown(ManagementClient managementClient, String containerId) throws Exception {
        FileUtils.deleteDirectory((File)KEYTABS_DIR);
        FileUtils.deleteQuietly((File)KRB5_CONF_FILE);
        Utils.setSystemProperty("java.security.krb5.conf", this.origKrb5Conf);
        Utils.setSystemProperty("sun.security.krb5.debug", this.origKrbDebug);
        Utils.setSystemProperty("com.ibm.security.jgss.debug", this.origIbmJGSSDebug);
        Utils.setSystemProperty("com.ibm.security.krb5.Krb5Debug", this.origIbmKrbDebug);
    }

    public static final String getKrb5ConfFullPath() {
        return KRB5_CONF_FILE.getAbsolutePath();
    }

    public static final String getKeyTabFullPath() {
        return LDAP_KEYTAB_FILE.getAbsolutePath();
    }

    protected void createLdapServerKeytab(String host) throws IOException {
        this.createKeytab("ldap/" + host + "@INFINISPAN.ORG", "ldapPassword", LDAP_KEYTAB_FILE);
    }

    private String getSupportedEncTypes() {
        ArrayList<String> enctypesList = new ArrayList<String>();
        for (EncryptionType encType : KerberosKeyFactory.getKerberosKeys((String)"dummy@INFINISPAN.ORG", (String)"dummy").keySet()) {
            enctypesList.add(encType.getName());
        }
        return StringUtils.join(enctypesList, (char)',');
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void createKeytab(String principalName, String passPhrase, File keytabFile) throws IOException {
        LOGGER.info((Object)("Principal name: " + principalName));
        KerberosTime timeStamp = new KerberosTime();
        DataOutputStream dos = null;
        try {
            dos = new DataOutputStream(new FileOutputStream(keytabFile));
            dos.write(Keytab.VERSION_0X502_BYTES);
            for (Map.Entry keyEntry : KerberosKeyFactory.getKerberosKeys((String)principalName, (String)passPhrase).entrySet()) {
                EncryptionKey key = (EncryptionKey)keyEntry.getValue();
                byte keyVersion = (byte)key.getKeyVersion();
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                DataOutputStream entryDos = new DataOutputStream(baos);
                String[] spnSplit = principalName.split("@");
                String nameComponent = spnSplit[0];
                String realm = spnSplit[1];
                String[] nameComponents = nameComponent.split("/");
                try {
                    entryDos.writeShort((short)nameComponents.length);
                    entryDos.writeUTF(realm);
                    for (String component : nameComponents) {
                        entryDos.writeUTF(component);
                    }
                    entryDos.writeInt(1);
                    entryDos.writeInt((int)(timeStamp.getTime() / 1000L));
                    entryDos.write(keyVersion);
                    entryDos.writeShort((short)key.getKeyType().getValue());
                    byte[] data = key.getKeyValue();
                    entryDos.writeShort((short)data.length);
                    entryDos.write(data);
                }
                finally {
                    IOUtils.closeQuietly((OutputStream)entryDos);
                }
                byte[] entryBytes = baos.toByteArray();
                dos.writeInt(entryBytes.length);
                dos.write(entryBytes);
            }
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(dos);
            throw throwable;
        }
        IOUtils.closeQuietly((OutputStream)dos);
    }

    protected abstract List<UserForKeyTab> kerberosUsers();

    public static class UserForKeyTab {
        private final String user;
        private final String password;
        private final File keyTabFileName;

        public UserForKeyTab(String user, String password, File keyTabFileName) {
            this.user = user;
            this.password = password;
            this.keyTabFileName = keyTabFileName;
        }

        public String getUser() {
            return this.user;
        }

        public String getPassword() {
            return this.password;
        }

        public File getKeyTabFileName() {
            return this.keyTabFileName;
        }
    }
}

