/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.test.integration.security.tasks;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.jboss.as.arquillian.api.ServerSetupTask;
import org.jboss.as.arquillian.container.ManagementClient;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.test.integration.security.common.CoreUtils;
import org.jboss.as.test.integration.security.common.config.AuthnModule;
import org.jboss.as.test.integration.security.common.config.JSSE;
import org.jboss.as.test.integration.security.common.config.JaspiAuthn;
import org.jboss.as.test.integration.security.common.config.SecureStore;
import org.jboss.as.test.integration.security.common.config.SecurityDomain;
import org.jboss.as.test.integration.security.common.config.SecurityModule;
import org.jboss.dmr.ModelNode;
import org.jboss.logging.Logger;

public abstract class AbstractSecurityDomainsServerSetupTask
implements ServerSetupTask {
    private static final Logger LOGGER = Logger.getLogger(AbstractSecurityDomainsServerSetupTask.class);
    private static final String ROLE = "role";
    private static final String SUBSYSTEM_SECURITY = "security";
    protected ManagementClient managementClient;
    private SecurityDomain[] securityDomains;

    public void setup(ManagementClient managementClient, String containerId) throws Exception {
        this.managementClient = managementClient;
        this.securityDomains = this.getSecurityDomains();
        if (this.securityDomains == null || this.securityDomains.length == 0) {
            LOGGER.warn((Object)"Empty security domain configuration.");
            return;
        }
        LinkedList<ModelNode> updates = new LinkedList<ModelNode>();
        for (SecurityDomain securityDomain : this.securityDomains) {
            List<ModelNode> jaspiAuthnNodes;
            String securityDomainName = securityDomain.getName();
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info((Object)("Adding security domain " + securityDomainName));
            }
            ModelNode compositeOp = new ModelNode();
            compositeOp.get("operation").set("composite");
            compositeOp.get("address").setEmptyList();
            ModelNode steps = compositeOp.get("steps");
            PathAddress opAddr = PathAddress.pathAddress((PathElement[])new PathElement[0]).append("subsystem", SUBSYSTEM_SECURITY).append("security-domain", securityDomainName);
            ModelNode op = Util.createAddOperation((PathAddress)opAddr);
            if (StringUtils.isNotEmpty((String)securityDomain.getCacheType())) {
                op.get("cache-type").set(securityDomain.getCacheType());
            }
            steps.add(op);
            boolean authNodeAdded = this.createSecurityModelNode("authentication", "login-module", "flag", "required", securityDomain.getLoginModules(), securityDomainName, steps);
            if (!authNodeAdded && (jaspiAuthnNodes = this.createJaspiAuthnNodes(securityDomain.getJaspiAuthn(), securityDomain.getName())) != null) {
                for (ModelNode node : jaspiAuthnNodes) {
                    steps.add(node);
                }
            }
            this.createSecurityModelNode("authorization", "policy-module", "flag", "required", securityDomain.getAuthorizationModules(), securityDomainName, steps);
            this.createSecurityModelNode("mapping", "mapping-module", "type", ROLE, securityDomain.getMappingModules(), securityDomainName, steps);
            ModelNode jsseNode = this.createJSSENode(securityDomain.getJsse(), securityDomain.getName());
            if (jsseNode != null) {
                steps.add(jsseNode);
            }
            updates.add(compositeOp);
        }
        CoreUtils.applyUpdates(updates, (ModelControllerClient)managementClient.getControllerClient());
    }

    public void tearDown(ManagementClient managementClient, String containerId) throws Exception {
        if (this.securityDomains == null || this.securityDomains.length == 0) {
            LOGGER.warn((Object)"Empty security domain configuration.");
            return;
        }
        ArrayList<ModelNode> updates = new ArrayList<ModelNode>();
        for (SecurityDomain securityDomain : this.securityDomains) {
            String domainName = securityDomain.getName();
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info((Object)("Removing security domain " + domainName));
            }
            ModelNode op = new ModelNode();
            op.get("operation").set("remove");
            op.get("address").add("subsystem", SUBSYSTEM_SECURITY);
            op.get("address").add("security-domain", domainName);
            op.get(new String[]{"operation-headers", "rollback-on-runtime-failure"}).set(false);
            op.get(new String[]{"operation-headers", "allow-resource-service-restart"}).set(true);
            updates.add(op);
        }
        CoreUtils.applyUpdates(updates, (ModelControllerClient)managementClient.getControllerClient());
        this.managementClient = null;
    }

    private List<ModelNode> createJaspiAuthnNodes(JaspiAuthn securityConfigurations, String domainName) {
        if (securityConfigurations == null) {
            LOGGER.info((Object)"No security configuration for JASPI module.");
            return null;
        }
        if (securityConfigurations.getAuthnModules() == null || securityConfigurations.getAuthnModules().length == 0 || securityConfigurations.getLoginModuleStacks() == null || securityConfigurations.getLoginModuleStacks().length == 0) {
            throw new IllegalArgumentException("Missing mandatory part of JASPI configuration in the security domain.");
        }
        ArrayList<ModelNode> steps = new ArrayList<ModelNode>();
        PathAddress domainAddress = PathAddress.pathAddress((PathElement[])new PathElement[0]).append("subsystem", SUBSYSTEM_SECURITY).append("security-domain", domainName);
        PathAddress jaspiAddress = domainAddress.append("authentication", "jaspi");
        steps.add(Util.createAddOperation((PathAddress)jaspiAddress));
        for (AuthnModule authnModule : securityConfigurations.getAuthnModules()) {
            Map configOptions;
            LOGGER.info((Object)("Adding auth-module: " + authnModule));
            ModelNode securityModuleNode = Util.createAddOperation((PathAddress)jaspiAddress.append("auth-module", authnModule.getName()));
            steps.add(securityModuleNode);
            securityModuleNode.get("code").set(authnModule.getName());
            if (authnModule.getFlag() != null) {
                securityModuleNode.get("flag").set(authnModule.getFlag());
            }
            if (authnModule.getModule() != null) {
                securityModuleNode.get("module").set(authnModule.getModule());
            }
            if (authnModule.getLoginModuleStackRef() != null) {
                securityModuleNode.get("login-module-stack-ref").set(authnModule.getLoginModuleStackRef());
            }
            if ((configOptions = authnModule.getOptions()) == null) {
                LOGGER.info((Object)"No module options provided.");
                configOptions = Collections.emptyMap();
            }
            ModelNode moduleOptionsNode = securityModuleNode.get("module-options");
            for (Map.Entry entry : configOptions.entrySet()) {
                String optionName = (String)entry.getKey();
                String optionValue = (String)entry.getValue();
                moduleOptionsNode.add(optionName, optionValue);
                if (!LOGGER.isDebugEnabled()) continue;
                LOGGER.debug((Object)("Adding module option [" + optionName + "=" + optionValue + "]"));
            }
        }
        for (AuthnModule authnModule : securityConfigurations.getLoginModuleStacks()) {
            PathAddress lmStackAddress = jaspiAddress.append("login-module-stack", authnModule.getName());
            steps.add(Util.createAddOperation((PathAddress)lmStackAddress));
            for (SecurityModule config : authnModule.getLoginModules()) {
                Map configOptions;
                String code = config.getName();
                ModelNode securityModuleNode = Util.createAddOperation((PathAddress)lmStackAddress.append("login-module", code));
                String flag = StringUtils.defaultIfEmpty((String)config.getFlag(), (String)"required");
                securityModuleNode.get("code").set(code);
                securityModuleNode.get("flag").set(flag);
                if (LOGGER.isInfoEnabled()) {
                    LOGGER.info((Object)("Adding JASPI login module stack [code=" + code + ", flag=" + flag + "]"));
                }
                if ((configOptions = config.getOptions()) == null) {
                    LOGGER.info((Object)"No module options provided.");
                    configOptions = Collections.emptyMap();
                }
                ModelNode moduleOptionsNode = securityModuleNode.get("module-options");
                for (Map.Entry entry : configOptions.entrySet()) {
                    String optionName = (String)entry.getKey();
                    String optionValue = (String)entry.getValue();
                    moduleOptionsNode.add(optionName, optionValue);
                    if (!LOGGER.isDebugEnabled()) continue;
                    LOGGER.debug((Object)("Adding module option [" + optionName + "=" + optionValue + "]"));
                }
                securityModuleNode.get("operation-headers").get("allow-resource-service-restart").set(true);
                steps.add(securityModuleNode);
            }
        }
        return steps;
    }

    private boolean createSecurityModelNode(String securityComponent, String subnodeName, String flagAttributeName, String flagDefaultValue, SecurityModule[] securityModules, String domainName, ModelNode operations) {
        if (securityModules == null || securityModules.length == 0) {
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info((Object)("No security configuration for " + securityComponent + " module."));
            }
            return false;
        }
        PathAddress address = PathAddress.pathAddress((PathElement[])new PathElement[0]).append("subsystem", SUBSYSTEM_SECURITY).append("security-domain", domainName).append(securityComponent, "classic");
        operations.add(Util.createAddOperation((PathAddress)address));
        for (SecurityModule config : securityModules) {
            String code = config.getName();
            ModelNode securityModuleNode = Util.createAddOperation((PathAddress)address.append(subnodeName, code));
            String flag = StringUtils.defaultIfEmpty((String)config.getFlag(), (String)flagDefaultValue);
            securityModuleNode.get("code").set(code);
            securityModuleNode.get(flagAttributeName).set(flag);
            Map configOptions = config.getOptions();
            if (configOptions == null) {
                LOGGER.info((Object)"No module options provided.");
                configOptions = Collections.emptyMap();
            }
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info((Object)("Adding " + securityComponent + " module [code=" + code + ", " + flagAttributeName + "=" + flag + ", options = " + configOptions + "]"));
            }
            ModelNode moduleOptionsNode = securityModuleNode.get("module-options");
            for (Map.Entry entry : configOptions.entrySet()) {
                String optionName = (String)entry.getKey();
                String optionValue = (String)entry.getValue();
                moduleOptionsNode.add(optionName, optionValue);
            }
            securityModuleNode.get("operation-headers").get("allow-resource-service-restart").set(true);
            operations.add(securityModuleNode);
        }
        return true;
    }

    private ModelNode createJSSENode(JSSE jsse, String domainName) {
        if (jsse == null) {
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info((Object)"No security configuration for JSSE module.");
            }
            return null;
        }
        ModelNode securityComponentNode = new ModelNode();
        securityComponentNode.get("operation").set("add");
        securityComponentNode.get("address").add("subsystem", SUBSYSTEM_SECURITY);
        securityComponentNode.get("address").add("security-domain", domainName);
        securityComponentNode.get("address").add("jsse", "classic");
        this.addSecureStore(jsse.getTrustStore(), "truststore", securityComponentNode);
        this.addSecureStore(jsse.getKeyStore(), "keystore", securityComponentNode);
        securityComponentNode.get("operation-headers").get("allow-resource-service-restart").set(true);
        return securityComponentNode;
    }

    private void addSecureStore(SecureStore secureStore, String storeName, ModelNode jsseNode) {
        if (secureStore == null) {
            return;
        }
        if (secureStore.getUrl() != null) {
            jsseNode.get(new String[]{storeName, "url"}).set(secureStore.getUrl().toExternalForm());
        }
        if (secureStore.getPassword() != null) {
            jsseNode.get(new String[]{storeName, "password"}).set(secureStore.getPassword());
        }
        if (secureStore.getType() != null) {
            jsseNode.get(new String[]{storeName, "type"}).set(secureStore.getType());
        }
    }

    protected abstract SecurityDomain[] getSecurityDomains() throws Exception;
}

