/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.test.integration.security.embedded;

import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import org.infinispan.Cache;
import org.infinispan.configuration.cache.AuthorizationConfigurationBuilder;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.global.GlobalAuthorizationConfigurationBuilder;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.configuration.global.GlobalRoleConfigurationBuilder;
import org.infinispan.manager.DefaultCacheManager;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.security.AuthorizationPermission;
import org.infinispan.security.PrincipalRoleMapper;
import org.infinispan.security.Security;
import org.infinispan.test.integration.security.utils.LoginHandler;
import org.infinispan.transaction.LockingMode;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public abstract class AbstractAuthentication {
    public static final String DEFAULT_DEPLOY_CONTAINER = "testnode";
    public static final String CACHE_NAME = "secureCache";
    public static final String TEST_ENTRY_VALUE = "predefined value";
    protected EmbeddedCacheManager manager;
    public static final String TEST_ENTRY_KEY = "predefined key";
    protected Cache<Object, Object> secureCache;
    private GlobalConfigurationBuilder globalConfig;
    private ConfigurationBuilder cacheConfig;

    public abstract String getSecurityDomainName();

    public abstract Map<String, AuthorizationPermission[]> getRolePermissionMap();

    public abstract PrincipalRoleMapper getPrincipalRoleMapper();

    public abstract Subject getAdminSubject() throws LoginException;

    public abstract Subject getWriterSubject() throws LoginException;

    public abstract Subject getReaderSubject() throws LoginException;

    public abstract Subject getUnprivilegedSubject() throws LoginException;

    public Subject authenticate(String login, String password) throws LoginException {
        String securityDomain = System.getProperty("jboss.security.domain", this.getSecurityDomainName());
        LoginContext lc = new LoginContext(securityDomain, new LoginHandler(login, password));
        lc.login();
        return lc.getSubject();
    }

    public Subject authenticateWithKrb(String krbSecurityDomain) throws LoginException {
        LoginContext lc = new LoginContext(krbSecurityDomain, new LoginHandler(null, null));
        lc.login();
        return lc.getSubject();
    }

    @Before
    public void setupCache() throws Exception {
        this.globalConfig = new GlobalConfigurationBuilder();
        this.globalConfig.globalJmxStatistics().disable();
        this.globalConfig.globalJmxStatistics().mBeanServerLookup(null);
        GlobalAuthorizationConfigurationBuilder globalRoles = this.globalConfig.security().authorization().enable().principalRoleMapper(this.getPrincipalRoleMapper());
        this.cacheConfig = new ConfigurationBuilder();
        this.cacheConfig.transaction().lockingMode(LockingMode.PESSIMISTIC);
        this.cacheConfig.invocationBatching().enable();
        this.cacheConfig.jmxStatistics().disable();
        AuthorizationConfigurationBuilder authConfig = this.cacheConfig.security().authorization().enable();
        Map<String, AuthorizationPermission[]> rolePermissionMap = this.getRolePermissionMap();
        for (Map.Entry<String, AuthorizationPermission[]> role : rolePermissionMap.entrySet()) {
            authConfig = authConfig.role(role.getKey());
            GlobalRoleConfigurationBuilder roleBuilder = globalRoles.role(role.getKey());
            for (AuthorizationPermission permission : role.getValue()) {
                roleBuilder = roleBuilder.permission(permission);
            }
        }
        Subject admin = this.getAdminSubject();
        Security.doAs((Subject)admin, (PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

            @Override
            public Void run() throws Exception {
                AbstractAuthentication.this.manager = new DefaultCacheManager(AbstractAuthentication.this.globalConfig.build());
                AbstractAuthentication.this.manager.defineConfiguration(AbstractAuthentication.CACHE_NAME, AbstractAuthentication.this.cacheConfig.build());
                AbstractAuthentication.this.secureCache = AbstractAuthentication.this.manager.getCache(AbstractAuthentication.CACHE_NAME);
                AbstractAuthentication.this.secureCache.put((Object)AbstractAuthentication.TEST_ENTRY_KEY, (Object)AbstractAuthentication.TEST_ENTRY_VALUE);
                return null;
            }
        });
    }

    @After
    public void tearDown() throws Exception {
        if (this.manager != null) {
            Subject admin = this.getAdminSubject();
            Security.doAs((Subject)admin, (PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws Exception {
                    AbstractAuthentication.this.manager.stop();
                    return null;
                }
            });
        }
    }

    @Test
    public void testAdminCRUD() throws Exception {
        Subject admin = this.getAdminSubject();
        Security.doAs((Subject)admin, (PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

            @Override
            public Void run() throws Exception {
                Assert.assertEquals((Object)AbstractAuthentication.TEST_ENTRY_VALUE, (Object)AbstractAuthentication.this.secureCache.get((Object)AbstractAuthentication.TEST_ENTRY_KEY));
                AbstractAuthentication.this.secureCache.putIfAbsent((Object)"test", (Object)"test value");
                Assert.assertEquals((Object)"test value", (Object)AbstractAuthentication.this.secureCache.get((Object)"test"));
                AbstractAuthentication.this.secureCache.put((Object)"test", (Object)"test value2");
                Assert.assertEquals((Object)"test value2", (Object)AbstractAuthentication.this.secureCache.get((Object)"test"));
                AbstractAuthentication.this.secureCache.remove((Object)"test");
                Assert.assertEquals(null, (Object)AbstractAuthentication.this.secureCache.get((Object)"test"));
                AbstractAuthentication.this.secureCache.clear();
                Assert.assertEquals((long)0L, (long)AbstractAuthentication.this.secureCache.size());
                return null;
            }
        });
    }

    @Test
    public void testWriterWrite() throws Exception {
        Subject writer = this.getWriterSubject();
        Security.doAs((Subject)writer, (PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

            @Override
            public Void run() throws Exception {
                AbstractAuthentication.this.secureCache.put((Object)"test", (Object)"test value");
                return null;
            }
        });
    }

    @Test
    public void testWriterRemove() throws Exception {
        Subject writer = this.getWriterSubject();
        Security.doAs((Subject)writer, (PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

            @Override
            public Void run() throws Exception {
                AbstractAuthentication.this.secureCache.remove((Object)AbstractAuthentication.TEST_ENTRY_KEY);
                return null;
            }
        });
    }

    @Test(expected=PrivilegedActionException.class)
    public void testWriterRead() throws Exception {
        Subject writer = this.getWriterSubject();
        Security.doAs((Subject)writer, (PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

            @Override
            public Void run() throws Exception {
                AbstractAuthentication.this.secureCache.get((Object)AbstractAuthentication.TEST_ENTRY_KEY);
                return null;
            }
        });
    }

    @Test
    public void testReaderRead() throws Exception {
        Subject reader = this.getReaderSubject();
        Security.doAs((Subject)reader, (PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

            @Override
            public Void run() throws Exception {
                Assert.assertEquals((Object)AbstractAuthentication.TEST_ENTRY_VALUE, (Object)AbstractAuthentication.this.secureCache.get((Object)AbstractAuthentication.TEST_ENTRY_KEY));
                return null;
            }
        });
    }

    @Test(expected=PrivilegedActionException.class)
    public void testReaderWrite() throws Exception {
        Subject reader = this.getReaderSubject();
        Security.doAs((Subject)reader, (PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

            @Override
            public Void run() throws Exception {
                AbstractAuthentication.this.secureCache.put((Object)"test", (Object)"test value");
                return null;
            }
        });
    }

    @Test(expected=PrivilegedActionException.class)
    public void testReaderRemove() throws Exception {
        Subject reader = this.getReaderSubject();
        Security.doAs((Subject)reader, (PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

            @Override
            public Void run() throws Exception {
                AbstractAuthentication.this.secureCache.remove((Object)AbstractAuthentication.TEST_ENTRY_KEY);
                return null;
            }
        });
    }

    @Test(expected=PrivilegedActionException.class)
    public void testUnprivilegedRead() throws Exception {
        Subject unprivileged = this.getUnprivilegedSubject();
        Security.doAs((Subject)unprivileged, (PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

            @Override
            public Void run() throws Exception {
                AbstractAuthentication.this.secureCache.get((Object)AbstractAuthentication.TEST_ENTRY_KEY);
                return null;
            }
        });
    }

    @Test(expected=PrivilegedActionException.class)
    public void testUnprivilegedWrite() throws Exception {
        Subject unprivileged = this.getUnprivilegedSubject();
        Security.doAs((Subject)unprivileged, (PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

            @Override
            public Void run() throws Exception {
                AbstractAuthentication.this.secureCache.put((Object)"test", (Object)"test value");
                return null;
            }
        });
    }

    @Test(expected=PrivilegedActionException.class)
    public void testUnprivilegedRemove() throws Exception {
        Subject unprivileged = this.getUnprivilegedSubject();
        Security.doAs((Subject)unprivileged, (PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

            @Override
            public Void run() throws Exception {
                AbstractAuthentication.this.secureCache.remove((Object)AbstractAuthentication.TEST_ENTRY_KEY);
                return null;
            }
        });
    }

    @Test(expected=SecurityException.class)
    public void testUnauthenticatedRead() throws Exception {
        this.secureCache.get((Object)TEST_ENTRY_KEY);
    }

    @Test(expected=SecurityException.class)
    public void testUnauthenticatedWrite() throws Exception {
        this.secureCache.put((Object)"test", (Object)"value");
    }

    @Test(expected=SecurityException.class)
    public void testUnauthenticatedRemove() throws Exception {
        this.secureCache.remove((Object)TEST_ENTRY_KEY);
    }
}

