/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.test.integration.security.embedded;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.login.LoginException;
import org.infinispan.security.AuthorizationPermission;
import org.infinispan.security.PrincipalRoleMapper;
import org.infinispan.test.integration.security.embedded.AbstractAuthentication;
import org.infinispan.test.integration.security.tasks.AbstractKrb5ConfServerSetupTask;
import org.infinispan.test.integration.security.tasks.AbstractSecurityDomainsServerSetupTask;
import org.infinispan.test.integration.security.tasks.AbstractSystemPropertiesServerSetupTask;
import org.infinispan.test.integration.security.tasks.AbstractTraceLoggingServerSetupTask;
import org.infinispan.test.integration.security.utils.ApacheDsKrbLdap;
import org.infinispan.test.integration.security.utils.Deployments;
import org.infinispan.test.integration.security.utils.SimplePrincipalGroupRoleMapper;
import org.infinispan.test.integration.security.utils.Utils;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.container.test.api.TargetsContainer;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.as.arquillian.api.ServerSetup;
import org.jboss.as.arquillian.api.ServerSetupTask;
import org.jboss.as.arquillian.container.ManagementClient;
import org.jboss.as.test.integration.security.common.config.SecurityDomain;
import org.jboss.as.test.integration.security.common.config.SecurityModule;
import org.jboss.security.negotiation.AdvancedLdapLoginModule;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.runner.RunWith;

@RunWith(value=Arquillian.class)
@ServerSetup(value={KerberosSystemPropertiesSetupTask.class, SecurityDomainsSetupTask.class, SecurityTraceLoggingServerSetupTask.class, KrbLdapServerSetupTask.class, Krb5ConfServerSetupTask.class})
public class KrbLdapAuthenticationIT
extends AbstractAuthentication {
    private static final String TRUE = Boolean.TRUE.toString();
    public static final String ADMIN_ROLE = "AdminIspnRole";
    public static final String WRITER_ROLE = "WriterIspnRole";
    public static final String READER_ROLE = "ReaderIspnRole";
    public static final String UNPRIVILEGED_ROLE = "UnprivilegedIspnRole";

    @Deployment
    @TargetsContainer(value="testnode")
    public static WebArchive getDeployment() {
        return Deployments.createKrbLdapTestDeployment();
    }

    @Override
    public Map<String, AuthorizationPermission[]> getRolePermissionMap() {
        HashMap<String, AuthorizationPermission[]> roles = new HashMap<String, AuthorizationPermission[]>();
        roles.put(ADMIN_ROLE, new AuthorizationPermission[]{AuthorizationPermission.ALL});
        roles.put(WRITER_ROLE, new AuthorizationPermission[]{AuthorizationPermission.WRITE});
        roles.put(READER_ROLE, new AuthorizationPermission[]{AuthorizationPermission.READ});
        roles.put(UNPRIVILEGED_ROLE, new AuthorizationPermission[]{AuthorizationPermission.NONE});
        return roles;
    }

    @Override
    public PrincipalRoleMapper getPrincipalRoleMapper() {
        return new SimplePrincipalGroupRoleMapper();
    }

    @Override
    public String getSecurityDomainName() {
        return null;
    }

    @Override
    public Subject getAdminSubject() throws LoginException {
        return this.authenticateWithKrb("ispn-admin");
    }

    @Override
    public Subject getWriterSubject() throws LoginException {
        return this.authenticateWithKrb("ispn-writer");
    }

    @Override
    public Subject getReaderSubject() throws LoginException {
        return this.authenticateWithKrb("ispn-reader");
    }

    @Override
    public Subject getUnprivilegedSubject() throws LoginException {
        return this.authenticateWithKrb("ispn-unprivileged");
    }

    static class Krb5ConfServerSetupTask
    extends AbstractKrb5ConfServerSetupTask {
        public static final File ADMIN_KEYTAB_FILE = new File(KEYTABS_DIR, "admin.keytab");
        public static final File WRITER_KEYTAB_FILE = new File(KEYTABS_DIR, "writer.keytab");
        public static final File READER_KEYTAB_FILE = new File(KEYTABS_DIR, "reader.keytab");
        public static final File UNPRIV_KEYTAB_FILE = new File(KEYTABS_DIR, "unprivileged.keytab");

        Krb5ConfServerSetupTask() {
        }

        @Override
        protected List<AbstractKrb5ConfServerSetupTask.UserForKeyTab> kerberosUsers() {
            ArrayList<AbstractKrb5ConfServerSetupTask.UserForKeyTab> users = new ArrayList<AbstractKrb5ConfServerSetupTask.UserForKeyTab>();
            users.add(new AbstractKrb5ConfServerSetupTask.UserForKeyTab("admin@INFINISPAN.ORG", "strongPassword", ADMIN_KEYTAB_FILE));
            users.add(new AbstractKrb5ConfServerSetupTask.UserForKeyTab("writer@INFINISPAN.ORG", "somePassword", WRITER_KEYTAB_FILE));
            users.add(new AbstractKrb5ConfServerSetupTask.UserForKeyTab("reader@INFINISPAN.ORG", "password", READER_KEYTAB_FILE));
            users.add(new AbstractKrb5ConfServerSetupTask.UserForKeyTab("unprivileged@INFINISPAN.ORG", "weakPassword", UNPRIV_KEYTAB_FILE));
            return users;
        }
    }

    static class KrbLdapServerSetupTask
    implements ServerSetupTask {
        private static ApacheDsKrbLdap krbLdapServer;

        KrbLdapServerSetupTask() {
        }

        public void setup(ManagementClient managementClient, String s) throws Exception {
            String hostname = Utils.getCannonicalHost(managementClient);
            System.setProperty("java.security.krb5.conf", Utils.getResource("krb5.conf").getPath());
            krbLdapServer = new ApacheDsKrbLdap(hostname);
            krbLdapServer.start();
        }

        public void tearDown(ManagementClient managementClient, String s) throws Exception {
            krbLdapServer.stop();
        }
    }

    static class SecurityTraceLoggingServerSetupTask
    extends AbstractTraceLoggingServerSetupTask {
        SecurityTraceLoggingServerSetupTask() {
        }

        @Override
        protected Collection<String> getCategories(ManagementClient managementClient, String containerId) {
            return Arrays.asList("javax.security", "org.jboss.security", "org.picketbox", "org.wildfly.security");
        }
    }

    static class KerberosSystemPropertiesSetupTask
    extends AbstractSystemPropertiesServerSetupTask {
        KerberosSystemPropertiesSetupTask() {
        }

        @Override
        protected AbstractSystemPropertiesServerSetupTask.SystemProperty[] getSystemProperties() {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("java.security.krb5.conf", "${java.io.tmpdir}" + File.separator + "krb5.conf");
            map.put("java.security.krb5.debug", TRUE);
            map.put("jboss.security.disable.secdomain.option", TRUE);
            return KerberosSystemPropertiesSetupTask.mapToSystemProperties(map);
        }
    }

    static class SecurityDomainsSetupTask
    extends AbstractSecurityDomainsServerSetupTask {
        SecurityDomainsSetupTask() {
        }

        @Override
        protected SecurityDomain[] getSecurityDomains() {
            String host = Utils.getCannonicalHost(this.managementClient);
            SecurityDomain krbLdapServiceDomain = this.getKrbSecurityDomain("ldap-service", "ldap/" + host, true);
            SecurityDomain krbAdminDomain = this.getKrbSecurityDomain("admin", "admin", false);
            SecurityDomain krbWriterDomain = this.getKrbSecurityDomain("writer", "writer", false);
            SecurityDomain krbReaderDomain = this.getKrbSecurityDomain("reader", "reader", false);
            SecurityDomain krbUnprivDomain = this.getKrbSecurityDomain("unprivileged", "unprivileged", false);
            SecurityDomain spnegoAdminDomain = SecurityDomainsSetupTask.getSpnegoSecurityDomain("admin", this.managementClient, 10389, "ldap-service");
            SecurityDomain spnegoWriterDomain = SecurityDomainsSetupTask.getSpnegoSecurityDomain("writer", this.managementClient, 10389, "ldap-service");
            SecurityDomain spnegoReaderDomain = SecurityDomainsSetupTask.getSpnegoSecurityDomain("reader", this.managementClient, 10389, "ldap-service");
            SecurityDomain spnegoUnprivDomain = SecurityDomainsSetupTask.getSpnegoSecurityDomain("unprivileged", this.managementClient, 10389, "ldap-service");
            return new SecurityDomain[]{krbLdapServiceDomain, krbAdminDomain, krbWriterDomain, krbReaderDomain, krbUnprivDomain, spnegoAdminDomain, spnegoWriterDomain, spnegoReaderDomain, spnegoUnprivDomain};
        }

        private SecurityDomain getKrbSecurityDomain(String name, String principal, boolean isService) {
            SecurityModule.Builder krbModuleBuilder = new SecurityModule.Builder();
            if (Utils.IBM_JDK) {
                krbModuleBuilder.name("com.ibm.security.auth.module.Krb5LoginModule").putOption("useKeytab", "${java.io.tmpdir}" + File.separator + "keytabs" + File.separator + name + ".keytab");
                if (isService) {
                    krbModuleBuilder.putOption("credsType", "both").putOption("forwardable", TRUE).putOption("proxiable", TRUE).putOption("noAddress", TRUE);
                } else {
                    krbModuleBuilder.putOption("credsType", "acceptor");
                }
            } else {
                krbModuleBuilder.name("Kerberos").putOption("useKeyTab", TRUE).putOption("keyTab", "${java.io.tmpdir}" + File.separator + "keytabs" + File.separator + name + ".keytab");
                if (isService) {
                    krbModuleBuilder.putOption("storeKey", TRUE).putOption("refreshKrb5Config", TRUE).putOption("doNotPrompt", TRUE);
                }
            }
            krbModuleBuilder.putOption("principal", principal + "@INFINISPAN.ORG").putOption("debug", TRUE);
            return new SecurityDomain.Builder().name("krb-" + name).cacheType("default").loginModules(new SecurityModule[]{krbModuleBuilder.build()}).build();
        }

        private static SecurityDomain getSpnegoSecurityDomain(String user, ManagementClient managementClient, int ldapPort, String ldapServiceName) {
            String host = Utils.getCannonicalHost(managementClient);
            return new SecurityDomain.Builder().name("ispn-" + user).cacheType("default").loginModules(new SecurityModule[]{new SecurityModule.Builder().name("SPNEGO").flag("requisite").putOption("password-stacking", "useFirstPass").putOption("serverSecurityDomain", "krb-" + ldapServiceName).putOption("usernamePasswordDomain", "krb-" + user).build(), new SecurityModule.Builder().name(AdvancedLdapLoginModule.class.getName()).putOption("password-stacking", "useFirstPass").putOption("bindAuthentication", "GSSAPI").putOption("jaasSecurityDomain", "krb-" + ldapServiceName).putOption("java.naming.provider.url", "ldap://" + host + ":" + ldapPort).putOption("baseCtxDN", "ou=People,dc=infinispan,dc=org").putOption("baseFilter", "(krb5PrincipalName={0})").putOption("rolesCtxDN", "ou=Roles,dc=infinispan,dc=org").putOption("roleFilter", "(member={1})").putOption("roleAttributeID", "cn").build()}).build();
        }
    }
}

