/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.test.integration.security.tasks;

import java.util.ArrayList;
import java.util.Collection;
import org.jboss.as.arquillian.api.ServerSetupTask;
import org.jboss.as.arquillian.container.ManagementClient;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.test.integration.security.common.CoreUtils;
import org.jboss.dmr.ModelNode;
import org.jboss.logging.Logger;

public abstract class AbstractTraceLoggingServerSetupTask
implements ServerSetupTask {
    private static final Logger LOGGER = Logger.getLogger(AbstractTraceLoggingServerSetupTask.class);
    private static final PathAddress PATH_LOGGING = PathAddress.pathAddress((String)"subsystem", (String)"logging");
    protected Collection<String> categories;

    public void setup(ManagementClient managementClient, String containerId) throws Exception {
        this.categories = this.getCategories(managementClient, containerId);
        if (this.categories == null || this.categories.isEmpty()) {
            LOGGER.warn((Object)"getCategories() returned empty collection.");
            return;
        }
        ArrayList<ModelNode> updates = new ArrayList<ModelNode>();
        for (String category : this.categories) {
            if (category == null || category.length() == 0) {
                LOGGER.warn((Object)"Empty category name provided.");
                continue;
            }
            ModelNode op = Util.createAddOperation((PathAddress)PATH_LOGGING.append("logger", category));
            op.get("level").set("TRACE");
            updates.add(op);
        }
        ModelNode op = Util.createEmptyOperation((String)"write-attribute", (PathAddress)PATH_LOGGING.append("console-handler", "CONSOLE"));
        op.get("name").set("level");
        CoreUtils.applyUpdates(updates, (ModelControllerClient)managementClient.getControllerClient());
    }

    public void tearDown(ManagementClient managementClient, String containerId) throws Exception {
        if (this.categories == null || this.categories.isEmpty()) {
            return;
        }
        ArrayList<ModelNode> updates = new ArrayList<ModelNode>();
        for (String category : this.categories) {
            if (category == null || category.length() == 0) continue;
            updates.add(Util.createRemoveOperation((PathAddress)PATH_LOGGING.append("logger", category)));
        }
        ModelNode op = Util.createEmptyOperation((String)"write-attribute", (PathAddress)PATH_LOGGING.append("console-handler", "CONSOLE"));
        op.get("name").set("level");
        op.get("value").set("INFO");
        CoreUtils.applyUpdates(updates, (ModelControllerClient)managementClient.getControllerClient());
    }

    protected abstract Collection<String> getCategories(ManagementClient var1, String var2);
}

