/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.test.integration.store;

import java.io.File;
import org.infinispan.Cache;
import org.infinispan.commons.util.Util;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.manager.DefaultCacheManager;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.persistence.rocksdb.configuration.RocksDBStoreConfigurationBuilder;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public abstract class AbstractInfinispanStoreRocksDBIT {
    private static String baseDir = AbstractInfinispanStoreRocksDBIT.tmpDirectory(AbstractInfinispanStoreRocksDBIT.class);
    private static String dataDir = baseDir + File.separator + "data";
    private static String expiredDir = baseDir + File.separator + "expired";
    private EmbeddedCacheManager cm;

    @Before
    @After
    public void removeDataFilesIfExists() {
        Util.recursiveFileRemove((String)baseDir);
        if (this.cm != null) {
            this.cm.stop();
        }
    }

    private static String tmpDirectory(Class<?> test) {
        String prefix = System.getProperty("infinispan.test.tmpdir", System.getProperty("java.io.tmpdir"));
        return prefix + File.separator + "infinispanTempFiles" + File.separator + test.getSimpleName();
    }

    @Test
    public void testCacheManager() {
        GlobalConfigurationBuilder gcb = new GlobalConfigurationBuilder();
        gcb.globalState().persistentLocation(baseDir).defaultCacheName("default");
        ConfigurationBuilder builder = new ConfigurationBuilder();
        ((RocksDBStoreConfigurationBuilder)builder.persistence().addStore(RocksDBStoreConfigurationBuilder.class)).location(dataDir).expiredLocation(expiredDir);
        this.cm = new DefaultCacheManager(gcb.build(), builder.build());
        Cache cache = this.cm.getCache();
        cache.put((Object)"a", (Object)"a");
        Assert.assertEquals((Object)"a", (Object)cache.get((Object)"a"));
    }
}

