/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.test.integration.util;

import org.junit.Assert;

public class ITestUtils {
    public static void sleepForSecs(long numSecs) {
        try {
            Thread.sleep(numSecs * 1000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public static void eventually(Condition ec, long timeout, int loops) {
        if (loops <= 0) {
            throw new IllegalArgumentException("Number of loops must be positive");
        }
        long sleepDuration = timeout / (long)loops;
        if (sleepDuration == 0L) {
            sleepDuration = 1L;
        }
        try {
            for (int i = 0; i < loops; ++i) {
                if (ec.isSatisfied()) {
                    return;
                }
                Thread.sleep(sleepDuration);
            }
            Assert.assertTrue((boolean)ec.isSatisfied());
        }
        catch (Exception e) {
            throw new RuntimeException("Unexpected!", e);
        }
    }

    public static interface Condition {
        public boolean isSatisfied() throws Exception;
    }
}

