/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.test.integration.store;

import java.io.File;
import org.infinispan.Cache;
import org.infinispan.commons.test.CommonsTestingUtil;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.manager.DefaultCacheManager;
import org.infinispan.persistence.rocksdb.configuration.RocksDBStoreConfigurationBuilder;
import org.jboss.arquillian.container.test.api.Deployer;
import org.jboss.arquillian.container.test.api.OperateOnDeployment;
import org.jboss.arquillian.junit.InSequence;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.junit.Assert;
import org.junit.Test;

public abstract class AbstractInfinispanStoreRocksDBIT {
    @ArquillianResource
    private Deployer deployer;

    @Test
    @InSequence(value=1)
    public void deployDep1() {
        this.deployer.deploy("dep1");
    }

    @Test
    @OperateOnDeployment(value="dep1")
    @InSequence(value=2)
    public void testRunningInDep1() {
        DefaultCacheManager cm = this.getOrCreateCacheManager(1);
        Cache cache = cm.getCache();
        cache.put((Object)"dep1", (Object)"dep1");
    }

    @Test
    @InSequence(value=3)
    public void deployDep2() {
        this.deployer.deploy("dep2");
    }

    @Test
    @OperateOnDeployment(value="dep2")
    @InSequence(value=4)
    public void testRunningInDep2() {
        DefaultCacheManager cm = this.getOrCreateCacheManager(2);
        Cache cache = cm.getCache();
        Assert.assertEquals((Object)"dep1", (Object)cache.get((Object)"dep1"));
    }

    @Test
    @InSequence(value=5)
    public void undeploy() {
        this.deployer.undeploy("dep1");
        this.deployer.undeploy("dep2");
    }

    protected DefaultCacheManager getOrCreateCacheManager(int index) {
        String baseDir = CommonsTestingUtil.tmpDirectory((String[])new String[]{this.getClass().getSimpleName(), "server-" + index});
        String dataDir = baseDir + File.separator + "data";
        String expiredDir = baseDir + File.separator + "expired";
        GlobalConfigurationBuilder global = new GlobalConfigurationBuilder();
        global.transport().defaultTransport().clusterName(AbstractInfinispanStoreRocksDBIT.class.getSimpleName());
        global.globalState().persistentLocation(baseDir);
        global.defaultCacheName("default");
        ConfigurationBuilder builder = new ConfigurationBuilder();
        builder.clustering().cacheMode(CacheMode.REPL_SYNC);
        ((RocksDBStoreConfigurationBuilder)builder.persistence().addStore(RocksDBStoreConfigurationBuilder.class)).location(dataDir).expiredLocation(expiredDir);
        DefaultCacheManager cacheManager = new DefaultCacheManager(global.build(), builder.build());
        return cacheManager;
    }
}

