/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.test.integration.memcached;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.infinispan.commons.logging.Log;
import org.infinispan.commons.logging.LogFactory;
import org.junit.Assert;

public class SimpleMemcachedClient {
    private static final Log log = LogFactory.getLog(SimpleMemcachedClient.class);
    public static final int DEFAULT_MEMCACHED_PORT = 11211;
    public static final int DEFAULT_TIMEOUT = 10000;
    private String encoding;
    private Socket socket;
    private PrintWriter out;
    private StringAndBytesReader in;

    public SimpleMemcachedClient() throws IOException {
        this("UTF-8", "localhost", 11211, 10000);
    }

    public SimpleMemcachedClient(String enc, String host, int port, int timeout) throws IOException {
        this.encoding = enc;
        this.socket = new Socket(host, port);
        this.socket.setSoTimeout(timeout);
        this.out = new PrintWriter(new OutputStreamWriter(this.socket.getOutputStream(), this.encoding));
        this.in = new StringAndBytesReader(this.socket.getInputStream(), this.encoding);
    }

    public SimpleMemcachedClient(String host, int port) throws IOException {
        this("UTF-8", host, port, 10000);
    }

    public void writeln(String str) {
        this.out.print(str + "\r\n");
        if (log.isTraceEnabled()) {
            log.trace((Object)(">> \"" + str + "\""));
        }
    }

    public void write(byte[] data) throws IOException {
        if (log.isTraceEnabled()) {
            log.trace((Object)(">> " + data.length + " bytes"));
        }
        this.socket.getOutputStream().write(data);
    }

    public String readln() throws IOException {
        return this.in.readln();
    }

    public void flush() {
        this.out.flush();
    }

    public void close() {
        try {
            this.socket.close();
        }
        catch (IOException e) {
            throw new IllegalStateException("Cannot close memcached socket", e);
        }
    }

    public String get(String key) throws IOException {
        byte[] data = this.getBytes(key);
        if (data == null) {
            return null;
        }
        return new String(data, this.encoding);
    }

    public byte[] getBytes(String key) throws IOException {
        this.writeln("get " + key);
        this.flush();
        String valueStr = this.readln();
        if ("END".equals(valueStr)) {
            return null;
        }
        if (valueStr.startsWith("VALUE")) {
            String[] value = valueStr.split(" ");
            Assert.assertEquals((Object)key, (Object)value[1]);
            int size = new Integer(value[3]);
            byte[] ret = this.in.read(size);
            Assert.assertEquals((long)13L, (long)this.in.read());
            Assert.assertEquals((long)10L, (long)this.in.read());
            Assert.assertEquals((Object)"END", (Object)this.readln());
            return ret;
        }
        return null;
    }

    public void set(String key, String value) throws IOException {
        this.writeln("set " + key + " 0 0 " + value.getBytes(this.encoding).length);
        this.writeln(value);
        this.flush();
        Assert.assertEquals((Object)"STORED", (Object)this.readln());
    }

    public void set(String key, String value, int lifespan, int maxidle) throws IOException {
        this.writeln("set " + key + " " + lifespan + " " + maxidle + " " + value.getBytes(this.encoding).length);
        this.writeln(value);
        this.flush();
        Assert.assertEquals((Object)"STORED", (Object)this.readln());
    }

    public void setNoReadln(String key, String value) throws IOException {
        this.writeln("set " + key + " 0 0 " + value.getBytes(this.encoding).length);
        this.writeln(value);
        this.flush();
    }

    public String delete(String key) throws IOException {
        this.writeln("delete " + key);
        this.flush();
        return this.readln();
    }

    public Map<String, String> getStats() throws IOException {
        this.writeln("stats");
        this.flush();
        String statline = this.readln();
        HashMap<String, String> stats = new HashMap<String, String>();
        while (statline.startsWith("STAT")) {
            String[] stat = statline.split(" ");
            stats.put(stat[1], stat[2]);
            statline = this.readln();
        }
        Assert.assertEquals((Object)"END", (Object)statline);
        return stats;
    }

    public long getServerTime() throws IOException {
        this.writeln("stats");
        this.flush();
        String statline = this.readln();
        long time = -1L;
        while (statline.startsWith("STAT")) {
            String[] stat = statline.split(" ");
            if (stat[1].equals("time")) {
                time = new Long(stat[2]);
            }
            statline = this.readln();
        }
        Assert.assertEquals((Object)"END", (Object)statline);
        return time;
    }

    public String getCasId(String aKey) throws IOException {
        this.writeln("gets " + aKey);
        this.flush();
        String[] valueline = this.readln().split(" ");
        Assert.assertEquals((Object)"VALUE", (Object)valueline[0]);
        Assert.assertEquals((Object)aKey, (Object)valueline[1]);
        this.in.read(new Integer(valueline[3]));
        Assert.assertEquals((Object)"", (Object)this.readln());
        Assert.assertEquals((Object)"END", (Object)this.readln());
        return valueline[4];
    }

    public static class StringAndBytesReader {
        private InputStream input;
        private String encoding;
        private byte[] TEMP = new byte[1];

        public StringAndBytesReader(InputStream input, String encoding) {
            this.input = input;
            this.encoding = encoding;
        }

        public byte[] read(int len) throws IOException {
            try {
                byte[] ret = new byte[len];
                this.input.read(ret, 0, len);
                return ret;
            }
            catch (SocketTimeoutException ste) {
                Assert.fail((String)"Read timeout");
                return null;
            }
        }

        public byte read() throws IOException {
            try {
                this.input.read(this.TEMP, 0, 1);
                return this.TEMP[0];
            }
            catch (SocketTimeoutException ste) {
                Assert.fail((String)"Read timeout");
                return -1;
            }
        }

        public String readln() throws IOException {
            byte[] buf = new byte[512];
            int maxlen = 512;
            int read = 0;
            buf[read] = this.read();
            while (buf[read] != 10) {
                if (++read == maxlen) {
                    buf = Arrays.copyOf(buf, maxlen += 512);
                }
                buf[read] = this.read();
            }
            if (read == 0) {
                return "";
            }
            if (buf[read - 1] == 13) {
                --read;
            }
            buf = Arrays.copyOf(buf, read);
            String ret = new String(buf, this.encoding);
            if (log.isTraceEnabled()) {
                log.trace((Object)("<< \"" + ret + "\""));
            }
            return ret;
        }
    }
}

