/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.test.integration.cdi;

import javax.inject.Inject;
import org.infinispan.eviction.EvictionType;
import org.infinispan.test.integration.cdi.GreetingCacheManager;
import org.infinispan.test.integration.cdi.GreetingService;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public abstract class AbstractGreetingCacheManagerIT {
    @Inject
    private GreetingService greetingService;
    @Inject
    private GreetingCacheManager greetingCacheManager;

    @Before
    public void init() {
        this.greetingCacheManager.clearCache();
        Assert.assertEquals((long)0L, (long)this.greetingCacheManager.getNumberOfEntries());
    }

    @Test
    public void testGreetingCacheConfiguration() {
        Assert.assertEquals((Object)"greeting-cache", (Object)this.greetingCacheManager.getCacheName());
        Assert.assertEquals((long)128L, (long)this.greetingCacheManager.getMemorySize());
        Assert.assertEquals((Object)EvictionType.COUNT, (Object)this.greetingCacheManager.getEvictionType());
        Assert.assertEquals((long)-1L, (long)this.greetingCacheManager.getExpirationLifespan());
    }

    @Test
    public void testGreetingCacheCachedValues() {
        this.greetingService.greet("Pete");
        Assert.assertEquals((long)1L, (long)this.greetingCacheManager.getCachedValues().length);
        Assert.assertEquals((Object)"Hello Pete :)", (Object)this.greetingCacheManager.getCachedValues()[0]);
    }

    @Test
    public void testClearGreetingCache() {
        this.greetingService.greet("Pete");
        Assert.assertEquals((long)1L, (long)this.greetingCacheManager.getNumberOfEntries());
        this.greetingCacheManager.clearCache();
        Assert.assertEquals((long)0L, (long)this.greetingCacheManager.getNumberOfEntries());
    }
}

