/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.test.integration.persistence.jdbc.stringbased;

import org.infinispan.Cache;
import org.infinispan.context.Flag;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.test.integration.persistence.jdbc.util.JdbcConfigurationUtil;
import org.infinispan.test.integration.persistence.jdbc.util.TableManipulation;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;

public class PooledConnectionIT {
    private EmbeddedCacheManager cm;

    @After
    public void cleanUp() {
        if (this.cm != null) {
            this.cm.stop();
        }
    }

    @Test
    public void testPutGetRemove() throws Exception {
        JdbcConfigurationUtil jdbcUtil = new JdbcConfigurationUtil(true, true);
        this.cm = jdbcUtil.getCacheManager();
        Cache cache = this.cm.getCache("jdbc");
        try (TableManipulation table = new TableManipulation(cache.getName(), jdbcUtil.getPersistenceConfiguration(), jdbcUtil.getConfigurationBuilder());){
            cache.put((Object)"k1", (Object)"v1");
            cache.put((Object)"k2", (Object)"v2");
            Assert.assertNull((Object)table.getValueByKey("k1"));
            Assert.assertNull((Object)table.getValueByKey("k2"));
            cache.put((Object)"k3", (Object)"v3");
            Assert.assertEquals((long)2L, (long)this.getNumberOfEntriesInMemory(cache));
            Assert.assertEquals((long)1L, (long)table.countAllRows());
            cache.stop();
            cache.start();
            Assert.assertEquals((long)3L, (long)cache.size());
            Assert.assertEquals((Object)"v1", (Object)cache.get((Object)"k1"));
            this.assertCleanCacheAndStore(cache);
        }
    }

    @Test
    public void testWithoutPreload() {
        JdbcConfigurationUtil jdbcUtil = new JdbcConfigurationUtil(true, false);
        this.cm = jdbcUtil.getCacheManager();
        Cache cache = this.cm.getCache("jdbc");
        cache.put((Object)"k1", (Object)"v1");
        cache.put((Object)"k2", (Object)"v2");
        cache.stop();
        cache.start();
        Assert.assertEquals((long)0L, (long)this.getNumberOfEntriesInMemory(cache));
        this.assertCleanCacheAndStore(cache);
    }

    private void assertCleanCacheAndStore(Cache cache) {
        cache.clear();
        Assert.assertEquals((long)0L, (long)cache.size());
    }

    private int getNumberOfEntriesInMemory(Cache<?, ?> cache) {
        return cache.getAdvancedCache().withFlags(Flag.SKIP_CACHE_LOAD).size();
    }
}

