/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.test.integration.remote;

import java.io.IOException;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.RemoteCacheContainer;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.configuration.Configuration;
import org.infinispan.client.hotrod.configuration.ConfigurationBuilder;
import org.infinispan.client.hotrod.marshall.MarshallerUtil;
import org.infinispan.commons.marshall.Marshaller;
import org.infinispan.commons.marshall.ProtoStreamMarshaller;
import org.infinispan.protostream.SerializationContext;
import org.infinispan.protostream.annotations.ProtoSchemaBuilder;
import org.infinispan.test.integration.data.Person;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public abstract class AbstractHotRodClientIT {
    private RemoteCache remoteCache;

    @Before
    public void initialize() {
        this.remoteCache = AbstractHotRodClientIT.createRemoteCache();
    }

    @Test
    public void testPutGetCustomObject() throws IOException {
        SerializationContext serializationContext = MarshallerUtil.getSerializationContext((RemoteCacheContainer)this.remoteCache.getRemoteCacheManager());
        ProtoSchemaBuilder protoSchemaBuilder = new ProtoSchemaBuilder();
        String protoFile = protoSchemaBuilder.fileName("test.proto").addClass(Person.class).build(serializationContext);
        this.remoteCache.put((Object)"test.proto", (Object)protoFile);
        Person p = new Person("Martin");
        this.remoteCache.put((Object)"k1", (Object)p);
        Assert.assertEquals((Object)p.getName(), (Object)((Person)this.remoteCache.get((Object)"k1")).getName());
    }

    private static RemoteCache createRemoteCache() {
        RemoteCacheManager remoteCacheManager = new RemoteCacheManager(AbstractHotRodClientIT.createConfiguration(), true);
        RemoteCache remoteCache = remoteCacheManager.getCache();
        remoteCache.clear();
        return remoteCache;
    }

    private static Configuration createConfiguration() {
        ConfigurationBuilder config = new ConfigurationBuilder();
        config.addServer().host("127.0.0.1");
        config.marshaller((Marshaller)new ProtoStreamMarshaller());
        return config.build();
    }
}

