/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.test.integration.remote;

import java.util.List;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.RemoteCacheContainer;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.Search;
import org.infinispan.client.hotrod.configuration.ConfigurationBuilder;
import org.infinispan.client.hotrod.marshall.MarshallerUtil;
import org.infinispan.commons.configuration.BasicConfiguration;
import org.infinispan.commons.configuration.StringConfiguration;
import org.infinispan.commons.marshall.Marshaller;
import org.infinispan.commons.marshall.ProtoStreamMarshaller;
import org.infinispan.protostream.SerializationContext;
import org.infinispan.protostream.SerializationContextInitializer;
import org.infinispan.protostream.annotations.ProtoSchemaBuilder;
import org.infinispan.query.dsl.Query;
import org.infinispan.query.dsl.QueryFactory;
import org.infinispan.test.integration.data.Book;
import org.infinispan.test.integration.data.Person;
import org.infinispan.test.integration.remote.proto.BookQuerySchemaImpl;
import org.junit.Assert;
import org.junit.Test;

public abstract class AbstractHotRodQueryIT {
    private static final String HOST = "127.0.0.1";

    @Test
    public void testIndexed() {
        BookQuerySchemaImpl schema = new BookQuerySchemaImpl();
        ConfigurationBuilder config = this.localServerConfiguration();
        config.addContextInitializer((SerializationContextInitializer)schema);
        try (RemoteCacheManager remoteCacheManager = new RemoteCacheManager(config.build());){
            this.registerSchema(remoteCacheManager, schema.getProtoFileName(), schema.getProtoFile());
            String xmlConfig = "<distributed-cache name=\"books\">\n  <indexing path=\"${java.io.tmpdir}/index\">\n    <indexed-entities>\n      <indexed-entity>book_sample.Book</indexed-entity>\n    </indexed-entities>\n  </indexing>\n</distributed-cache>";
            RemoteCache remoteCache = remoteCacheManager.administration().getOrCreateCache("books", (BasicConfiguration)new StringConfiguration(xmlConfig));
            Book book1 = new Book("Infinispan in Action", "Learn Infinispan with using it", 2015);
            Book book2 = new Book("Cloud-Native Applications with Java and Quarkus", "Build robust and reliable cloud applications", 2019);
            remoteCache.put((Object)1, (Object)book1);
            remoteCache.put((Object)2, (Object)book2);
            QueryFactory queryFactory = Search.getQueryFactory((RemoteCache)remoteCache);
            Query query = queryFactory.create("FROM book_sample.Book WHERE title:'java'");
            List list = query.execute().list();
            Assert.assertEquals((long)1L, (long)list.size());
        }
    }

    @Test
    public void testRemoteQuery() throws Exception {
        ConfigurationBuilder config = this.localServerConfiguration();
        config.marshaller((Marshaller)new ProtoStreamMarshaller());
        try (RemoteCacheManager rcm = new RemoteCacheManager(config.build());){
            SerializationContext serializationContext = MarshallerUtil.getSerializationContext((RemoteCacheContainer)rcm);
            String protoKey = "test.proto";
            ProtoSchemaBuilder protoSchemaBuilder = new ProtoSchemaBuilder();
            String protoFile = protoSchemaBuilder.fileName(protoKey).addClass(Person.class).build(serializationContext);
            this.registerSchema(rcm, protoKey, protoFile);
            RemoteCache cache = rcm.getCache();
            cache.clear();
            cache.put((Object)"Adrian", (Object)new Person("Adrian"));
            Assert.assertTrue((boolean)cache.containsKey((Object)"Adrian"));
            QueryFactory qf = Search.getQueryFactory((RemoteCache)cache);
            Query query = qf.from(Person.class).having("name").eq((Object)"Adrian").build();
            List list = query.execute().list();
            Assert.assertNotNull((Object)list);
            Assert.assertEquals((long)1L, (long)list.size());
            Assert.assertEquals(Person.class, ((Person)list.get(0)).getClass());
            Assert.assertEquals((Object)"Adrian", (Object)((Person)list.get((int)0)).name);
        }
    }

    @Test
    public void testUninverting() throws Exception {
        ConfigurationBuilder config = this.localServerConfiguration();
        config.marshaller((Marshaller)new ProtoStreamMarshaller());
        try (RemoteCacheManager rcm = new RemoteCacheManager(config.build());){
            SerializationContext serializationContext = MarshallerUtil.getSerializationContext((RemoteCacheContainer)rcm);
            String protoKey = "test.proto";
            ProtoSchemaBuilder protoSchemaBuilder = new ProtoSchemaBuilder();
            String protoFile = protoSchemaBuilder.fileName(protoKey).addClass(Person.class).build(serializationContext);
            this.registerSchema(rcm, protoKey, protoFile);
            RemoteCache cache = rcm.getCache();
            cache.clear();
            QueryFactory qf = Search.getQueryFactory((RemoteCache)cache);
            Query query = qf.from(Person.class).having("name").eq((Object)"John").orderBy("id").build();
            Assert.assertEquals((long)0L, (long)query.execute().list().size());
        }
    }

    private ConfigurationBuilder localServerConfiguration() {
        ConfigurationBuilder config = new ConfigurationBuilder();
        config.addServer().host(HOST);
        return config;
    }

    private void registerSchema(RemoteCacheManager rcm, String key, String protoFile) {
        RemoteCache metadataCache = rcm.getCache("___protobuf_metadata");
        metadataCache.put((Object)key, (Object)protoFile);
        Assert.assertFalse((boolean)metadataCache.containsKey((Object)".errors"));
    }
}

