/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.memcached;

import javax.management.JMException;
import javax.management.ObjectName;
import org.infinispan.commons.jmx.MBeanServerLookup;
import org.infinispan.commons.jmx.MBeanServerLookupProvider;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.server.memcached.MemcachedMultiNodeTest;
import org.infinispan.server.memcached.MemcachedServer;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="server.memcached.MemcachedClusteredStatsTest")
public class MemcachedClusteredStatsTest
extends MemcachedMultiNodeTest {
    private static final String JMX_DOMAIN = MemcachedClusteredStatsTest.class.getSimpleName();
    private final MBeanServerLookup mBeanServerLookup = MBeanServerLookupProvider.create();

    @Override
    public EmbeddedCacheManager createCacheManager(int index) {
        ConfigurationBuilder builder = new ConfigurationBuilder();
        builder.clustering().cacheMode(CacheMode.REPL_SYNC);
        return TestCacheManagerFactory.createClusteredCacheManagerEnforceJmxDomain((String)JMX_DOMAIN, (String)(JMX_DOMAIN + "-" + index), (boolean)true, (boolean)false, (ConfigurationBuilder)builder, (MBeanServerLookup)this.mBeanServerLookup);
    }

    public void testSingleConnectionPerServer() throws Exception {
        ObjectName objectName = new ObjectName(String.format("%s-0:type=Server,component=Transport,name=Memcached-%s-%d", JMX_DOMAIN, ((Object)((Object)this)).getClass().getSimpleName(), ((MemcachedServer)this.servers.get(0)).getPort()));
        this.eventuallyEquals(2, () -> {
            try {
                return this.mBeanServerLookup.getMBeanServer().getAttribute(objectName, "NumberOfGlobalConnections");
            }
            catch (JMException e) {
                this.log.debug((Object)"Exception encountered", (Throwable)e);
                return 0;
            }
        });
    }
}

