/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.memcached;

import java.io.IOException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import net.spy.memcached.CASValue;
import net.spy.memcached.MemcachedClient;
import net.spy.memcached.internal.OperationFuture;
import org.infinispan.commons.jmx.MBeanServerLookup;
import org.infinispan.commons.jmx.TestMBeanServerLookup;
import org.infinispan.commons.util.Version;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.server.memcached.MemcachedSingleNodeTest;
import org.infinispan.server.memcached.test.MemcachedTestingUtil;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.infinispan.test.fwk.TestResourceTracker;
import org.jgroups.util.Triple;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="server.memcached.MemcachedStatsTest")
public class MemcachedStatsTest
extends MemcachedSingleNodeTest {
    private static final String jmxDomain = MemcachedStatsTest.class.getSimpleName();
    private final MBeanServerLookup mBeanServerLookup = TestMBeanServerLookup.create();

    @Override
    public EmbeddedCacheManager createTestCacheManager() {
        GlobalConfigurationBuilder globalConfiguration = new GlobalConfigurationBuilder().nonClusteredDefault();
        globalConfiguration.jmx().enabled(true).domain(jmxDomain).mBeanServerLookup(this.mBeanServerLookup);
        ConfigurationBuilder configuration = new ConfigurationBuilder();
        configuration.statistics().enabled(true);
        return TestCacheManagerFactory.createCacheManager((GlobalConfigurationBuilder)globalConfiguration, (ConfigurationBuilder)configuration);
    }

    public void testUnsupportedStats() {
        Triple<Map<String, String>, Integer, Integer> stats = this.getStats(-1, -1);
        Assert.assertEquals((String)((String)((Map)stats.getVal1()).get("pid")), (String)"0");
        Assert.assertEquals((String)((String)((Map)stats.getVal1()).get("pointer_size")), (String)"0");
        Assert.assertEquals((String)((String)((Map)stats.getVal1()).get("rusage_user")), (String)"0");
        Assert.assertEquals((String)((String)((Map)stats.getVal1()).get("rusage_system")), (String)"0");
        Assert.assertEquals((String)((String)((Map)stats.getVal1()).get("bytes")), (String)"0");
        Assert.assertEquals((String)((String)((Map)stats.getVal1()).get("connection_structures")), (String)"0");
        Assert.assertEquals((String)((String)((Map)stats.getVal1()).get("auth_cmds")), (String)"0");
        Assert.assertEquals((String)((String)((Map)stats.getVal1()).get("auth_errors")), (String)"0");
        Assert.assertEquals((String)((String)((Map)stats.getVal1()).get("limit_maxbytes")), (String)"0");
        Assert.assertEquals((String)((String)((Map)stats.getVal1()).get("conn_yields")), (String)"0");
        Assert.assertEquals((String)((String)((Map)stats.getVal1()).get("reclaimed")), (String)"0");
    }

    public void testUncomparableStats() {
        TestingUtil.sleepThread((long)TimeUnit.SECONDS.toMillis(1L));
        Triple<Map<String, String>, Integer, Integer> stats = this.getStats(-1, -1);
        Assert.assertNotSame(((Map)stats.getVal1()).get("uptime"), (Object)"0");
        Assert.assertNotSame(((Map)stats.getVal1()).get("time"), (Object)"0");
        Assert.assertNotSame(((Map)stats.getVal1()).get("uptime"), ((Map)stats.getVal1()).get("time"));
    }

    public void testStaticStats() {
        Triple<Map<String, String>, Integer, Integer> stats = this.getStats(-1, -1);
        Assert.assertEquals((String)((String)((Map)stats.getVal1()).get("version")), (String)Version.getVersion());
    }

    public void testTodoStats() {
        Triple<Map<String, String>, Integer, Integer> stats = this.getStats(-1, -1);
        Assert.assertEquals((String)((String)((Map)stats.getVal1()).get("curr_connections")), (String)"0");
        Assert.assertEquals((String)((String)((Map)stats.getVal1()).get("total_connections")), (String)"0");
        Assert.assertEquals((String)((String)((Map)stats.getVal1()).get("threads")), (String)"0");
    }

    public void testStats(Method m) throws InterruptedException, ExecutionException, TimeoutException {
        Triple<Map<String, String>, Integer, Integer> stats = this.getStats(-1, -1);
        Assert.assertEquals((String)((String)((Map)stats.getVal1()).get("cmd_set")), (String)"0");
        Assert.assertEquals((String)((String)((Map)stats.getVal1()).get("cmd_get")), (String)"0");
        Assert.assertEquals((String)((String)((Map)stats.getVal1()).get("get_hits")), (String)"0");
        Assert.assertEquals((String)((String)((Map)stats.getVal1()).get("get_misses")), (String)"0");
        Assert.assertEquals((String)((String)((Map)stats.getVal1()).get("delete_hits")), (String)"0");
        Assert.assertEquals((String)((String)((Map)stats.getVal1()).get("delete_misses")), (String)"0");
        Assert.assertEquals((String)((String)((Map)stats.getVal1()).get("curr_items")), (String)"0");
        Assert.assertEquals((String)((String)((Map)stats.getVal1()).get("total_items")), (String)"0");
        Assert.assertEquals((String)((String)((Map)stats.getVal1()).get("incr_misses")), (String)"0");
        Assert.assertEquals((String)((String)((Map)stats.getVal1()).get("incr_hits")), (String)"0");
        Assert.assertEquals((String)((String)((Map)stats.getVal1()).get("decr_misses")), (String)"0");
        Assert.assertEquals((String)((String)((Map)stats.getVal1()).get("decr_hits")), (String)"0");
        Assert.assertEquals((String)((String)((Map)stats.getVal1()).get("cas_misses")), (String)"0");
        Assert.assertEquals((String)((String)((Map)stats.getVal1()).get("cas_hits")), (String)"0");
        Assert.assertEquals((String)((String)((Map)stats.getVal1()).get("cas_badval")), (String)"0");
        OperationFuture f = this.client.set(TestingUtil.k((Method)m), 0, (Object)TestingUtil.v((Method)m));
        Assert.assertTrue((boolean)((Boolean)f.get(60L, TimeUnit.SECONDS)));
        Assert.assertEquals((Object)this.client.get(TestingUtil.k((Method)m)), (Object)TestingUtil.v((Method)m));
        f = this.client.set(TestingUtil.k((Method)m, (String)"k1-"), 0, (Object)TestingUtil.v((Method)m, (String)"v1-"));
        Assert.assertTrue((boolean)((Boolean)f.get(60L, TimeUnit.SECONDS)));
        Assert.assertEquals((Object)this.client.get(TestingUtil.k((Method)m, (String)"k1-")), (Object)TestingUtil.v((Method)m, (String)"v1-"));
        stats = this.getStats((Integer)stats.getVal2(), (Integer)stats.getVal3());
        Assert.assertEquals((String)((String)((Map)stats.getVal1()).get("cmd_set")), (String)"2");
        Assert.assertEquals((String)((String)((Map)stats.getVal1()).get("cmd_get")), (String)"2");
        Assert.assertEquals((String)((String)((Map)stats.getVal1()).get("get_hits")), (String)"2");
        Assert.assertEquals((String)((String)((Map)stats.getVal1()).get("get_misses")), (String)"0");
        Assert.assertEquals((String)((String)((Map)stats.getVal1()).get("delete_hits")), (String)"0");
        Assert.assertEquals((String)((String)((Map)stats.getVal1()).get("delete_misses")), (String)"0");
        Assert.assertEquals((String)((String)((Map)stats.getVal1()).get("curr_items")), (String)"2");
        Assert.assertEquals((String)((String)((Map)stats.getVal1()).get("total_items")), (String)"2");
        f = this.client.delete(TestingUtil.k((Method)m, (String)"k1-"));
        Assert.assertTrue((boolean)((Boolean)f.get(60L, TimeUnit.SECONDS)));
        stats = this.getStats((Integer)stats.getVal2(), (Integer)stats.getVal3());
        Assert.assertEquals((String)((String)((Map)stats.getVal1()).get("curr_items")), (String)"1");
        Assert.assertEquals((String)((String)((Map)stats.getVal1()).get("total_items")), (String)"2");
        Assert.assertEquals((String)((String)((Map)stats.getVal1()).get("delete_hits")), (String)"1");
        Assert.assertEquals((String)((String)((Map)stats.getVal1()).get("delete_misses")), (String)"0");
        Assert.assertNull((Object)this.client.get(TestingUtil.k((Method)m, (String)"k99-")));
        stats = this.getStats((Integer)stats.getVal2(), (Integer)stats.getVal3());
        Assert.assertEquals((String)((String)((Map)stats.getVal1()).get("get_hits")), (String)"2");
        Assert.assertEquals((String)((String)((Map)stats.getVal1()).get("get_misses")), (String)"1");
        f = this.client.delete(TestingUtil.k((Method)m, (String)"k99-"));
        Assert.assertFalse((boolean)((Boolean)f.get(60L, TimeUnit.SECONDS)));
        stats = this.getStats((Integer)stats.getVal2(), (Integer)stats.getVal3());
        Assert.assertEquals((String)((String)((Map)stats.getVal1()).get("delete_hits")), (String)"1");
        Assert.assertEquals((String)((String)((Map)stats.getVal1()).get("delete_misses")), (String)"1");
        int future = (int)TimeUnit.MILLISECONDS.toSeconds(System.currentTimeMillis() + 1000L);
        f = this.client.set(TestingUtil.k((Method)m, (String)"k3-"), future, (Object)TestingUtil.v((Method)m, (String)"v3-"));
        Assert.assertTrue((boolean)((Boolean)f.get(60L, TimeUnit.SECONDS)));
        TestingUtil.sleepThread((long)1100L);
        Assert.assertNull((Object)this.client.get(TestingUtil.k((Method)m, (String)"k3-")));
        stats = this.getStats((Integer)stats.getVal2(), (Integer)stats.getVal3());
        Assert.assertEquals((String)((String)((Map)stats.getVal1()).get("curr_items")), (String)"1");
        Assert.assertEquals((String)((String)((Map)stats.getVal1()).get("total_items")), (String)"3");
        this.client.incr(TestingUtil.k((Method)m, (String)"k4-"), 1);
        stats = this.getStats((Integer)stats.getVal2(), (Integer)stats.getVal3());
        Assert.assertEquals((String)((String)((Map)stats.getVal1()).get("incr_misses")), (String)"1");
        Assert.assertEquals((String)((String)((Map)stats.getVal1()).get("incr_hits")), (String)"0");
        f = this.client.set(TestingUtil.k((Method)m, (String)"k4-"), 0, (Object)"1");
        Assert.assertTrue((boolean)((Boolean)f.get(60L, TimeUnit.SECONDS)));
        this.client.incr(TestingUtil.k((Method)m, (String)"k4-"), 1);
        this.client.incr(TestingUtil.k((Method)m, (String)"k4-"), 2);
        this.client.incr(TestingUtil.k((Method)m, (String)"k4-"), 4);
        stats = this.getStats((Integer)stats.getVal2(), (Integer)stats.getVal3());
        Assert.assertEquals((String)((String)((Map)stats.getVal1()).get("incr_misses")), (String)"1");
        Assert.assertEquals((String)((String)((Map)stats.getVal1()).get("incr_hits")), (String)"3");
        this.client.decr(TestingUtil.k((Method)m, (String)"k5-"), 1);
        stats = this.getStats((Integer)stats.getVal2(), (Integer)stats.getVal3());
        Assert.assertEquals((String)((String)((Map)stats.getVal1()).get("decr_misses")), (String)"1");
        Assert.assertEquals((String)((String)((Map)stats.getVal1()).get("decr_hits")), (String)"0");
        f = this.client.set(TestingUtil.k((Method)m, (String)"k5-"), 0, (Object)"8");
        Assert.assertTrue((boolean)((Boolean)f.get(60L, TimeUnit.SECONDS)));
        this.client.decr(TestingUtil.k((Method)m, (String)"k5-"), 1);
        this.client.decr(TestingUtil.k((Method)m, (String)"k5-"), 2);
        this.client.decr(TestingUtil.k((Method)m, (String)"k5-"), 4);
        stats = this.getStats((Integer)stats.getVal2(), (Integer)stats.getVal3());
        Assert.assertEquals((String)((String)((Map)stats.getVal1()).get("decr_misses")), (String)"1");
        Assert.assertEquals((String)((String)((Map)stats.getVal1()).get("decr_hits")), (String)"3");
        this.client.cas(TestingUtil.k((Method)m, (String)"k6-"), 1234L, (Object)TestingUtil.v((Method)m, (String)"v6-"));
        stats = this.getStats((Integer)stats.getVal2(), (Integer)stats.getVal3());
        Assert.assertEquals((String)((String)((Map)stats.getVal1()).get("cas_misses")), (String)"1");
        Assert.assertEquals((String)((String)((Map)stats.getVal1()).get("cas_hits")), (String)"0");
        Assert.assertEquals((String)((String)((Map)stats.getVal1()).get("cas_badval")), (String)"0");
        f = this.client.set(TestingUtil.k((Method)m, (String)"k6-"), 0, (Object)TestingUtil.v((Method)m, (String)"v6-"));
        Assert.assertTrue((boolean)((Boolean)f.get(60L, TimeUnit.SECONDS)));
        CASValue value = this.client.gets(TestingUtil.k((Method)m, (String)"k6-"));
        long old = value.getCas();
        this.client.cas(TestingUtil.k((Method)m, (String)"k6-"), value.getCas(), (Object)TestingUtil.v((Method)m, (String)"v66-"));
        stats = this.getStats((Integer)stats.getVal2(), (Integer)stats.getVal3());
        Assert.assertEquals((String)((String)((Map)stats.getVal1()).get("cas_misses")), (String)"1");
        Assert.assertEquals((String)((String)((Map)stats.getVal1()).get("cas_hits")), (String)"1");
        Assert.assertEquals((String)((String)((Map)stats.getVal1()).get("cas_badval")), (String)"0");
        this.client.cas(TestingUtil.k((Method)m, (String)"k6-"), old, (Object)TestingUtil.v((Method)m, (String)"v66-"));
        stats = this.getStats((Integer)stats.getVal2(), (Integer)stats.getVal3());
        Assert.assertEquals((String)((String)((Map)stats.getVal1()).get("cas_misses")), (String)"1");
        Assert.assertEquals((String)((String)((Map)stats.getVal1()).get("cas_hits")), (String)"1");
        Assert.assertEquals((String)((String)((Map)stats.getVal1()).get("cas_badval")), (String)"1");
    }

    private List<MemcachedClient> createMultipleClients(List<MemcachedClient> clients, int number, int from) throws IOException {
        if (from >= number) {
            return clients;
        }
        MemcachedClient newClient = MemcachedTestingUtil.createMemcachedClient(60000L, this.server.getPort());
        Object value = newClient.get("a");
        if (value != null && value.hashCode() % 1000 == 0) {
            System.out.print(value.hashCode());
        }
        clients.add(newClient);
        return this.createMultipleClients(clients, number, from + 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testStatsSpecificToMemcachedViaJmx() throws Exception {
        this.getStats(-1, -1);
        MBeanServer mbeanServer = this.mBeanServerLookup.getMBeanServer();
        String serverName = "Memcached-" + TestResourceTracker.getCurrentTestShortName() + "-" + this.server.getPort();
        ObjectName on = new ObjectName(String.format("%s:type=Server,name=%s,component=Transport", jmxDomain, serverName));
        Assert.assertTrue((Integer.parseInt(mbeanServer.getAttribute(on, "TotalBytesRead").toString()) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((Integer.parseInt(mbeanServer.getAttribute(on, "TotalBytesWritten").toString()) > 0 ? 1 : 0) != 0);
        Assert.assertEquals((Object)mbeanServer.getAttribute(on, "NumberOfLocalConnections"), (Object)1);
        List<MemcachedClient> clients = new ArrayList<MemcachedClient>();
        try {
            clients = this.createMultipleClients(clients, 10, 0);
            Assert.assertEquals((Object)mbeanServer.getAttribute(on, "NumberOfLocalConnections"), (Object)(clients.size() + 1));
        }
        finally {
            clients.forEach(client -> {
                try {
                    client.shutdown(20L, TimeUnit.SECONDS);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            });
        }
    }

    public void testStatsWithArgs() throws IOException {
        String resp = this.send("stats\r\n");
        this.assertExpectedResponse(resp, "STAT", false);
        resp = this.send("stats \r\n");
        this.assertExpectedResponse(resp, "STAT", false);
        resp = this.send("stats boo\r\n");
        this.assertClientError(resp);
        resp = this.send("stats boo boo2 boo3\r\n");
        this.assertClientError(resp);
    }

    private Triple<Map<String, String>, Integer, Integer> getStats(int currentBytesRead, int currentBytesWritten) {
        Map globalStats = this.client.getStats();
        Assert.assertEquals((int)globalStats.size(), (int)1);
        Map stats = (Map)globalStats.values().iterator().next();
        int bytesRead = this.assertHigherBytes(currentBytesRead, (String)stats.get("bytes_read"));
        int bytesWritten = this.assertHigherBytes(currentBytesRead, (String)stats.get("bytes_written"));
        return new Triple((Object)stats, (Object)bytesRead, (Object)bytesWritten);
    }

    private int assertHigherBytes(int currentBytesRead, String bytesStr) {
        int bytesRead = Integer.parseInt(bytesStr);
        Assert.assertTrue((bytesRead > currentBytesRead ? 1 : 0) != 0);
        return bytesRead;
    }
}

