/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.memcached;

import javax.management.JMException;
import javax.management.ObjectName;
import org.infinispan.commons.jmx.MBeanServerLookup;
import org.infinispan.commons.jmx.TestMBeanServerLookup;
import org.infinispan.commons.test.TestResourceTracker;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.server.memcached.MemcachedMultiNodeTest;
import org.infinispan.server.memcached.MemcachedServer;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="server.memcached.MemcachedClusteredStatsTest")
public class MemcachedClusteredStatsTest
extends MemcachedMultiNodeTest {
    private static final String JMX_DOMAIN = MemcachedClusteredStatsTest.class.getSimpleName();
    private final MBeanServerLookup mBeanServerLookup = TestMBeanServerLookup.create();

    @Override
    public EmbeddedCacheManager createCacheManager(int index) {
        GlobalConfigurationBuilder globalBuilder = GlobalConfigurationBuilder.defaultClusteredBuilder();
        globalBuilder.defaultCacheName(cacheName);
        TestCacheManagerFactory.configureJmx((GlobalConfigurationBuilder)globalBuilder, (String)(JMX_DOMAIN + "-" + index), (MBeanServerLookup)this.mBeanServerLookup);
        ConfigurationBuilder builder = new ConfigurationBuilder();
        builder.clustering().cacheMode(CacheMode.REPL_SYNC);
        return TestCacheManagerFactory.createClusteredCacheManager((GlobalConfigurationBuilder)globalBuilder, (ConfigurationBuilder)builder);
    }

    public void testSingleConnectionPerServer() throws Exception {
        ObjectName objectName = new ObjectName(String.format("%s-0:type=Server,component=Transport,name=Memcached-%s-%d", JMX_DOMAIN, TestResourceTracker.getCurrentTestShortName(), ((MemcachedServer)this.servers.get(0)).getPort()));
        this.eventuallyEquals(2, () -> {
            try {
                return this.mBeanServerLookup.getMBeanServer().getAttribute(objectName, "NumberOfGlobalConnections");
            }
            catch (JMException e) {
                this.log.debug((Object)"Exception encountered", (Throwable)e);
                return 0;
            }
        });
    }
}

