/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.memcached;

import java.io.IOException;
import java.lang.reflect.Method;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import net.spy.memcached.CASResponse;
import net.spy.memcached.CASValue;
import net.spy.memcached.internal.OperationFuture;
import org.infinispan.Cache;
import org.infinispan.commons.util.Version;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.StorageType;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.server.memcached.MemcachedServer;
import org.infinispan.server.memcached.MemcachedSingleNodeTest;
import org.infinispan.server.memcached.NoReplyListener;
import org.infinispan.server.memcached.configuration.MemcachedServerConfiguration;
import org.infinispan.server.memcached.configuration.MemcachedServerConfigurationBuilder;
import org.infinispan.server.memcached.test.MemcachedTestingUtil;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="server.memcached.MemcachedFunctionalTest")
public class MemcachedFunctionalTest
extends MemcachedSingleNodeTest {
    public void testSetBasic(Method m) throws InterruptedException, ExecutionException, TimeoutException {
        OperationFuture f = this.client.set(TestingUtil.k((Method)m), 0, (Object)TestingUtil.v((Method)m));
        AssertJUnit.assertTrue((boolean)((Boolean)f.get(60L, TimeUnit.SECONDS)));
        AssertJUnit.assertEquals((Object)this.client.get(TestingUtil.k((Method)m)), (Object)TestingUtil.v((Method)m));
    }

    public void testSetWithExpirySeconds(Method m) throws InterruptedException, ExecutionException, TimeoutException {
        OperationFuture f = this.client.set(TestingUtil.k((Method)m), 1, (Object)TestingUtil.v((Method)m));
        AssertJUnit.assertTrue((boolean)((Boolean)f.get(60L, TimeUnit.SECONDS)));
        this.timeService.advance(1100L);
        AssertJUnit.assertNull((Object)this.client.get(TestingUtil.k((Method)m)));
    }

    public void testSetWithExpiryUnixTime(Method m) throws InterruptedException, ExecutionException, TimeoutException {
        int future = (int)TimeUnit.MILLISECONDS.toSeconds(this.timeService.wallClockTime() + 1000L);
        OperationFuture f = this.client.set(TestingUtil.k((Method)m), future, (Object)TestingUtil.v((Method)m));
        AssertJUnit.assertTrue((boolean)((Boolean)f.get(60L, TimeUnit.SECONDS)));
        this.timeService.advance(1100L);
        AssertJUnit.assertNull((Object)this.client.get(TestingUtil.k((Method)m)));
    }

    public void testSetWithExpiryUnixTimeInPast(Method m) throws InterruptedException, ExecutionException, TimeoutException {
        OperationFuture f = this.client.set(TestingUtil.k((Method)m), 2592001, (Object)TestingUtil.v((Method)m));
        AssertJUnit.assertTrue((boolean)((Boolean)f.get(60L, TimeUnit.SECONDS)));
        this.timeService.advance(1100L);
        AssertJUnit.assertNull((Object)this.client.get(TestingUtil.k((Method)m)));
    }

    public void testSetWithUTF8Key(Method m) throws InterruptedException, ExecutionException, TimeoutException {
        String key = "\u4f60\u597d-";
        OperationFuture f = this.client.set(TestingUtil.k((Method)m, (String)key), 0, (Object)TestingUtil.v((Method)m));
        AssertJUnit.assertTrue((boolean)((Boolean)f.get(60L, TimeUnit.SECONDS)));
        AssertJUnit.assertEquals((Object)TestingUtil.v((Method)m), (Object)this.client.get(TestingUtil.k((Method)m, (String)key)));
    }

    public void testGetMultipleKeys(Method m) throws InterruptedException, ExecutionException, TimeoutException {
        OperationFuture f1 = this.client.set(TestingUtil.k((Method)m, (String)"k1-"), 0, (Object)TestingUtil.v((Method)m, (String)"v1-"));
        OperationFuture f2 = this.client.set(TestingUtil.k((Method)m, (String)"k2-"), 0, (Object)TestingUtil.v((Method)m, (String)"v2-"));
        OperationFuture f3 = this.client.set(TestingUtil.k((Method)m, (String)"k3-"), 0, (Object)TestingUtil.v((Method)m, (String)"v3-"));
        AssertJUnit.assertTrue((boolean)((Boolean)f1.get(60L, TimeUnit.SECONDS)));
        AssertJUnit.assertTrue((boolean)((Boolean)f2.get(60L, TimeUnit.SECONDS)));
        AssertJUnit.assertTrue((boolean)((Boolean)f3.get(60L, TimeUnit.SECONDS)));
        List<String> keys = Arrays.asList(TestingUtil.k((Method)m, (String)"k1-"), TestingUtil.k((Method)m, (String)"k2-"), TestingUtil.k((Method)m, (String)"k3-"));
        Map ret = this.client.getBulk(keys);
        AssertJUnit.assertEquals(ret.get(TestingUtil.k((Method)m, (String)"k1-")), (Object)TestingUtil.v((Method)m, (String)"v1-"));
        AssertJUnit.assertEquals(ret.get(TestingUtil.k((Method)m, (String)"k2-")), (Object)TestingUtil.v((Method)m, (String)"v2-"));
        AssertJUnit.assertEquals(ret.get(TestingUtil.k((Method)m, (String)"k3-")), (Object)TestingUtil.v((Method)m, (String)"v3-"));
    }

    public void testAddBasic(Method m) throws InterruptedException, ExecutionException, TimeoutException {
        this.addAndGet(m);
    }

    public void testTouchWithExpiryUnixTime(Method m) throws InterruptedException, ExecutionException, TimeoutException {
        int future = (int)TimeUnit.MILLISECONDS.toSeconds(this.timeService.wallClockTime() + 1000L);
        OperationFuture f = this.client.set(TestingUtil.k((Method)m), future, (Object)TestingUtil.v((Method)m));
        AssertJUnit.assertTrue((boolean)((Boolean)f.get(60L, TimeUnit.SECONDS)));
        f = this.client.touch(TestingUtil.k((Method)m), future + 1);
        AssertJUnit.assertTrue((boolean)((Boolean)f.get(60L, TimeUnit.SECONDS)));
        this.timeService.advance(1100L);
        AssertJUnit.assertEquals((Object)TestingUtil.v((Method)m), (Object)this.client.get(TestingUtil.k((Method)m)));
        this.timeService.advance(1100L);
        AssertJUnit.assertNull((Object)this.client.get(TestingUtil.k((Method)m)));
    }

    public void testTouchWithExpirySeconds(Method m) throws InterruptedException, ExecutionException, TimeoutException {
        OperationFuture f = this.client.set(TestingUtil.k((Method)m), 1, (Object)TestingUtil.v((Method)m));
        AssertJUnit.assertTrue((boolean)((Boolean)f.get(60L, TimeUnit.SECONDS)));
        f = this.client.touch(TestingUtil.k((Method)m), 2);
        AssertJUnit.assertTrue((boolean)((Boolean)f.get(60L, TimeUnit.SECONDS)));
        this.timeService.advance(1100L);
        AssertJUnit.assertEquals((Object)TestingUtil.v((Method)m), (Object)this.client.get(TestingUtil.k((Method)m)));
        this.timeService.advance(1100L);
        AssertJUnit.assertNull((Object)this.client.get(TestingUtil.k((Method)m)));
    }

    public void testAddWithExpirySeconds(Method m) throws InterruptedException, ExecutionException, TimeoutException {
        OperationFuture f = this.client.add(TestingUtil.k((Method)m), 1, (Object)TestingUtil.v((Method)m));
        AssertJUnit.assertTrue((boolean)((Boolean)f.get(60L, TimeUnit.SECONDS)));
        this.timeService.advance(1100L);
        AssertJUnit.assertNull((Object)this.client.get(TestingUtil.k((Method)m)));
        f = this.client.add(TestingUtil.k((Method)m), 0, (Object)TestingUtil.v((Method)m, (String)"v1-"));
        AssertJUnit.assertTrue((boolean)((Boolean)f.get(60L, TimeUnit.SECONDS)));
        AssertJUnit.assertEquals((Object)this.client.get(TestingUtil.k((Method)m)), (Object)TestingUtil.v((Method)m, (String)"v1-"));
    }

    public void testAddWithExpiryUnixTime(Method m) throws InterruptedException, ExecutionException, TimeoutException {
        int future = (int)TimeUnit.MILLISECONDS.toSeconds(this.timeService.wallClockTime() + 1000L);
        OperationFuture f = this.client.add(TestingUtil.k((Method)m), future, (Object)TestingUtil.v((Method)m));
        AssertJUnit.assertTrue((boolean)((Boolean)f.get(60L, TimeUnit.SECONDS)));
        this.timeService.advance(1100L);
        AssertJUnit.assertNull((Object)this.client.get(TestingUtil.k((Method)m)));
        f = this.client.add(TestingUtil.k((Method)m), 0, (Object)TestingUtil.v((Method)m, (String)"v1-"));
        AssertJUnit.assertTrue((boolean)((Boolean)f.get(60L, TimeUnit.SECONDS)));
        AssertJUnit.assertEquals((Object)this.client.get(TestingUtil.k((Method)m)), (Object)TestingUtil.v((Method)m, (String)"v1-"));
    }

    public void testNotAddIfPresent(Method m) throws InterruptedException, ExecutionException, TimeoutException {
        this.addAndGet(m);
        OperationFuture f = this.client.add(TestingUtil.k((Method)m), 0, (Object)TestingUtil.v((Method)m, (String)"v1-"));
        AssertJUnit.assertFalse((boolean)((Boolean)f.get(60L, TimeUnit.SECONDS)));
        AssertJUnit.assertEquals((Object)this.client.get(TestingUtil.k((Method)m)), (Object)TestingUtil.v((Method)m));
    }

    public void testReplaceBasic(Method m) throws InterruptedException, ExecutionException, TimeoutException {
        this.addAndGet(m);
        OperationFuture f = this.client.replace(TestingUtil.k((Method)m), 0, (Object)TestingUtil.v((Method)m, (String)"v1-"));
        AssertJUnit.assertTrue((boolean)((Boolean)f.get(60L, TimeUnit.SECONDS)));
        AssertJUnit.assertEquals((Object)this.client.get(TestingUtil.k((Method)m)), (Object)TestingUtil.v((Method)m, (String)"v1-"));
    }

    public void testNotReplaceIfNotPresent(Method m) throws InterruptedException, ExecutionException, TimeoutException {
        OperationFuture f = this.client.replace(TestingUtil.k((Method)m), 0, (Object)TestingUtil.v((Method)m));
        AssertJUnit.assertFalse((boolean)((Boolean)f.get(60L, TimeUnit.SECONDS)));
        AssertJUnit.assertNull((Object)this.client.get(TestingUtil.k((Method)m)));
    }

    public void testReplaceWithExpirySeconds(Method m) throws InterruptedException, ExecutionException, TimeoutException {
        this.addAndGet(m);
        OperationFuture f = this.client.replace(TestingUtil.k((Method)m), 1, (Object)TestingUtil.v((Method)m, (String)"v1-"));
        AssertJUnit.assertTrue((boolean)((Boolean)f.get(60L, TimeUnit.SECONDS)));
        AssertJUnit.assertEquals((Object)this.client.get(TestingUtil.k((Method)m)), (Object)TestingUtil.v((Method)m, (String)"v1-"));
        this.timeService.advance(1100L);
        AssertJUnit.assertNull((Object)this.client.get(TestingUtil.k((Method)m)));
    }

    public void testReplaceWithExpiryUnixTime(Method m) throws InterruptedException, ExecutionException, TimeoutException {
        this.addAndGet(m);
        int future = (int)TimeUnit.MILLISECONDS.toSeconds(this.timeService.wallClockTime() + 1000L);
        OperationFuture f = this.client.replace(TestingUtil.k((Method)m), future, (Object)TestingUtil.v((Method)m, (String)"v1-"));
        AssertJUnit.assertTrue((boolean)((Boolean)f.get(60L, TimeUnit.SECONDS)));
        AssertJUnit.assertEquals((Object)this.client.get(TestingUtil.k((Method)m)), (Object)TestingUtil.v((Method)m, (String)"v1-"));
        this.timeService.advance(1100L);
        AssertJUnit.assertNull((Object)this.client.get(TestingUtil.k((Method)m)));
    }

    public void testAppendBasic(Method m) throws InterruptedException, ExecutionException, TimeoutException {
        this.addAndGet(m);
        OperationFuture f = this.client.append(0L, TestingUtil.k((Method)m), (Object)TestingUtil.v((Method)m, (String)"v1-"));
        AssertJUnit.assertTrue((boolean)((Boolean)f.get(60L, TimeUnit.SECONDS)));
        String expected = TestingUtil.v((Method)m) + TestingUtil.v((Method)m, (String)"v1-");
        AssertJUnit.assertEquals((Object)this.client.get(TestingUtil.k((Method)m)), (Object)expected);
    }

    public void testAppendNotFound(Method m) throws InterruptedException, ExecutionException, TimeoutException {
        this.addAndGet(m);
        OperationFuture f = this.client.append(0L, TestingUtil.k((Method)m, (String)"k2-"), (Object)TestingUtil.v((Method)m, (String)"v1-"));
        AssertJUnit.assertFalse((boolean)((Boolean)f.get(60L, TimeUnit.SECONDS)));
        AssertJUnit.assertEquals((Object)this.client.get(TestingUtil.k((Method)m)), (Object)TestingUtil.v((Method)m));
        AssertJUnit.assertNull((Object)this.client.get(TestingUtil.k((Method)m, (String)"k2-")));
    }

    public void testPrependBasic(Method m) throws InterruptedException, ExecutionException, TimeoutException {
        this.addAndGet(m);
        OperationFuture f = this.client.prepend(0L, TestingUtil.k((Method)m), (Object)TestingUtil.v((Method)m, (String)"v1-"));
        AssertJUnit.assertTrue((boolean)((Boolean)f.get(60L, TimeUnit.SECONDS)));
        String expected = TestingUtil.v((Method)m, (String)"v1-") + TestingUtil.v((Method)m);
        AssertJUnit.assertEquals((Object)this.client.get(TestingUtil.k((Method)m)), (Object)expected);
    }

    public void testPrependNotFound(Method m) throws InterruptedException, ExecutionException, TimeoutException {
        this.addAndGet(m);
        OperationFuture f = this.client.prepend(0L, TestingUtil.k((Method)m, (String)"k2-"), (Object)TestingUtil.v((Method)m, (String)"v1-"));
        AssertJUnit.assertFalse((boolean)((Boolean)f.get(60L, TimeUnit.SECONDS)));
        AssertJUnit.assertEquals((Object)this.client.get(TestingUtil.k((Method)m)), (Object)TestingUtil.v((Method)m));
        AssertJUnit.assertNull((Object)this.client.get(TestingUtil.k((Method)m, (String)"k2-")));
    }

    public void testGetsBasic(Method m) throws InterruptedException, ExecutionException, TimeoutException {
        this.addAndGet(m);
        CASValue value = this.client.gets(TestingUtil.k((Method)m));
        AssertJUnit.assertEquals((Object)value.getValue(), (Object)TestingUtil.v((Method)m));
        AssertJUnit.assertTrue((value.getCas() != 0L ? 1 : 0) != 0);
    }

    public void testCasBasic(Method m) throws InterruptedException, ExecutionException, TimeoutException {
        this.addAndGet(m);
        CASValue value = this.client.gets(TestingUtil.k((Method)m));
        AssertJUnit.assertEquals((Object)value.getValue(), (Object)TestingUtil.v((Method)m));
        AssertJUnit.assertTrue((value.getCas() != 0L ? 1 : 0) != 0);
        CASResponse resp = this.client.cas(TestingUtil.k((Method)m), value.getCas(), (Object)TestingUtil.v((Method)m, (String)"v1-"));
        AssertJUnit.assertEquals((Object)resp, (Object)CASResponse.OK);
    }

    public void testCasNotFound(Method m) throws InterruptedException, ExecutionException, TimeoutException {
        this.addAndGet(m);
        CASValue value = this.client.gets(TestingUtil.k((Method)m));
        AssertJUnit.assertEquals((Object)value.getValue(), (Object)TestingUtil.v((Method)m));
        AssertJUnit.assertTrue((value.getCas() != 0L ? 1 : 0) != 0);
        CASResponse resp = this.client.cas(TestingUtil.k((Method)m, (String)"k1-"), value.getCas(), (Object)TestingUtil.v((Method)m, (String)"v1-"));
        AssertJUnit.assertEquals((Object)resp, (Object)CASResponse.NOT_FOUND);
    }

    public void testCasExists(Method m) throws InterruptedException, ExecutionException, TimeoutException {
        this.addAndGet(m);
        CASValue value = this.client.gets(TestingUtil.k((Method)m));
        AssertJUnit.assertEquals((Object)value.getValue(), (Object)TestingUtil.v((Method)m));
        AssertJUnit.assertTrue((value.getCas() != 0L ? 1 : 0) != 0);
        long old = value.getCas();
        CASResponse resp = this.client.cas(TestingUtil.k((Method)m), value.getCas(), (Object)TestingUtil.v((Method)m, (String)"v1-"));
        value = this.client.gets(TestingUtil.k((Method)m));
        AssertJUnit.assertEquals((Object)value.getValue(), (Object)TestingUtil.v((Method)m, (String)"v1-"));
        AssertJUnit.assertTrue((value.getCas() != 0L ? 1 : 0) != 0);
        AssertJUnit.assertTrue((value.getCas() != old ? 1 : 0) != 0);
        resp = this.client.cas(TestingUtil.k((Method)m), old, (Object)TestingUtil.v((Method)m, (String)"v2-"));
        AssertJUnit.assertEquals((Object)resp, (Object)CASResponse.EXISTS);
        resp = this.client.cas(TestingUtil.k((Method)m), value.getCas(), (Object)TestingUtil.v((Method)m, (String)"v2-"));
        AssertJUnit.assertEquals((Object)resp, (Object)CASResponse.OK);
    }

    public void testInvalidCas() throws IOException {
        String resp = this.send("cas bad blah 0 0 0\r\n\r\n");
        this.assertClientError(resp);
        resp = this.send("cas bad 0 blah 0 0\r\n\r\n");
        this.assertClientError(resp);
        resp = this.send("cas bad 0 0 blah 0\r\n\r\n");
        this.assertClientError(resp);
        resp = this.send("cas bad 0 0 0 blah\r\n\r\n");
        this.assertClientError(resp);
    }

    public void testInvalidCasValue() throws IOException {
        String resp = this.send("cas foo 0 0 6 \r\nbarva2\r\n");
        this.assertClientError(resp);
    }

    public void testDeleteBasic(Method m) throws InterruptedException, ExecutionException, TimeoutException {
        this.addAndGet(m);
        OperationFuture f = this.client.delete(TestingUtil.k((Method)m));
        AssertJUnit.assertTrue((boolean)((Boolean)f.get(60L, TimeUnit.SECONDS)));
        AssertJUnit.assertNull((Object)this.client.get(TestingUtil.k((Method)m)));
    }

    public void testDeleteDoesNotExist(Method m) throws InterruptedException, ExecutionException, TimeoutException {
        OperationFuture f = this.client.delete(TestingUtil.k((Method)m));
        AssertJUnit.assertFalse((boolean)((Boolean)f.get(60L, TimeUnit.SECONDS)));
    }

    public void testDeleteNoReply(Method m) throws InterruptedException, ExecutionException, TimeoutException, IOException {
        this.withNoReply(m, String.format("delete %s noreply\r\n", TestingUtil.k((Method)m)));
    }

    public void testSetAndMultiDelete(Method m) throws IOException {
        String key = TestingUtil.k((Method)m);
        List<String> responses = this.sendMulti(String.format("set %s 0 0 1\r\na\r\ndelete %s\r\ndelete %s\r\ndelete %s\r\ndelete %s\r\n", key, key, key, key, key), 5, true);
        AssertJUnit.assertEquals((int)responses.size(), (int)5);
        AssertJUnit.assertEquals((String)responses.get(0), (String)"STORED");
        AssertJUnit.assertEquals((String)responses.get(1), (String)"DELETED");
        AssertJUnit.assertEquals((String)responses.get(2), (String)"NOT_FOUND");
        AssertJUnit.assertEquals((String)responses.get(3), (String)"NOT_FOUND");
        AssertJUnit.assertEquals((String)responses.get(4), (String)"NOT_FOUND");
    }

    public void testSetNoReplyMultiDelete(Method m) throws IOException {
        String key = TestingUtil.k((Method)m);
        List<String> responses = this.sendMulti(String.format("set %s 0 0 1 noreply\r\na\r\ndelete %s\r\ndelete %s\r\ndelete %s\r\ndelete %s\r\n", key, key, key, key, key), 4, true);
        AssertJUnit.assertEquals((int)responses.size(), (int)4);
        AssertJUnit.assertEquals((String)responses.get(0), (String)"DELETED");
        AssertJUnit.assertEquals((String)responses.get(1), (String)"NOT_FOUND");
        AssertJUnit.assertEquals((String)responses.get(2), (String)"NOT_FOUND");
        AssertJUnit.assertEquals((String)responses.get(3), (String)"NOT_FOUND");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void withNoReply(Method m, String op) throws InterruptedException, ExecutionException, TimeoutException, IOException {
        OperationFuture f = this.client.set(TestingUtil.k((Method)m), 0, (Object)"blah");
        AssertJUnit.assertTrue((boolean)((Boolean)f.get(60L, TimeUnit.SECONDS)));
        CountDownLatch latch = new CountDownLatch(1);
        NoReplyListener listener = new NoReplyListener(latch);
        this.cache.addListener((Object)listener);
        try {
            this.sendNoWait(op);
            log.debug((Object)"No reply delete sent, wait...");
            boolean completed = latch.await(10L, TimeUnit.SECONDS);
            AssertJUnit.assertTrue((String)"Timed out waiting for remove to be executed", (boolean)completed);
        }
        finally {
            this.cache.removeListener((Object)listener);
        }
    }

    public void testPipelinedDelete() throws IOException {
        List<String> responses = this.sendMulti("delete a\r\ndelete a\r\n", 2, true);
        AssertJUnit.assertEquals((int)responses.size(), (int)2);
        responses.forEach(r -> AssertJUnit.assertTrue((boolean)r.equals("NOT_FOUND")));
    }

    public void testPipelinedGetAfterInvalidCas() throws IOException {
        List<String> responses = this.sendMulti("cas bad 0 0 1 0 0\r\nget a\r\n", 2, true);
        AssertJUnit.assertEquals((int)responses.size(), (int)2);
        AssertJUnit.assertTrue((boolean)responses.get(0).contains("CLIENT_ERROR"));
        AssertJUnit.assertTrue((String)("Instead response was: " + responses.get(1)), (boolean)responses.get(1).equals("END"));
    }

    public void testIncrementBasic(Method m) throws InterruptedException, ExecutionException, TimeoutException {
        OperationFuture f = this.client.set(TestingUtil.k((Method)m), 0, (Object)"1");
        AssertJUnit.assertTrue((boolean)((Boolean)f.get(60L, TimeUnit.SECONDS)));
        long result = this.client.incr(TestingUtil.k((Method)m), 1);
        AssertJUnit.assertEquals((long)result, (long)2L);
    }

    public void testIncrementTriple(Method m) throws InterruptedException, ExecutionException, TimeoutException {
        OperationFuture f = this.client.set(TestingUtil.k((Method)m), 0, (Object)"1");
        AssertJUnit.assertTrue((boolean)((Boolean)f.get(60L, TimeUnit.SECONDS)));
        AssertJUnit.assertEquals((long)this.client.incr(TestingUtil.k((Method)m), 1), (long)2L);
        AssertJUnit.assertEquals((long)this.client.incr(TestingUtil.k((Method)m), 2), (long)4L);
        AssertJUnit.assertEquals((long)this.client.incr(TestingUtil.k((Method)m), 4), (long)8L);
    }

    public void testIncrementNotExist(Method m) {
        AssertJUnit.assertEquals((long)this.client.incr(TestingUtil.k((Method)m), 1), (long)-1L);
    }

    public void testIncrementIntegerMax(Method m) throws InterruptedException, ExecutionException, TimeoutException {
        OperationFuture f = this.client.set(TestingUtil.k((Method)m), 0, (Object)"0");
        AssertJUnit.assertTrue((boolean)((Boolean)f.get(60L, TimeUnit.SECONDS)));
        AssertJUnit.assertEquals((long)this.client.incr(TestingUtil.k((Method)m), Integer.MAX_VALUE), (long)Integer.MAX_VALUE);
    }

    public void testIncrementBeyondIntegerMax(Method m) throws InterruptedException, ExecutionException, TimeoutException {
        OperationFuture f = this.client.set(TestingUtil.k((Method)m), 0, (Object)"1");
        AssertJUnit.assertTrue((boolean)((Boolean)f.get(60L, TimeUnit.SECONDS)));
        long newValue = this.client.incr(TestingUtil.k((Method)m), Integer.MAX_VALUE);
        AssertJUnit.assertEquals((long)newValue, (long)0x80000000L);
    }

    public void testIncrementBeyondLongMax(Method m) throws InterruptedException, ExecutionException, TimeoutException, IOException {
        OperationFuture f = this.client.set(TestingUtil.k((Method)m), 0, (Object)"9223372036854775808");
        AssertJUnit.assertTrue((boolean)((Boolean)f.get(60L, TimeUnit.SECONDS)));
        String newValue = this.incr(m, 1);
        AssertJUnit.assertEquals((Object)new BigInteger(newValue), (Object)new BigInteger("9223372036854775809"));
    }

    public void testIncrementSurpassLongMax(Method m) throws InterruptedException, ExecutionException, TimeoutException, IOException {
        OperationFuture f = this.client.set(TestingUtil.k((Method)m), 0, (Object)"9223372036854775807");
        AssertJUnit.assertTrue((boolean)((Boolean)f.get(60L, TimeUnit.SECONDS)));
        String newValue = this.incr(m, 1);
        AssertJUnit.assertEquals((Object)new BigInteger(newValue), (Object)new BigInteger("9223372036854775808"));
    }

    public void testIncrementSurpassBigIntMax(Method m) throws InterruptedException, ExecutionException, TimeoutException, IOException {
        OperationFuture f = this.client.set(TestingUtil.k((Method)m), 0, (Object)"18446744073709551615");
        AssertJUnit.assertTrue((boolean)((Boolean)f.get(60L, TimeUnit.SECONDS)));
        String newValue = this.incr(m, 1);
        AssertJUnit.assertEquals((String)newValue, (String)"0");
    }

    public void testDecrementBasic(Method m) throws InterruptedException, ExecutionException, TimeoutException {
        OperationFuture f = this.client.set(TestingUtil.k((Method)m), 0, (Object)"1");
        AssertJUnit.assertTrue((boolean)((Boolean)f.get(60L, TimeUnit.SECONDS)));
        AssertJUnit.assertEquals((long)this.client.decr(TestingUtil.k((Method)m), 1), (long)0L);
    }

    public void testDecrementTriple(Method m) throws InterruptedException, ExecutionException, TimeoutException {
        OperationFuture f = this.client.set(TestingUtil.k((Method)m), 0, (Object)"8");
        AssertJUnit.assertTrue((boolean)((Boolean)f.get(60L, TimeUnit.SECONDS)));
        AssertJUnit.assertEquals((long)this.client.decr(TestingUtil.k((Method)m), 1), (long)7L);
        AssertJUnit.assertEquals((long)this.client.decr(TestingUtil.k((Method)m), 2), (long)5L);
        AssertJUnit.assertEquals((long)this.client.decr(TestingUtil.k((Method)m), 4), (long)1L);
    }

    public void testDecrementNotExist(Method m) {
        AssertJUnit.assertEquals((long)this.client.decr(TestingUtil.k((Method)m), 1), (long)-1L);
    }

    public void testDecrementBelowZero(Method m) throws InterruptedException, ExecutionException, TimeoutException {
        OperationFuture f = this.client.set(TestingUtil.k((Method)m), 0, (Object)"1");
        AssertJUnit.assertTrue((boolean)((Boolean)f.get(60L, TimeUnit.SECONDS)));
        long newValue = this.client.decr(TestingUtil.k((Method)m), 2);
        AssertJUnit.assertEquals((long)newValue, (long)0L);
    }

    public void testFlushAll(Method m) throws InterruptedException, ExecutionException, TimeoutException {
        for (int i = 1; i < 5; ++i) {
            String key = TestingUtil.k((Method)m, (String)("k" + i + "-"));
            String value = TestingUtil.v((Method)m, (String)("v" + i + "-"));
            OperationFuture f = this.client.set(key, 0, (Object)value);
            AssertJUnit.assertTrue((boolean)((Boolean)f.get(60L, TimeUnit.SECONDS)));
            AssertJUnit.assertEquals((Object)this.client.get(key), (Object)value);
        }
        OperationFuture f = this.client.flush();
        AssertJUnit.assertTrue((boolean)((Boolean)f.get(60L, TimeUnit.SECONDS)));
        for (int i = 1; i < 5; ++i) {
            String key = TestingUtil.k((Method)m, (String)("k" + i + "-"));
            AssertJUnit.assertNull((Object)this.client.get(key));
        }
    }

    public void testFlushAllDelayed(Method m) throws InterruptedException, ExecutionException, TimeoutException {
        this.flushAllDelayed(m, 2, 2200L);
    }

    public void testFlushAllDelayedUnixTime(Method m) throws InterruptedException, ExecutionException, TimeoutException {
        int delay = (int)TimeUnit.MILLISECONDS.toSeconds(this.timeService.wallClockTime() + 2000L);
        this.flushAllDelayed(m, delay, 2200L);
    }

    private void flushAllDelayed(Method m, int delay, long sleep) throws InterruptedException, ExecutionException, TimeoutException {
        for (int i = 1; i < 5; ++i) {
            String key = TestingUtil.k((Method)m, (String)("k" + i + "-"));
            String value = TestingUtil.v((Method)m, (String)("v" + i + "-"));
            OperationFuture f = this.client.set(key, 0, (Object)value);
            AssertJUnit.assertTrue((boolean)((Boolean)f.get(60L, TimeUnit.SECONDS)));
            AssertJUnit.assertEquals((Object)this.client.get(key), (Object)value);
        }
        OperationFuture f = this.client.flush(delay);
        AssertJUnit.assertTrue((boolean)((Boolean)f.get(60L, TimeUnit.SECONDS)));
        TestingUtil.sleepThread((long)sleep);
        this.timeService.advance(sleep);
        for (int i = 1; i < 5; ++i) {
            String key = TestingUtil.k((Method)m, (String)("k" + i + "-"));
            AssertJUnit.assertNull((Object)this.client.get(key));
        }
    }

    public void testFlushAllNoReply(Method m) throws InterruptedException, ExecutionException, TimeoutException, IOException {
        this.withNoReply(m, "flush_all noreply\r\n");
    }

    public void testFlushAllPipeline() throws IOException {
        List<String> responses = this.sendMulti("flush_all\r\nget a\r\n", 2, true);
        AssertJUnit.assertEquals((int)responses.size(), (int)2);
        AssertJUnit.assertEquals((String)responses.get(0), (String)"OK");
        AssertJUnit.assertEquals((String)responses.get(1), (String)"END");
    }

    public void testVersion() {
        Map versions = this.client.getVersions();
        AssertJUnit.assertEquals((int)versions.size(), (int)1);
        String version = (String)versions.values().iterator().next();
        AssertJUnit.assertEquals((String)version, (String)Version.getVersion());
    }

    public void testIncrKeyLengthLimit() throws InterruptedException, ExecutionException, TimeoutException, IOException {
        String keyUnderLimit = TestingUtil.generateRandomString((int)249);
        OperationFuture f = this.client.set(keyUnderLimit, 0, (Object)"78");
        AssertJUnit.assertTrue((boolean)((Boolean)f.get(60L, TimeUnit.SECONDS)));
        AssertJUnit.assertEquals((Object)this.client.get(keyUnderLimit), (Object)"78");
        String keyInLimit = TestingUtil.generateRandomString((int)250);
        f = this.client.set(keyInLimit, 0, (Object)"89");
        AssertJUnit.assertTrue((boolean)((Boolean)f.get(60L, TimeUnit.SECONDS)));
        AssertJUnit.assertEquals((Object)this.client.get(keyInLimit), (Object)"89");
        String keyAboveLimit = TestingUtil.generateRandomString((int)251);
        String resp = this.incr(keyAboveLimit, 1);
        this.assertClientError(resp);
    }

    public void testGetKeyLengthLimit() throws IOException {
        String tooLongKey = TestingUtil.generateRandomString((int)251);
        String resp = this.send("get " + tooLongKey + "\r\n");
        this.assertClientError(resp);
        tooLongKey = TestingUtil.generateRandomString((int)251);
        resp = this.send("get k1 k2 k3 " + tooLongKey + "\r\n");
        this.assertClientError(resp);
    }

    public void testUnknownCommand() throws IOException {
        this.assertError(this.send("blah\r\n"));
        this.assertError(this.send("blah boo poo goo zoo\r\n"));
    }

    public void testUnknownCommandPipelined() throws IOException {
        List<String> responses = this.sendMulti("bogus\r\ndelete a\r\n", 2, true);
        AssertJUnit.assertEquals((int)responses.size(), (int)2);
        AssertJUnit.assertEquals((String)responses.get(0), (String)"ERROR");
        AssertJUnit.assertEquals((String)responses.get(1), (String)"NOT_FOUND");
    }

    public void testReadFullLineAfterLongKey() throws IOException {
        String key = TestingUtil.generateRandomString((int)300);
        String command = "add " + key + " 0 0 1\r\nget a\r\n";
        List<String> responses = this.sendMulti(command, 2, true);
        AssertJUnit.assertEquals((int)responses.size(), (int)2);
        AssertJUnit.assertTrue((boolean)responses.get(0).contains("CLIENT_ERROR"));
        AssertJUnit.assertEquals((String)responses.get(1), (String)"END");
    }

    public void testNegativeBytesLengthValue() throws IOException {
        this.assertClientError(this.send("set boo1 0 0 -1\r\n"));
        this.assertClientError(this.send("add boo2 0 0 -1\r\n"));
    }

    public void testFlagsIsUnsigned(Method m) throws IOException {
        String k = m.getName();
        this.assertClientError(this.send("set boo1 -1 0 0\r\n"));
        this.assertStored(this.send("set " + k + " 4294967295 0 0\r\n\r\n"));
        this.assertClientError(this.send("set boo2 4294967296 0 0\r\n"));
        this.assertClientError(this.send("set boo2 18446744073709551615 0 0\r\n"));
    }

    public void testIncrDecrIsUnsigned(Method m) throws IOException, InterruptedException, ExecutionException, TimeoutException {
        Object k = m.getName();
        OperationFuture f = this.client.set((String)k, 0, (Object)"0");
        AssertJUnit.assertTrue((boolean)((Boolean)f.get(60L, TimeUnit.SECONDS)));
        this.assertClientError(this.send("incr " + (String)k + " -1\r\n"));
        this.assertClientError(this.send("decr " + (String)k + " -1\r\n"));
        k = (String)k + "-1";
        f = this.client.set((String)k, 0, (Object)"0");
        AssertJUnit.assertTrue((boolean)((Boolean)f.get(60L, TimeUnit.SECONDS)));
        this.assertExpectedResponse(this.send("incr " + (String)k + " 18446744073709551615\r\n"), "18446744073709551615", true);
        k = (String)k + "-1";
        f = this.client.set((String)k, 0, (Object)"0");
        AssertJUnit.assertTrue((boolean)((Boolean)f.get(60L, TimeUnit.SECONDS)));
        this.assertClientError(this.send("incr " + (String)k + " 18446744073709551616\r\n"));
        this.assertClientError(this.send("decr " + (String)k + " 18446744073709551616\r\n"));
    }

    public void testVerbosity() throws IOException {
        this.assertClientError(this.send("verbosity\r\n"));
        this.assertClientError(this.send("verbosity 5\r\n"));
        this.assertClientError(this.send("verbosity 10 noreply\r\n"));
    }

    public void testQuit(Method m) throws InterruptedException, ExecutionException, TimeoutException, IOException {
        OperationFuture f = this.client.set(TestingUtil.k((Method)m), 0, (Object)"0");
        AssertJUnit.assertTrue((boolean)((Boolean)f.get(60L, TimeUnit.SECONDS)));
        this.sendNoWait("quit\r\n");
    }

    public void testSetBigSizeValue(Method m) throws InterruptedException, ExecutionException, TimeoutException {
        OperationFuture f = this.client.set(TestingUtil.k((Method)m), 0, (Object)TestingUtil.generateRandomString((int)0x100000).getBytes());
        AssertJUnit.assertTrue((boolean)((Boolean)f.get(60L, TimeUnit.SECONDS)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testStoreAsBinaryOverride() {
        ConfigurationBuilder builder = TestCacheManagerFactory.getDefaultCacheConfiguration((boolean)false);
        builder.memory().storageType(StorageType.BINARY);
        EmbeddedCacheManager cm = TestCacheManagerFactory.createCacheManager((ConfigurationBuilder)builder);
        Configuration cfg = builder.build();
        cm.defineConfiguration(new MemcachedServerConfigurationBuilder().build().defaultCacheName(), cfg);
        AssertJUnit.assertEquals((Object)StorageType.BINARY, (Object)cfg.memory().storageType());
        MemcachedServer testServer = MemcachedTestingUtil.startMemcachedTextServer(cm, this.server.getPort() + 33);
        try {
            Cache memcachedCache = cm.getCache(((MemcachedServerConfiguration)testServer.getConfiguration()).defaultCacheName());
            AssertJUnit.assertEquals((Object)StorageType.BINARY, (Object)memcachedCache.getCacheConfiguration().memory().storageType());
        }
        finally {
            cm.stop();
            testServer.stop();
        }
    }

    public void testDisableCache(Method m) throws InterruptedException, ExecutionException, TimeoutException {
        OperationFuture f = this.client.set(TestingUtil.k((Method)m), 0, (Object)TestingUtil.v((Method)m));
        AssertJUnit.assertTrue((boolean)((Boolean)f.get(60L, TimeUnit.SECONDS)));
        AssertJUnit.assertEquals((Object)TestingUtil.v((Method)m), (Object)this.client.get(TestingUtil.k((Method)m)));
        String cacheName = ((MemcachedServerConfiguration)this.server.getConfiguration()).defaultCacheName();
        this.server.getServerStateManager().ignoreCache(cacheName);
        try {
            this.client.get(TestingUtil.k((Method)m));
            AssertJUnit.fail((String)"Should have failed");
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.server.getServerStateManager().unignoreCache(cacheName);
        this.client.get(TestingUtil.k((Method)m));
    }

    public void testBufferOverflowCausesUnknownException() throws Exception {
        List<String> keys = Files.readAllLines(Paths.get(((Object)((Object)this)).getClass().getClassLoader().getResource("keys.txt").toURI()), StandardCharsets.UTF_8);
        for (String key : keys) {
            AssertJUnit.assertTrue((boolean)((Boolean)this.client.set(key, 0, (Object)"ISPN005003: UnknownOperationException").get()));
        }
    }

    private void addAndGet(Method m) throws InterruptedException, ExecutionException, TimeoutException {
        OperationFuture f = this.client.add(TestingUtil.k((Method)m), 0, (Object)TestingUtil.v((Method)m));
        AssertJUnit.assertTrue((boolean)((Boolean)f.get(60L, TimeUnit.SECONDS)));
        AssertJUnit.assertEquals((Object)this.client.get(TestingUtil.k((Method)m)), (Object)TestingUtil.v((Method)m));
    }

    private String incr(Method m, int by) throws IOException {
        return this.incr(TestingUtil.k((Method)m), by);
    }

    private String incr(String k, int by) throws IOException {
        return this.send("incr " + k + " " + by + "\r\n");
    }
}

