/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.memcached;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.spy.memcached.MemcachedClient;
import org.infinispan.Cache;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.server.core.test.ServerTestingUtil;
import org.infinispan.server.memcached.MemcachedServer;
import org.infinispan.server.memcached.test.MemcachedTestingUtil;
import org.infinispan.test.MultipleCacheManagersTest;
import org.testng.annotations.AfterClass;

abstract class MemcachedMultiNodeTest
extends MultipleCacheManagersTest {
    protected static String cacheName = "MemcachedReplSync";
    protected int nodeCount = 2;
    protected List<MemcachedServer> servers = new ArrayList<MemcachedServer>(this.nodeCount);
    protected List<MemcachedClient> clients = new ArrayList<MemcachedClient>(this.nodeCount);
    protected Map<Cache<String, byte[]>, MemcachedClient> cacheClient = new HashMap<Cache<String, byte[]>, MemcachedClient>();
    protected int timeout = 60;

    MemcachedMultiNodeTest() {
    }

    protected void createCacheManagers() {
        for (int i = 0; i < this.nodeCount; ++i) {
            this.cacheManagers.add(this.createCacheManager(i));
        }
        this.waitForClusterToForm();
        this.servers.add(MemcachedTestingUtil.startMemcachedTextServer((EmbeddedCacheManager)this.cacheManagers.get(0), cacheName));
        this.servers.add(MemcachedTestingUtil.startMemcachedTextServer((EmbeddedCacheManager)this.cacheManagers.get(1), this.servers.get(0).getPort() + 50, cacheName));
        this.servers.forEach(s -> {
            MemcachedClient client;
            try {
                client = MemcachedTestingUtil.createMemcachedClient(60000L, s.getPort());
            }
            catch (IOException e) {
                throw new AssertionError((Object)e);
            }
            this.clients.add(client);
            Cache cache = s.getCacheManager().getCache(cacheName);
            this.cacheClient.put((Cache<String, byte[]>)cache, client);
        });
    }

    protected abstract EmbeddedCacheManager createCacheManager(int var1);

    @AfterClass(alwaysRun=true)
    public void destroy() {
        super.destroy();
        log.debug((Object)"Test finished, close Hot Rod server");
        this.clients.forEach(MemcachedTestingUtil::killMemcachedClient);
        this.servers.forEach(ServerTestingUtil::killServer);
    }
}

