/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.memcached;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import net.spy.memcached.CASResponse;
import net.spy.memcached.CASValue;
import net.spy.memcached.MemcachedClient;
import org.infinispan.config.Configuration;
import org.infinispan.server.memcached.TextServer;
import org.infinispan.server.memcached.test.MemcachedTestingUtil;
import org.infinispan.test.MultipleCacheManagersTest;
import org.testng.annotations.AfterClass;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="server.memcached.ClusterTest")
public class ClusterTest
extends MultipleCacheManagersTest {
    MemcachedClient client1;
    MemcachedClient client2;
    TextServer server1;
    TextServer server2;

    protected void createCacheManagers() throws Throwable {
        Configuration replSync = this.getDefaultClusteredConfig(Configuration.CacheMode.REPL_SYNC);
        this.createClusteredCaches(2, "replSync", replSync);
        this.server1 = MemcachedTestingUtil.createMemcachedTextServer(this.cache(0, "replSync"));
        this.server1.start();
        this.server2 = MemcachedTestingUtil.createMemcachedTextServer(this.cache(1, "replSync"), this.server1.getPort() + 50);
        this.server2.start();
        this.client1 = MemcachedTestingUtil.createMemcachedClient(60000L, this.server1.getPort());
        this.client2 = MemcachedTestingUtil.createMemcachedClient(60000L, this.server2.getPort());
    }

    @AfterClass(alwaysRun=true)
    protected void destroyAfterClass() {
        this.server1.stop();
        this.server2.stop();
    }

    public void testReplicatedSet(Method m) throws Exception {
        Future f = this.client1.set(MemcachedTestingUtil.k(m), 0, MemcachedTestingUtil.v(m));
        assert (((Boolean)f.get(120L, TimeUnit.SECONDS)).booleanValue());
        assert (MemcachedTestingUtil.v(m).equals(this.client2.get(MemcachedTestingUtil.k(m))));
    }

    public void testReplicatedGetMultipleKeys(Method m) throws Exception {
        Future f1 = this.client1.set(MemcachedTestingUtil.k(m, "k1-"), 0, MemcachedTestingUtil.v(m, "v1-"));
        Future f2 = this.client1.set(MemcachedTestingUtil.k(m, "k2-"), 0, MemcachedTestingUtil.v(m, "v2-"));
        Future f3 = this.client1.set(MemcachedTestingUtil.k(m, "k3-"), 0, MemcachedTestingUtil.v(m, "v3-"));
        assert (((Boolean)f1.get(5L, TimeUnit.SECONDS)).booleanValue());
        assert (((Boolean)f2.get(5L, TimeUnit.SECONDS)).booleanValue());
        assert (((Boolean)f3.get(5L, TimeUnit.SECONDS)).booleanValue());
        Map ret = this.client2.getBulk(Arrays.asList(MemcachedTestingUtil.k(m, "k1-"), MemcachedTestingUtil.k(m, "k2-"), MemcachedTestingUtil.k(m, "k3-")));
        assert (ret.get(MemcachedTestingUtil.k(m, "k1-")).equals(MemcachedTestingUtil.v(m, "v1-")));
        assert (ret.get(MemcachedTestingUtil.k(m, "k2-")).equals(MemcachedTestingUtil.v(m, "v2-")));
        assert (ret.get(MemcachedTestingUtil.k(m, "k3-")).equals(MemcachedTestingUtil.v(m, "v3-")));
    }

    public void testReplicatedAdd(Method m) throws Exception {
        Future f = this.client1.add(MemcachedTestingUtil.k(m), 0, MemcachedTestingUtil.v(m));
        assert (((Boolean)f.get(5L, TimeUnit.SECONDS)).booleanValue());
        assert (MemcachedTestingUtil.v(m).equals(this.client2.get(MemcachedTestingUtil.k(m))));
    }

    public void testReplicatedReplace(Method m) throws Exception {
        Future f = this.client1.add(MemcachedTestingUtil.k(m), 0, MemcachedTestingUtil.v(m));
        assert (((Boolean)f.get(5L, TimeUnit.SECONDS)).booleanValue());
        assert (MemcachedTestingUtil.v(m).equals(this.client2.get(MemcachedTestingUtil.k(m))));
        f = this.client2.replace(MemcachedTestingUtil.k(m), 0, MemcachedTestingUtil.v(m, "k1-"));
        assert (((Boolean)f.get(5L, TimeUnit.SECONDS)).booleanValue());
        assert (MemcachedTestingUtil.v(m, "k1-").equals(this.client1.get(MemcachedTestingUtil.k(m))));
    }

    public void testReplicatedAppend(Method m) throws Exception {
        Future f = this.client1.add(MemcachedTestingUtil.k(m), 0, MemcachedTestingUtil.v(m));
        assert (((Boolean)f.get(5L, TimeUnit.SECONDS)).booleanValue());
        assert (MemcachedTestingUtil.v(m).equals(this.client2.get(MemcachedTestingUtil.k(m))));
        f = this.client2.append(0L, MemcachedTestingUtil.k(m), MemcachedTestingUtil.v(m, "v1-"));
        assert (((Boolean)f.get(5L, TimeUnit.SECONDS)).booleanValue());
        String expected = MemcachedTestingUtil.v(m).toString() + MemcachedTestingUtil.v(m, "v1-").toString();
        assert (expected.equals(this.client1.get(MemcachedTestingUtil.k(m))));
    }

    public void testReplicatedPrepend(Method m) throws Exception {
        Future f = this.client1.add(MemcachedTestingUtil.k(m), 0, MemcachedTestingUtil.v(m));
        assert (((Boolean)f.get(5L, TimeUnit.SECONDS)).booleanValue());
        assert (MemcachedTestingUtil.v(m).equals(this.client2.get(MemcachedTestingUtil.k(m))));
        f = this.client2.prepend(0L, MemcachedTestingUtil.k(m), MemcachedTestingUtil.v(m, "v1-"));
        assert (((Boolean)f.get(5L, TimeUnit.SECONDS)).booleanValue());
        String expected = MemcachedTestingUtil.v(m, "v1-").toString() + MemcachedTestingUtil.v(m).toString();
        assert (expected.equals(this.client1.get(MemcachedTestingUtil.k(m))));
    }

    public void testReplicatedGets(Method m) throws Exception {
        Future f = this.client1.set(MemcachedTestingUtil.k(m), 0, MemcachedTestingUtil.v(m));
        assert (((Boolean)f.get(5L, TimeUnit.SECONDS)).booleanValue());
        CASValue value = this.client2.gets(MemcachedTestingUtil.k(m));
        assert (MemcachedTestingUtil.v(m).equals(value.getValue()));
        assert (value.getCas() != 0L);
    }

    public void testReplicatedCasExists(Method m) throws Exception {
        Future f = this.client1.set(MemcachedTestingUtil.k(m), 0, MemcachedTestingUtil.v(m));
        assert (((Boolean)f.get(5L, TimeUnit.SECONDS)).booleanValue());
        CASValue value = this.client2.gets(MemcachedTestingUtil.k(m));
        assert (MemcachedTestingUtil.v(m).equals(value.getValue()));
        assert (value.getCas() != 0L);
        long old = value.getCas();
        CASResponse resp = this.client2.cas(MemcachedTestingUtil.k(m), value.getCas(), MemcachedTestingUtil.v(m, "v1-"));
        value = this.client1.gets(MemcachedTestingUtil.k(m));
        assert (MemcachedTestingUtil.v(m, "v1-").equals(value.getValue()));
        assert (value.getCas() != 0L);
        assert (value.getCas() != old);
        resp = this.client1.cas(MemcachedTestingUtil.k(m), old, MemcachedTestingUtil.v(m, "v2-"));
        assert (CASResponse.EXISTS == resp);
        resp = this.client2.cas(MemcachedTestingUtil.k(m), value.getCas(), MemcachedTestingUtil.v(m, "v2-"));
        assert (CASResponse.OK == resp);
    }

    public void testReplicatedDelete(Method m) throws Exception {
        Future f = this.client1.set(MemcachedTestingUtil.k(m), 0, MemcachedTestingUtil.v(m));
        assert (((Boolean)f.get(5L, TimeUnit.SECONDS)).booleanValue());
        f = this.client2.delete(MemcachedTestingUtil.k(m));
        assert (((Boolean)f.get(5L, TimeUnit.SECONDS)).booleanValue());
    }

    public void testReplicatedIncrement(Method m) throws Exception {
        Future f = this.client1.set(MemcachedTestingUtil.k(m), 0, (Object)"1");
        assert (((Boolean)f.get(5L, TimeUnit.SECONDS)).booleanValue());
        assert (2L == this.client2.incr(MemcachedTestingUtil.k(m), 1));
    }

    public void testReplicatedDecrement(Method m) throws Exception {
        Future f = this.client1.set(MemcachedTestingUtil.k(m), 0, (Object)"1");
        assert (((Boolean)f.get(5L, TimeUnit.SECONDS)).booleanValue());
        assert (0L == this.client2.decr(MemcachedTestingUtil.k(m), 1));
    }
}

