/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.memcached;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import net.spy.memcached.CASResponse;
import net.spy.memcached.CASValue;
import net.spy.memcached.MemcachedClient;
import org.infinispan.manager.CacheManager;
import org.infinispan.server.memcached.TextServer;
import org.infinispan.server.memcached.test.MemcachedTestingUtil;
import org.infinispan.test.SingleCacheManagerTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;
import org.testng.annotations.AfterClass;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="server.memcached.FunctionalTest")
public class FunctionalTest
extends SingleCacheManagerTest {
    static final Log log = LogFactory.getLog(FunctionalTest.class);
    MemcachedClient client;
    TextServer server;

    protected CacheManager createCacheManager() throws Exception {
        this.cacheManager = TestCacheManagerFactory.createLocalCacheManager();
        this.server = MemcachedTestingUtil.createMemcachedTextServer(this.cacheManager.getCache());
        this.server.start();
        this.client = MemcachedTestingUtil.createMemcachedClient(60000L, this.server.getPort());
        return this.cacheManager;
    }

    @AfterClass(alwaysRun=true)
    protected void destroyAfterClass() {
        super.destroyAfterClass();
        log.debug((Object)"Test finished, close memcached server");
        this.server.stop();
    }

    public void testSetBasic(Method m) throws Exception {
        Future f = this.client.set(MemcachedTestingUtil.k(m), 0, MemcachedTestingUtil.v(m));
        assert (((Boolean)f.get(5L, TimeUnit.SECONDS)).booleanValue());
        assert (MemcachedTestingUtil.v(m).equals(this.client.get(MemcachedTestingUtil.k(m))));
    }

    public void testSetWithExpirySeconds(Method m) throws Exception {
        Future f = this.client.set(MemcachedTestingUtil.k(m), 1, MemcachedTestingUtil.v(m));
        assert (((Boolean)f.get(5L, TimeUnit.SECONDS)).booleanValue());
        Thread.sleep(1100L);
        assert (null == this.client.get(MemcachedTestingUtil.k(m)));
    }

    public void testSetWithExpiryUnixTime(Method m) throws Exception {
        int future = (int)TimeUnit.MILLISECONDS.toSeconds(System.currentTimeMillis() + 1000L);
        Future f = this.client.set(MemcachedTestingUtil.k(m), future, MemcachedTestingUtil.v(m));
        assert (((Boolean)f.get(5L, TimeUnit.SECONDS)).booleanValue());
        Thread.sleep(1100L);
        assert (null == this.client.get(MemcachedTestingUtil.k(m)));
    }

    public void testGetMultipleKeys(Method m) throws Exception {
        Future f1 = this.client.set(MemcachedTestingUtil.k(m, "k1-"), 0, MemcachedTestingUtil.v(m, "v1-"));
        Future f2 = this.client.set(MemcachedTestingUtil.k(m, "k2-"), 0, MemcachedTestingUtil.v(m, "v2-"));
        Future f3 = this.client.set(MemcachedTestingUtil.k(m, "k3-"), 0, MemcachedTestingUtil.v(m, "v3-"));
        assert (((Boolean)f1.get(5L, TimeUnit.SECONDS)).booleanValue());
        assert (((Boolean)f2.get(5L, TimeUnit.SECONDS)).booleanValue());
        assert (((Boolean)f3.get(5L, TimeUnit.SECONDS)).booleanValue());
        Map ret = this.client.getBulk(Arrays.asList(MemcachedTestingUtil.k(m, "k1-"), MemcachedTestingUtil.k(m, "k2-"), MemcachedTestingUtil.k(m, "k3-")));
        assert (ret.get(MemcachedTestingUtil.k(m, "k1-")).equals(MemcachedTestingUtil.v(m, "v1-")));
        assert (ret.get(MemcachedTestingUtil.k(m, "k2-")).equals(MemcachedTestingUtil.v(m, "v2-")));
        assert (ret.get(MemcachedTestingUtil.k(m, "k3-")).equals(MemcachedTestingUtil.v(m, "v3-")));
    }

    public void testAddBasic(Method m) throws Exception {
        Future f = this.client.add(MemcachedTestingUtil.k(m), 0, MemcachedTestingUtil.v(m));
        assert (((Boolean)f.get(5L, TimeUnit.SECONDS)).booleanValue());
        assert (MemcachedTestingUtil.v(m).equals(this.client.get(MemcachedTestingUtil.k(m))));
    }

    public void testAddWithExpirySeconds(Method m) throws Exception {
        Future f = this.client.add(MemcachedTestingUtil.k(m), 1, MemcachedTestingUtil.v(m));
        assert (((Boolean)f.get(5L, TimeUnit.SECONDS)).booleanValue());
        Thread.sleep(1100L);
        assert (null == this.client.get(MemcachedTestingUtil.k(m)));
        f = this.client.add(MemcachedTestingUtil.k(m), 0, MemcachedTestingUtil.v(m, "k1-"));
        assert (((Boolean)f.get(5L, TimeUnit.SECONDS)).booleanValue());
        assert (MemcachedTestingUtil.v(m, "k1-").equals(this.client.get(MemcachedTestingUtil.k(m))));
    }

    public void testAddWithExpiryUnixTime(Method m) throws Exception {
        int future = (int)TimeUnit.MILLISECONDS.toSeconds(System.currentTimeMillis() + 1000L);
        Future f = this.client.add(MemcachedTestingUtil.k(m), future, MemcachedTestingUtil.v(m));
        assert (((Boolean)f.get(5L, TimeUnit.SECONDS)).booleanValue());
        Thread.sleep(1100L);
        assert (null == this.client.get(MemcachedTestingUtil.k(m)));
        f = this.client.add(MemcachedTestingUtil.k(m), 0, MemcachedTestingUtil.v(m, "k1-"));
        assert (((Boolean)f.get(5L, TimeUnit.SECONDS)).booleanValue());
        assert (MemcachedTestingUtil.v(m, "k1-").equals(this.client.get(MemcachedTestingUtil.k(m))));
    }

    public void testNotAddIsPresent(Method m) throws Exception {
        Future f = this.client.add(MemcachedTestingUtil.k(m), 0, MemcachedTestingUtil.v(m));
        assert (((Boolean)f.get(5L, TimeUnit.SECONDS)).booleanValue());
        assert (MemcachedTestingUtil.v(m).equals(this.client.get(MemcachedTestingUtil.k(m))));
        f = this.client.add(MemcachedTestingUtil.k(m), 0, MemcachedTestingUtil.v(m, "k1-"));
        assert (!((Boolean)f.get(5L, TimeUnit.SECONDS)).booleanValue());
        assert (this.client.get(MemcachedTestingUtil.k(m)).equals(MemcachedTestingUtil.v(m)));
    }

    public void testReplaceBasic(Method m) throws Exception {
        Future f = this.client.add(MemcachedTestingUtil.k(m), 0, MemcachedTestingUtil.v(m));
        assert (((Boolean)f.get(5L, TimeUnit.SECONDS)).booleanValue());
        assert (MemcachedTestingUtil.v(m).equals(this.client.get(MemcachedTestingUtil.k(m))));
        f = this.client.replace(MemcachedTestingUtil.k(m), 0, MemcachedTestingUtil.v(m, "k1-"));
        assert (((Boolean)f.get(5L, TimeUnit.SECONDS)).booleanValue());
        assert (MemcachedTestingUtil.v(m, "k1-").equals(this.client.get(MemcachedTestingUtil.k(m))));
    }

    public void testNotReplaceIsNotPresent(Method m) throws Exception {
        Future f = this.client.replace(MemcachedTestingUtil.k(m), 0, MemcachedTestingUtil.v(m));
        assert (!((Boolean)f.get(5L, TimeUnit.SECONDS)).booleanValue());
        assert (null == this.client.get(MemcachedTestingUtil.k(m)));
    }

    public void testReplaceWithExpirySeconds(Method m) throws Exception {
        Future f = this.client.add(MemcachedTestingUtil.k(m), 0, MemcachedTestingUtil.v(m));
        assert (((Boolean)f.get(5L, TimeUnit.SECONDS)).booleanValue());
        assert (MemcachedTestingUtil.v(m).equals(this.client.get(MemcachedTestingUtil.k(m))));
        f = this.client.replace(MemcachedTestingUtil.k(m), 1, MemcachedTestingUtil.v(m, "k1-"));
        assert (((Boolean)f.get(5L, TimeUnit.SECONDS)).booleanValue());
        assert (this.client.get(MemcachedTestingUtil.k(m)).equals(MemcachedTestingUtil.v(m, "k1-")));
        Thread.sleep(1100L);
        assert (null == this.client.get(MemcachedTestingUtil.k(m)));
    }

    public void testReplaceWithExpiryUnixTime(Method m) throws Exception {
        Future f = this.client.add(MemcachedTestingUtil.k(m), 0, MemcachedTestingUtil.v(m));
        assert (((Boolean)f.get(5L, TimeUnit.SECONDS)).booleanValue());
        assert (MemcachedTestingUtil.v(m).equals(this.client.get(MemcachedTestingUtil.k(m))));
        int future = (int)TimeUnit.MILLISECONDS.toSeconds(System.currentTimeMillis() + 1000L);
        f = this.client.replace(MemcachedTestingUtil.k(m), future, MemcachedTestingUtil.v(m, "k1-"));
        assert (((Boolean)f.get(5L, TimeUnit.SECONDS)).booleanValue());
        assert (this.client.get(MemcachedTestingUtil.k(m)).equals(MemcachedTestingUtil.v(m, "k1-")));
        Thread.sleep(1100L);
        assert (null == this.client.get(MemcachedTestingUtil.k(m)));
    }

    public void testAppendBasic(Method m) throws Exception {
        Future f = this.client.add(MemcachedTestingUtil.k(m), 0, MemcachedTestingUtil.v(m));
        assert (((Boolean)f.get(5L, TimeUnit.SECONDS)).booleanValue());
        assert (MemcachedTestingUtil.v(m).equals(this.client.get(MemcachedTestingUtil.k(m))));
        f = this.client.append(0L, MemcachedTestingUtil.k(m), MemcachedTestingUtil.v(m, "v1-"));
        assert (((Boolean)f.get(5L, TimeUnit.SECONDS)).booleanValue());
        String expected = MemcachedTestingUtil.v(m).toString() + MemcachedTestingUtil.v(m, "v1-").toString();
        assert (expected.equals(this.client.get(MemcachedTestingUtil.k(m))));
    }

    public void testPrependBasic(Method m) throws Exception {
        Future f = this.client.add(MemcachedTestingUtil.k(m), 0, MemcachedTestingUtil.v(m));
        assert (((Boolean)f.get(5L, TimeUnit.SECONDS)).booleanValue());
        assert (MemcachedTestingUtil.v(m).equals(this.client.get(MemcachedTestingUtil.k(m))));
        f = this.client.prepend(0L, MemcachedTestingUtil.k(m), MemcachedTestingUtil.v(m, "v1-"));
        assert (((Boolean)f.get(5L, TimeUnit.SECONDS)).booleanValue());
        String expected = MemcachedTestingUtil.v(m, "v1-").toString() + MemcachedTestingUtil.v(m).toString();
        assert (expected.equals(this.client.get(MemcachedTestingUtil.k(m))));
    }

    public void testGetsBasic(Method m) throws Exception {
        Future f = this.client.set(MemcachedTestingUtil.k(m), 0, MemcachedTestingUtil.v(m));
        assert (((Boolean)f.get(5L, TimeUnit.SECONDS)).booleanValue());
        CASValue value = this.client.gets(MemcachedTestingUtil.k(m));
        assert (MemcachedTestingUtil.v(m).equals(value.getValue()));
        assert (value.getCas() != 0L);
    }

    public void testCasBasic(Method m) throws Exception {
        Future f = this.client.set(MemcachedTestingUtil.k(m), 0, MemcachedTestingUtil.v(m));
        assert (((Boolean)f.get(60L, TimeUnit.SECONDS)).booleanValue());
        CASValue value = this.client.gets(MemcachedTestingUtil.k(m));
        assert (MemcachedTestingUtil.v(m).equals(value.getValue()));
        assert (value.getCas() != 0L);
        CASResponse resp = this.client.cas(MemcachedTestingUtil.k(m), value.getCas(), MemcachedTestingUtil.v(m, "v1-"));
        assert (CASResponse.OK == resp);
    }

    public void testCasNotFound(Method m) throws Exception {
        Future f = this.client.set(MemcachedTestingUtil.k(m), 0, MemcachedTestingUtil.v(m));
        assert (((Boolean)f.get(5L, TimeUnit.SECONDS)).booleanValue());
        CASValue value = this.client.gets(MemcachedTestingUtil.k(m));
        assert (MemcachedTestingUtil.v(m).equals(value.getValue()));
        assert (value.getCas() != 0L);
        CASResponse resp = this.client.cas(MemcachedTestingUtil.k(m, "k1-"), value.getCas(), MemcachedTestingUtil.v(m, "v1-"));
        assert (CASResponse.NOT_FOUND == resp);
    }

    public void testCasExists(Method m) throws Exception {
        Future f = this.client.set(MemcachedTestingUtil.k(m), 0, MemcachedTestingUtil.v(m));
        assert (((Boolean)f.get(5L, TimeUnit.SECONDS)).booleanValue());
        CASValue value = this.client.gets(MemcachedTestingUtil.k(m));
        assert (MemcachedTestingUtil.v(m).equals(value.getValue()));
        assert (value.getCas() != 0L);
        long old = value.getCas();
        CASResponse resp = this.client.cas(MemcachedTestingUtil.k(m), value.getCas(), MemcachedTestingUtil.v(m, "v1-"));
        value = this.client.gets(MemcachedTestingUtil.k(m));
        assert (MemcachedTestingUtil.v(m, "v1-").equals(value.getValue()));
        assert (value.getCas() != 0L);
        assert (value.getCas() != old);
        resp = this.client.cas(MemcachedTestingUtil.k(m), old, MemcachedTestingUtil.v(m, "v2-"));
        assert (CASResponse.EXISTS == resp);
        resp = this.client.cas(MemcachedTestingUtil.k(m), value.getCas(), MemcachedTestingUtil.v(m, "v2-"));
        assert (CASResponse.OK == resp);
    }

    public void testDeleteBasic(Method m) throws Exception {
        Future f = this.client.set(MemcachedTestingUtil.k(m), 0, MemcachedTestingUtil.v(m));
        assert (((Boolean)f.get(5L, TimeUnit.SECONDS)).booleanValue());
        f = this.client.delete(MemcachedTestingUtil.k(m));
        assert (((Boolean)f.get(5L, TimeUnit.SECONDS)).booleanValue());
    }

    public void testDeleteDoesNotExist(Method m) throws Exception {
        Future f = this.client.delete(MemcachedTestingUtil.k(m));
        assert (!((Boolean)f.get(5L, TimeUnit.SECONDS)).booleanValue());
    }

    public void testIncrementBasic(Method m) throws Exception {
        Future f = this.client.set(MemcachedTestingUtil.k(m), 0, (Object)"1");
        assert (((Boolean)f.get(5L, TimeUnit.SECONDS)).booleanValue());
        long result = this.client.incr(MemcachedTestingUtil.k(m), 1);
        assert (2L == result) : "Result was " + result;
    }

    public void testIncrementTriple(Method m) throws Exception {
        Future f = this.client.set(MemcachedTestingUtil.k(m), 0, (Object)"1");
        assert (((Boolean)f.get(5L, TimeUnit.SECONDS)).booleanValue());
        assert (2L == this.client.incr(MemcachedTestingUtil.k(m), 1));
        assert (4L == this.client.incr(MemcachedTestingUtil.k(m), 2));
        assert (8L == this.client.incr(MemcachedTestingUtil.k(m), 4));
    }

    public void testIncrementNotExist(Method m) throws Exception {
        assert (-1L == this.client.incr(MemcachedTestingUtil.k(m), 1));
    }

    public void testIncrementIntegerMax(Method m) throws Exception {
        Future f = this.client.set(MemcachedTestingUtil.k(m), 0, (Object)"0");
        assert (((Boolean)f.get(5L, TimeUnit.SECONDS)).booleanValue());
        assert (Integer.MAX_VALUE == this.client.incr(MemcachedTestingUtil.k(m), Integer.MAX_VALUE));
    }

    public void testIncrementBeyondIntegerMax(Method m) throws Exception {
        Future f = this.client.set(MemcachedTestingUtil.k(m), 0, (Object)"1");
        assert (((Boolean)f.get(5L, TimeUnit.SECONDS)).booleanValue());
        long newValue = this.client.incr(MemcachedTestingUtil.k(m), Integer.MAX_VALUE);
        assert (0x80000000L == newValue) : "New value not expected: " + newValue;
    }

    public void testDecrementBasic(Method m) throws Exception {
        Future f = this.client.set(MemcachedTestingUtil.k(m), 0, (Object)"1");
        assert (((Boolean)f.get(5L, TimeUnit.SECONDS)).booleanValue());
        assert (0L == this.client.decr(MemcachedTestingUtil.k(m), 1));
    }

    public void testDecrementTriple(Method m) throws Exception {
        Future f = this.client.set(MemcachedTestingUtil.k(m), 0, (Object)"8");
        assert (((Boolean)f.get(5L, TimeUnit.SECONDS)).booleanValue());
        assert (7L == this.client.decr(MemcachedTestingUtil.k(m), 1));
        assert (5L == this.client.decr(MemcachedTestingUtil.k(m), 2));
        assert (1L == this.client.decr(MemcachedTestingUtil.k(m), 4));
    }

    public void testDecrementNotExist(Method m) throws Exception {
        assert (-1L == this.client.decr(MemcachedTestingUtil.k(m), 1));
    }

    public void testDecrementBelowZero(Method m) throws Exception {
        Future f = this.client.set(MemcachedTestingUtil.k(m), 0, (Object)"1");
        assert (((Boolean)f.get(5L, TimeUnit.SECONDS)).booleanValue());
        long newValue = this.client.decr(MemcachedTestingUtil.k(m), 2);
        assert (0L == newValue) : "Unexpected result: " + newValue;
    }

    public void testFlushAll(Method m) throws Exception {
        Future f;
        String key;
        int i;
        for (i = 0; i < 5; ++i) {
            key = MemcachedTestingUtil.k(m, "k" + i + "-");
            Object value = MemcachedTestingUtil.v(m, "v" + i + "-");
            f = this.client.set(key, 0, value);
            assert (((Boolean)f.get(5L, TimeUnit.SECONDS)).booleanValue());
            assert (value.equals(this.client.get(key)));
        }
        f = this.client.flush();
        assert (((Boolean)f.get(5L, TimeUnit.SECONDS)).booleanValue());
        for (i = 0; i < 5; ++i) {
            key = MemcachedTestingUtil.k(m, "k" + i + "-");
            assert (null == this.client.get(key));
        }
    }

    public void testFlushAllDelayed(Method m) throws Exception {
        Future f;
        String key;
        int i;
        for (i = 0; i < 5; ++i) {
            key = MemcachedTestingUtil.k(m, "k" + i + "-");
            Object value = MemcachedTestingUtil.v(m, "v" + i + "-");
            f = this.client.set(key, 0, value);
            assert (((Boolean)f.get(5L, TimeUnit.SECONDS)).booleanValue());
            assert (value.equals(this.client.get(key)));
        }
        f = this.client.flush(2);
        assert (((Boolean)f.get(5L, TimeUnit.SECONDS)).booleanValue());
        TestingUtil.sleepThread((long)2200L);
        for (i = 0; i < 5; ++i) {
            key = MemcachedTestingUtil.k(m, "k" + i + "-");
            assert (null == this.client.get(key));
        }
    }

    public void testVersion() throws Exception {
        Map versions = this.client.getVersions();
        assert (1 == versions.size());
        String version = (String)versions.values().iterator().next();
        assert ("4.1.0.ALPHA1".equals(version));
    }
}

