/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.memcached;

import java.lang.reflect.Method;
import java.util.Map;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import net.spy.memcached.CASValue;
import net.spy.memcached.MemcachedClient;
import org.infinispan.manager.CacheManager;
import org.infinispan.server.memcached.TextServer;
import org.infinispan.server.memcached.test.MemcachedTestingUtil;
import org.infinispan.test.SingleCacheManagerTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.annotations.AfterClass;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="server.memcached.StatsTest")
public class StatsTest
extends SingleCacheManagerTest {
    static final String JMX_DOMAIN = StatsTest.class.getSimpleName();
    MemcachedClient client;
    TextServer server;

    protected CacheManager createCacheManager() throws Exception {
        this.cacheManager = TestCacheManagerFactory.createCacheManagerEnforceJmxDomain((String)JMX_DOMAIN);
        this.server = MemcachedTestingUtil.createMemcachedTextServer(this.cacheManager.getCache());
        this.server.start();
        this.client = MemcachedTestingUtil.createMemcachedClient(60000L, this.server.getPort());
        return this.cacheManager;
    }

    @AfterClass(alwaysRun=true)
    protected void destroyAfterClass() {
        super.destroyAfterClass();
        this.server.stop();
    }

    public void testUnsupportedStats(Method m) throws Exception {
        Map<String, String> stats = this.getStats();
        assert ("0".equals(stats.get("pid")));
        assert ("0".equals(stats.get("pointer_size")));
        assert ("0".equals(stats.get("rusage_user")));
        assert ("0".equals(stats.get("rusage_system")));
        assert ("0".equals(stats.get("bytes")));
        assert ("0".equals(stats.get("connection_structures")));
        assert ("0".equals(stats.get("auth_cmds")));
        assert ("0".equals(stats.get("auth_errors")));
        assert ("0".equals(stats.get("limit_maxbytes")));
        assert ("0".equals(stats.get("conn_yields")));
    }

    public void testUncomparableStats(Method m) throws Exception {
        TestingUtil.sleepThread((long)TimeUnit.SECONDS.toMillis(1L));
        Map<String, String> stats = this.getStats();
        assert (!"0".equals(stats.get("uptime")));
        assert (!"0".equals(stats.get("time")));
        assert (!stats.get("uptime").equals(stats.get("time")));
    }

    public void testStaticStats(Method m) throws Exception {
        Map<String, String> stats = this.getStats();
        assert ("4.1.0.ALPHA1".equals(stats.get("version")));
    }

    public void testTodoStats() throws Exception {
        Map<String, String> stats = this.getStats();
        assert ("0".equals(stats.get("curr_connections")));
        assert ("0".equals(stats.get("total_connections")));
        assert ("0".equals(stats.get("bytes_read")));
        assert ("0".equals(stats.get("bytes_written")));
        assert ("0".equals(stats.get("threads")));
    }

    public void testStats(Method m) throws Exception {
        Map<String, String> stats = this.getStats();
        assert ("0".equals(stats.get("cmd_set")));
        assert ("0".equals(stats.get("cmd_get")));
        assert ("0".equals(stats.get("get_hits")));
        assert ("0".equals(stats.get("get_misses")));
        assert ("0".equals(stats.get("delete_hits")));
        assert ("0".equals(stats.get("delete_misses")));
        assert ("0".equals(stats.get("curr_items")));
        assert ("0".equals(stats.get("total_items")));
        assert ("0".equals(stats.get("incr_misses")));
        assert ("0".equals(stats.get("incr_hits")));
        assert ("0".equals(stats.get("decr_misses")));
        assert ("0".equals(stats.get("decr_hits")));
        assert ("0".equals(stats.get("cas_misses")));
        assert ("0".equals(stats.get("cas_hits")));
        assert ("0".equals(stats.get("cas_badval")));
        Future f = this.client.set(MemcachedTestingUtil.k(m), 0, MemcachedTestingUtil.v(m));
        assert (((Boolean)f.get(5L, TimeUnit.SECONDS)).booleanValue());
        assert (MemcachedTestingUtil.v(m).equals(this.client.get(MemcachedTestingUtil.k(m))));
        f = this.client.set(MemcachedTestingUtil.k(m, "k1-"), 0, MemcachedTestingUtil.v(m, "v1-"));
        assert (((Boolean)f.get(5L, TimeUnit.SECONDS)).booleanValue());
        assert (MemcachedTestingUtil.v(m, "v1-").equals(this.client.get(MemcachedTestingUtil.k(m, "k1-"))));
        stats = this.getStats();
        assert ("2".equals(stats.get("cmd_set")));
        assert ("4".equals(stats.get("cmd_get")));
        assert ("2".equals(stats.get("get_hits")));
        assert ("2".equals(stats.get("get_misses")));
        assert ("0".equals(stats.get("delete_hits")));
        assert ("0".equals(stats.get("delete_misses")));
        assert ("2".equals(stats.get("curr_items")));
        assert ("2".equals(stats.get("total_items")));
        f = this.client.delete(MemcachedTestingUtil.k(m, "k1-"));
        assert (((Boolean)f.get(5L, TimeUnit.SECONDS)).booleanValue());
        stats = this.getStats();
        assert ("1".equals(stats.get("curr_items")));
        assert ("2".equals(stats.get("total_items")));
        assert ("1".equals(stats.get("delete_hits")));
        assert ("0".equals(stats.get("delete_misses")));
        assert (null == this.client.get(MemcachedTestingUtil.k(m, "k99-")));
        stats = this.getStats();
        assert ("2".equals(stats.get("get_hits")));
        assert ("3".equals(stats.get("get_misses")));
        f = this.client.delete(MemcachedTestingUtil.k(m, "k99-"));
        assert (!((Boolean)f.get(5L, TimeUnit.SECONDS)).booleanValue());
        stats = this.getStats();
        assert ("1".equals(stats.get("delete_hits")));
        assert ("1".equals(stats.get("delete_misses")));
        int future = (int)TimeUnit.MILLISECONDS.toSeconds(System.currentTimeMillis() + 1000L);
        f = this.client.set(MemcachedTestingUtil.k(m, "k3-"), future, MemcachedTestingUtil.v(m, "v3-"));
        assert (((Boolean)f.get(5L, TimeUnit.SECONDS)).booleanValue());
        Thread.sleep(1100L);
        assert (null == this.client.get(MemcachedTestingUtil.k(m, "k3-")));
        stats = this.getStats();
        assert ("1".equals(stats.get("curr_items")));
        assert ("3".equals(stats.get("total_items")));
        this.client.incr(MemcachedTestingUtil.k(m, "k4-"), 1);
        stats = this.getStats();
        assert ("1".equals(stats.get("incr_misses")));
        assert ("0".equals(stats.get("incr_hits")));
        f = this.client.set(MemcachedTestingUtil.k(m, "k4-"), 0, (Object)"1");
        assert (((Boolean)f.get(5L, TimeUnit.SECONDS)).booleanValue());
        this.client.incr(MemcachedTestingUtil.k(m, "k4-"), 1);
        this.client.incr(MemcachedTestingUtil.k(m, "k4-"), 2);
        this.client.incr(MemcachedTestingUtil.k(m, "k4-"), 4);
        stats = this.getStats();
        assert ("1".equals(stats.get("incr_misses")));
        assert ("3".equals(stats.get("incr_hits")));
        this.client.decr(MemcachedTestingUtil.k(m, "k5-"), 1);
        stats = this.getStats();
        assert ("1".equals(stats.get("decr_misses")));
        assert ("0".equals(stats.get("decr_hits")));
        f = this.client.set(MemcachedTestingUtil.k(m, "k5-"), 0, (Object)"8");
        assert (((Boolean)f.get(5L, TimeUnit.SECONDS)).booleanValue());
        this.client.decr(MemcachedTestingUtil.k(m, "k5-"), 1);
        this.client.decr(MemcachedTestingUtil.k(m, "k5-"), 2);
        this.client.decr(MemcachedTestingUtil.k(m, "k5-"), 4);
        stats = this.getStats();
        assert ("1".equals(stats.get("decr_misses")));
        assert ("3".equals(stats.get("decr_hits")));
        this.client.cas(MemcachedTestingUtil.k(m, "k6-"), 1234L, MemcachedTestingUtil.v(m, "v6-"));
        stats = this.getStats();
        assert ("1".equals(stats.get("cas_misses")));
        assert ("0".equals(stats.get("cas_hits")));
        assert ("0".equals(stats.get("cas_badval")));
        f = this.client.set(MemcachedTestingUtil.k(m, "k6-"), 0, MemcachedTestingUtil.v(m, "v6-"));
        assert (((Boolean)f.get(5L, TimeUnit.SECONDS)).booleanValue());
        CASValue value = this.client.gets(MemcachedTestingUtil.k(m, "k6-"));
        long old = value.getCas();
        this.client.cas(MemcachedTestingUtil.k(m, "k6-"), value.getCas(), MemcachedTestingUtil.v(m, "v66-"));
        stats = this.getStats();
        assert ("1".equals(stats.get("cas_misses")));
        assert ("1".equals(stats.get("cas_hits")));
        assert ("0".equals(stats.get("cas_badval")));
        this.client.cas(MemcachedTestingUtil.k(m, "k6-"), old, MemcachedTestingUtil.v(m, "v66-"));
        stats = this.getStats();
        assert ("1".equals(stats.get("cas_misses")));
        assert ("1".equals(stats.get("cas_hits")));
        assert ("1".equals(stats.get("cas_badval")));
    }

    private Map<String, String> getStats() {
        Map stats = this.client.getStats();
        assert (1 == stats.size());
        return (Map)stats.values().iterator().next();
    }
}

